/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.ls.exporter;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.v8.dt.ls.exporter.internal.LsPlugin;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;

@Singleton
public class LsBmExporter {
    protected static final String TRANS_FILE_COMMENT_PREFFIX = "Translations for:";
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    @Inject
    private ITranslationStorageManager storageManager;
    @Inject
    private IFeatureValueCollectingService featureValueCollectingService;

    public static LsBmExporter create() {
        return (LsBmExporter)LsPlugin.getDefault().getInjector().getInstance(LsBmExporter.class);
    }

    public void export(IBmObject bmObject, IFile file, Map<IFile, byte[]> exportedExtraFiles) {
        StorageID storageID;
        IProject project = this.resourceLookup.getProject((EObject)bmObject);
        ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(project, storageID = this.storageSettingsManager.getSettingsOrDefault(project).getEdit().getStorageId());
        if (storage == null || !(storage instanceof ITranslationStorageProvider.ContextStorage)) {
            return;
        }
        ITranslationStorageProvider.ContextStorage contextStorage = (ITranslationStorageProvider.ContextStorage)storage;
        ITranslatingProject translatingProject = this.translatingProjectManager.getProject(project);
        if (!translatingProject.isTranslating()) {
            return;
        }
        TranslationSource source = TranslationUtils.getTranslationSource((Object)bmObject);
        HashSet collectingLanguages = Sets.newHashSet((Iterable)translatingProject.getInterfaceLanguages());
        CollectingParameters parameters = CollectingParameters.builder().collectChildObjects().collectInterface().collectComputedStrings().collectEmptyValue().setLanguages((Set)collectingLanguages).continueAfterFirstError().disableCache().build();
        ArrayList affectedKeys = new ArrayList();
        this.featureValueCollectingService.forEachCollected(source, (ICollectingParameters)parameters, (IProgressMonitor)new NullProgressMonitor(), (sourceObject, featureValue) -> {
            affectedKeys.add(featureValue.getContextKey());
            for (TranslateLanguage language : collectingLanguages) {
                String translation = (String)featureValue.getLocalStrings().get(language.getLanguageCode());
                if (StringUtils.isNotEmpty((String)translation)) {
                    contextStorage.setTranslation(featureValue.getContextKey(), language, translation, false);
                    continue;
                }
                contextStorage.removeTranslation(featureValue.getContextKey(), language, false);
            }
        });
        for (TranslateLanguage language : collectingLanguages) {
            Map hashes = contextStorage.saveFiles(affectedKeys, language, Hashing.sha256());
            if (hashes.isEmpty()) continue;
            hashes.forEach((iFile, hash) -> exportedExtraFiles.put((IFile)iFile, (byte[])hash));
        }
    }
}

