/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.emf.collector;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.emf.collector.EFeatureValue;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.settings.FeatureSettings;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class EmfFeatureValue
implements EFeatureValue {
    private static final long serialVersionUID = 2592930132885009869L;
    private final String platformResource;
    private transient URI resourceUri;
    private final EFeatureSettings settings;
    private final FeatureKey featureKey;
    private final String featureValue;
    private final boolean computedValue;
    private final boolean isUnknown;
    private final boolean isTag;
    private transient IPath id;
    private final Map<String, String> localStrings = new HashMap<String, String>();

    public static EmfFeatureValue create(URI resourceUri, EFeatureSettings settings, FeatureKey featureKey, String featureValue, boolean computedValue, boolean isUnknown, boolean isTag) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Resource URI cannot be null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("Feature settings cannot be null");
        }
        if (featureKey == null) {
            throw new IllegalArgumentException("Feature key cannot be null");
        }
        return new EmfFeatureValue(resourceUri, settings, featureKey, featureValue, computedValue, isUnknown, isTag);
    }

    protected EmfFeatureValue(URI objectUri, EFeatureSettings settings, FeatureKey featureKey, String value, boolean computedValue, boolean isUnknown, boolean isTag) {
        this.resourceUri = objectUri.trimFragment();
        this.platformResource = this.resourceUri.toPlatformString(true);
        this.settings = settings;
        this.featureKey = featureKey;
        this.computedValue = computedValue;
        this.featureValue = value;
        this.isUnknown = isUnknown;
        this.isTag = isTag;
    }

    public IPath getResourceId() {
        if (this.id == null) {
            if (this.getResourceUri().isPlatformResource()) {
                Path path = new Path(this.getResourceUri().toPlatformString(true));
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                this.id = file.getProjectRelativePath();
            } else {
                String resourceId = this.getResourceUri().toString();
                this.id = Path.isValidPosixPath((String)resourceId) ? new Path(resourceId) : Path.EMPTY;
            }
        }
        return this.id;
    }

    @Override
    public URI getResourceUri() {
        if (this.resourceUri == null) {
            this.resourceUri = URI.createPlatformResourceURI((String)this.platformResource, (boolean)true);
        }
        return this.resourceUri;
    }

    public String getValue() {
        return this.featureValue;
    }

    public FeatureSettings getFeatureSettings() {
        return this.settings;
    }

    public FeatureKey getFeatureKey() {
        return this.featureKey;
    }

    public boolean isComputedValue() {
        return this.computedValue;
    }

    public boolean isUnknown() {
        return this.isUnknown;
    }

    public boolean isTag() {
        return this.isTag;
    }

    public Map<String, String> getLocalStrings() {
        return this.localStrings;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.featureKey == null ? 0 : this.featureKey.hashCode());
        result = 31 * result + (this.resourceUri == null ? 0 : this.resourceUri.hashCode());
        result = 31 * result + (this.settings == null || this.settings.getEFeature() == null ? 0 : this.settings.getEFeature().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmfFeatureValue)) {
            return false;
        }
        EmfFeatureValue other = (EmfFeatureValue)obj;
        if (this.featureKey == null ? other.featureKey != null : !this.featureKey.equals(other.featureKey)) {
            return false;
        }
        if (this.resourceUri == null ? other.resourceUri != null : !this.resourceUri.equals(other.resourceUri)) {
            return false;
        }
        return !(this.settings == null ? other.settings != null : (this.settings.getEFeature() == null ? other.settings.getEFeature() != null : !this.settings.getEFeature().equals(other.settings.getEFeature())));
    }

    public String toString() {
        return String.valueOf(this.featureKey) + ":" + this.featureValue + ", uri:" + String.valueOf(this.resourceUri);
    }

    public ContextTranslationKey getContextKey() {
        return null;
    }
}

