/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.emf.settings;

import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.emf.settings.IFeatureSettingsProvider;
import com.e1c.langtool.internal.emf.CorePlugin;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractFeatureSettingsProvider
implements IFeatureSettingsProvider {
    private static final long EXPARATION_MINUTES = 10L;
    private Cache<String, List<EFeatureSettings>> modelCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private Cache<String, List<EFeatureSettings>> interfaceCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();

    protected abstract void doComputeModelSettings(List<EFeatureSettings> var1, EObject var2);

    @Override
    public List<EFeatureSettings> getModelSettings(EObject object) {
        String objectClass = object.getClass().getName();
        try {
            return (List)this.modelCache.get((Object)objectClass, () -> {
                ArrayList<EFeatureSettings> settings = new ArrayList<EFeatureSettings>();
                this.doComputeModelSettings(settings, object);
                return settings;
            });
        }
        catch (ExecutionException e) {
            CorePlugin.logError(e);
            return new ArrayList<EFeatureSettings>();
        }
    }

    protected abstract void doComputeInterfaceSettings(List<EFeatureSettings> var1, EObject var2);

    @Override
    public List<EFeatureSettings> getInterfaceSettings(EObject object) {
        String objectClass = object.getClass().getName();
        try {
            return (List)this.interfaceCache.get((Object)objectClass, () -> {
                ArrayList<EFeatureSettings> settings = new ArrayList<EFeatureSettings>();
                this.doComputeInterfaceSettings(settings, object);
                return settings;
            });
        }
        catch (ExecutionException e) {
            CorePlugin.logError(e);
            return new ArrayList<EFeatureSettings>();
        }
    }

    @Override
    public List<EFeatureSettings> allSettingsByObject(EObject object) {
        ArrayList<EFeatureSettings> settings = new ArrayList<EFeatureSettings>();
        settings.addAll(this.getModelSettings(object));
        settings.addAll(this.getInterfaceSettings(object));
        return settings;
    }
}

