/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.sync;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.sync.Messages;
import com.e1c.langtool.internal.sync.SyncPlugin;
import com.e1c.langtool.sync.DependentContentComputer;
import com.e1c.langtool.sync.ResourceSynchronizer;
import com.e1c.langtool.sync.SynchronizerRegistry;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

@Singleton
public class SynchronizerRegistryImpl
implements SynchronizerRegistry {
    private static final String EXTENSION_POINT_ID = "com.e1c.langtool.sync.synchronizer";
    private static final String ATT_SYNCHRONIZER_ELEMENTS = "synchronizer";
    private static final String ATT_SYNCHRONIZER_EXTENSION_ELEMENTS = "synchronizerExtension";
    private static final String ATT_DEPENDENT_COMPUTER_ELEMENTS = "dependentComputer";
    private static final String EMPTY_FILE_EXTENSION = "EMPTY_FILE_EXTENSION";
    private static final String ATT_CLASS = "class";
    private static final String ATT_FILE_EXTENSION = "file-extension";
    private static final String ATT_PRIORITY = "priority";
    private static final String ATT_FILE_NAME = "file-name";
    private static final String ATT_PATH_PATTERN = "pattern";
    private static final String ATT_PATH_PATTERN_ELEMENTS = "PathPattern";
    private static final String ATT_PROJECT_NATURE_ELEMENTS = "ProjectNature";
    private static final String ATT_ID = "id";
    private volatile boolean initialized;
    private Object lock = new Object();
    private List<SynchronizerAttr> synchronizerRegistry;
    private Map<String, Collection<SynchronizerAttr>> synchronizerFileExtensions;
    private Map<String, Collection<SynchronizerAttr>> synchronizerFileNames;
    private List<DependentComputerAttr> computerRegistry;
    private Map<String, Collection<DependentComputerAttr>> computerFileExtensions;
    private Map<String, Collection<DependentComputerAttr>> computerFileNames;

    @Override
    public Collection<ResourceSynchronizer> getSynchronizers(IFile source) {
        HashMap synchronizers = Maps.newHashMap();
        for (SynchronizerAttr attr : this.getAppliableSynchronizerAttrs(source)) {
            ResourceSynchronizer synchronizer = attr.getSynchronizer();
            if (synchronizer == null) continue;
            synchronizers.computeIfAbsent(synchronizer.getId(), k -> synchronizer);
        }
        return synchronizers.values();
    }

    @Override
    public boolean synchronizerExist(IFile source) {
        return !this.getAppliableSynchronizerAttrs(source).isEmpty();
    }

    @Override
    public int getSynchronizePriority(IFile source) {
        int priority = 100000;
        for (SynchronizerAttr attr : this.getAppliableSynchronizerAttrs(source)) {
            priority = Math.min(priority, attr.getPriority());
        }
        return priority;
    }

    @Override
    public Collection<ResourceSynchronizer> getAllSynchronizers() {
        this.initialize();
        ArrayList synchronizers = Lists.newArrayList();
        for (SynchronizerAttr attr : this.synchronizerRegistry) {
            ResourceSynchronizer synchronizer = attr.getSynchronizer();
            if (synchronizer == null) continue;
            synchronizers.add(synchronizer);
        }
        return synchronizers;
    }

    @Override
    public boolean dependentContentComputerExist(IFile source) {
        return !this.getAppliableDependentComputerAttrs(source).isEmpty();
    }

    @Override
    public Collection<DependentContentComputer> getDependentContentComputers(IFile source) {
        ArrayList computers = Lists.newArrayList();
        for (DependentComputerAttr attr : this.getAppliableDependentComputerAttrs(source)) {
            DependentContentComputer computer = attr.getComputer();
            if (computer == null) continue;
            computers.add(computer);
        }
        return computers;
    }

    @Override
    public Collection<DependentContentComputer> getAllDependentContentComputers() {
        this.initialize();
        ArrayList computers = Lists.newArrayList();
        for (DependentComputerAttr attr : this.computerRegistry) {
            DependentContentComputer computer = attr.getComputer();
            if (computer == null) continue;
            computers.add(computer);
        }
        return computers;
    }

    private Collection<SynchronizerAttr> getAppliableSynchronizerAttrs(IFile source) {
        Collection<SynchronizerAttr> emptyExtensions;
        Collection<SynchronizerAttr> extensions;
        if (source == null) {
            return Collections.emptyList();
        }
        this.initialize();
        LinkedHashSet synchronizers = Sets.newLinkedHashSet();
        Collection<SynchronizerAttr> named = this.synchronizerFileNames.get(source.getName());
        if (named != null && !named.isEmpty()) {
            synchronizers.addAll(named);
        }
        Collection<SynchronizerAttr> collection = extensions = source.getFileExtension() == null ? null : this.synchronizerFileExtensions.get(source.getFileExtension());
        if (extensions != null && !extensions.isEmpty()) {
            synchronizers.addAll(extensions);
        }
        if ((emptyExtensions = this.synchronizerFileExtensions.get(EMPTY_FILE_EXTENSION)) != null && !emptyExtensions.isEmpty()) {
            synchronizers.addAll(emptyExtensions);
        }
        IProject project = source.getProject();
        Iterator iterator = synchronizers.iterator();
        while (iterator.hasNext()) {
            SynchronizerAttr synchronizerAttr = (SynchronizerAttr)iterator.next();
            if (!this.isValidProjectNature(project, synchronizerAttr.getNatureIds())) {
                iterator.remove();
                continue;
            }
            if (this.isValidPath(source.getProjectRelativePath(), synchronizerAttr.getPathPatterns())) continue;
            iterator.remove();
        }
        ArrayList sortedSynchronizers = Lists.newArrayList((Iterable)synchronizers);
        sortedSynchronizers.sort((o1, o2) -> o1.getPriority() - o2.getPriority());
        return sortedSynchronizers;
    }

    private Collection<DependentComputerAttr> getAppliableDependentComputerAttrs(IFile source) {
        Collection<DependentComputerAttr> emptyExtensions;
        String fileExt;
        Collection<DependentComputerAttr> extensions;
        Collection<DependentComputerAttr> named;
        this.initialize();
        LinkedHashSet computerAttrs = Sets.newLinkedHashSet();
        String name = source.getName();
        Collection<DependentComputerAttr> collection = named = name == null ? null : this.computerFileNames.get(name);
        if (named != null && !named.isEmpty()) {
            computerAttrs.addAll(named);
        }
        Collection<DependentComputerAttr> collection2 = extensions = (fileExt = source.getFileExtension()) == null ? null : this.computerFileExtensions.get(fileExt);
        if (extensions != null && !extensions.isEmpty()) {
            computerAttrs.addAll(extensions);
        }
        if ((emptyExtensions = this.computerFileExtensions.get(EMPTY_FILE_EXTENSION)) != null && !emptyExtensions.isEmpty()) {
            computerAttrs.addAll(extensions);
        }
        IProject project = source.getProject();
        Iterator iterator = computerAttrs.iterator();
        while (iterator.hasNext()) {
            DependentComputerAttr computerAttr = (DependentComputerAttr)iterator.next();
            if (!this.isValidProjectNature(project, computerAttr.getNatureIds())) {
                iterator.remove();
                continue;
            }
            if (this.isValidPath(source.getProjectRelativePath(), computerAttr.getPathPatterns())) continue;
            iterator.remove();
        }
        return computerAttrs;
    }

    private boolean isValidPath(IPath path, Pattern[] patterns) {
        if (path.equals((Object)Path.EMPTY) || patterns.length == 0) {
            return true;
        }
        int i = 0;
        while (i < patterns.length) {
            Pattern pattern = patterns[i];
            if (pattern.matcher(path.toString()).matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isValidProjectNature(IProject project, String[] natureIds) {
        if (!project.isAccessible()) {
            return false;
        }
        if (natureIds.length == 0) {
            return true;
        }
        int i = 0;
        while (i < natureIds.length) {
            String natureId = natureIds[i];
            try {
                if (project.hasNature(natureId)) {
                    return true;
                }
            }
            catch (CoreException e) {
                SyncPlugin.logError(e);
                return false;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (!this.initialized) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.initialized) {
                    String extension;
                    String[] names;
                    this.synchronizerFileNames = Maps.newConcurrentMap();
                    this.synchronizerFileExtensions = Maps.newConcurrentMap();
                    this.computerFileNames = Maps.newConcurrentMap();
                    this.computerFileExtensions = Maps.newConcurrentMap();
                    this.loadExtentionPointAttributes();
                    for (SynchronizerAttr synchronizerAttr : this.synchronizerRegistry) {
                        names = synchronizerAttr.getFileNames();
                        int i = 0;
                        while (i < names.length) {
                            String name = names[i];
                            if (StringUtils.isNotEmpty((String)name)) {
                                this.synchronizerFileNames.computeIfAbsent(name, k -> Sets.newConcurrentHashSet()).add(synchronizerAttr);
                            }
                            ++i;
                        }
                        if (names.length != 0) continue;
                        String[] extentions = synchronizerAttr.getFileExtentions();
                        int i2 = 0;
                        while (i2 < extentions.length) {
                            extension = extentions[i2];
                            if (StringUtils.isNotEmpty((String)extension)) {
                                this.synchronizerFileExtensions.computeIfAbsent(extension, k -> Sets.newConcurrentHashSet()).add(synchronizerAttr);
                            }
                            ++i2;
                        }
                        if (extentions.length != 0) continue;
                        this.synchronizerFileExtensions.computeIfAbsent(EMPTY_FILE_EXTENSION, k -> Sets.newConcurrentHashSet()).add(synchronizerAttr);
                    }
                    for (DependentComputerAttr dependentComputerAttr : this.computerRegistry) {
                        names = dependentComputerAttr.getFileNames();
                        int i = 0;
                        while (i < names.length) {
                            String name = names[i];
                            if (StringUtils.isNotEmpty((String)name)) {
                                this.computerFileNames.computeIfAbsent(name, k -> Sets.newConcurrentHashSet()).add(dependentComputerAttr);
                            }
                            ++i;
                        }
                        if (names.length != 0) continue;
                        String[] extentions = dependentComputerAttr.getFileExtentions();
                        int i3 = 0;
                        while (i3 < extentions.length) {
                            extension = extentions[i3];
                            if (StringUtils.isNotEmpty((String)extension)) {
                                this.computerFileExtensions.computeIfAbsent(extension, k -> Sets.newConcurrentHashSet()).add(dependentComputerAttr);
                            }
                            ++i3;
                        }
                        if (extentions.length != 0) continue;
                        this.computerFileExtensions.computeIfAbsent(EMPTY_FILE_EXTENSION, k -> Sets.newConcurrentHashSet()).add(dependentComputerAttr);
                    }
                    this.initialized = true;
                }
            }
        }
    }

    private void loadExtentionPointAttributes() {
        ArrayList synchronizers = Lists.newArrayList();
        ArrayList computers = Lists.newArrayList();
        ArrayList synchronizerExtensions = Lists.newArrayList();
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < configurationElements.length) {
            Object attr;
            IConfigurationElement configurationElement = configurationElements[i];
            String elementName = configurationElement.getName();
            if (elementName.equals(ATT_SYNCHRONIZER_ELEMENTS)) {
                attr = this.loadSynchronizerAttr(configurationElement);
                if (attr != null) {
                    synchronizers.add(attr);
                }
            } else if (elementName.equals(ATT_SYNCHRONIZER_EXTENSION_ELEMENTS)) {
                synchronizerExtensions.add(configurationElement);
            } else if (elementName.equals(ATT_DEPENDENT_COMPUTER_ELEMENTS) && (attr = this.loadComputerAttr(configurationElement)) != null) {
                computers.add(attr);
            }
            ++i;
        }
        this.loadSynchronizerExtensions(synchronizerExtensions, synchronizers);
        synchronizers.sort((o1, o2) -> o1.getPriority() - o2.getPriority());
        this.synchronizerRegistry = synchronizers;
        this.computerRegistry = computers;
    }

    private void loadSynchronizerExtensions(List<IConfigurationElement> synchronizerExtensions, List<SynchronizerAttr> synchronizers) {
        Map<String, IConfigurationElement> sources = synchronizers.stream().collect(Collectors.toMap(SynchronizerAttr::getId, s -> s.configurationElement));
        for (IConfigurationElement configurationElement : synchronizerExtensions) {
            try {
                String id = configurationElement.getAttribute(ATT_ID);
                IConfigurationElement sourceElement = sources.get(id);
                if (sourceElement == null) {
                    SyncPlugin.log(SyncPlugin.createWarningStatus(MessageFormat.format(Messages.SynchronizerRegistryImpl_Cannot_load_ResourceSynchronizer_extension_configuration_because_synchronizer_id_not_found, id)));
                    continue;
                }
                int priority = Integer.parseInt(configurationElement.getAttribute(ATT_PRIORITY));
                if ((priority = Math.min(priority, 99999)) < 1) {
                    priority = 10000;
                }
                String fileExtention = configurationElement.getAttribute(ATT_FILE_EXTENSION);
                String[] fileExtensions = new String[]{};
                if (fileExtention != null) {
                    fileExtensions = fileExtention.split(",");
                }
                String fileName = configurationElement.getAttribute(ATT_FILE_NAME);
                String[] fileNames = new String[]{};
                if (fileName != null) {
                    fileNames = fileName.split(",");
                }
                ArrayList patterns = Lists.newArrayList();
                IConfigurationElement[] pathPatternElements = configurationElement.getChildren(ATT_PATH_PATTERN_ELEMENTS);
                int j = 0;
                while (j < pathPatternElements.length) {
                    IConfigurationElement pathPatternElement = pathPatternElements[j];
                    Pattern pathPattern = Pattern.compile(pathPatternElement.getAttribute(ATT_PATH_PATTERN));
                    patterns.add(pathPattern);
                    ++j;
                }
                ArrayList natureIds = Lists.newArrayList();
                IConfigurationElement[] natureElements = configurationElement.getChildren(ATT_PROJECT_NATURE_ELEMENTS);
                int j2 = 0;
                while (j2 < natureElements.length) {
                    IConfigurationElement natureElement = natureElements[j2];
                    String natureId = natureElement.getAttribute(ATT_ID);
                    natureIds.add(natureId);
                    ++j2;
                }
                SynchronizerAttr syncConfig = new SynchronizerAttr(id, sourceElement, priority, fileExtensions, fileNames, natureIds.toArray(new String[0]), patterns.toArray(new Pattern[0]));
                synchronizers.add(syncConfig);
            }
            catch (NumberFormatException | PatternSyntaxException | InvalidRegistryObjectException e) {
                SyncPlugin.logError(e);
            }
        }
    }

    private SynchronizerAttr loadSynchronizerAttr(IConfigurationElement configurationElement) {
        String className = configurationElement.getAttribute(ATT_CLASS);
        if (StringUtils.isBlank((String)className)) {
            return null;
        }
        try {
            String id = configurationElement.getAttribute(ATT_ID);
            int priority = Integer.parseInt(configurationElement.getAttribute(ATT_PRIORITY));
            priority = Math.min(priority, 99999);
            if (priority < 1) {
                priority = 10000;
            }
            String fileExtention = configurationElement.getAttribute(ATT_FILE_EXTENSION);
            String[] fileExtensions = new String[]{};
            if (fileExtention != null) {
                fileExtensions = fileExtention.split(",");
            }
            String fileName = configurationElement.getAttribute(ATT_FILE_NAME);
            String[] fileNames = new String[]{};
            if (fileName != null) {
                fileNames = fileName.split(",");
            }
            ArrayList patterns = Lists.newArrayList();
            IConfigurationElement[] pathPatternElements = configurationElement.getChildren(ATT_PATH_PATTERN_ELEMENTS);
            int j = 0;
            while (j < pathPatternElements.length) {
                IConfigurationElement pathPatternElement = pathPatternElements[j];
                Pattern pathPattern = Pattern.compile(pathPatternElement.getAttribute(ATT_PATH_PATTERN));
                patterns.add(pathPattern);
                ++j;
            }
            ArrayList natureIds = Lists.newArrayList();
            IConfigurationElement[] natureElements = configurationElement.getChildren(ATT_PROJECT_NATURE_ELEMENTS);
            int j2 = 0;
            while (j2 < natureElements.length) {
                IConfigurationElement natureElement = natureElements[j2];
                String natureId = natureElement.getAttribute(ATT_ID);
                natureIds.add(natureId);
                ++j2;
            }
            return new SynchronizerAttr(id, configurationElement, priority, fileExtensions, fileNames, natureIds.toArray(new String[0]), patterns.toArray(new Pattern[0]));
        }
        catch (NumberFormatException | PatternSyntaxException | InvalidRegistryObjectException e) {
            SyncPlugin.logError(e);
            return null;
        }
    }

    private DependentComputerAttr loadComputerAttr(IConfigurationElement configurationElement) {
        String className = configurationElement.getAttribute(ATT_CLASS);
        if (StringUtils.isBlank((String)className)) {
            return null;
        }
        try {
            String fileExtention = configurationElement.getAttribute(ATT_FILE_EXTENSION);
            String[] fileExtensions = new String[]{};
            if (fileExtention != null) {
                fileExtensions = fileExtention.split(",");
            }
            String fileName = configurationElement.getAttribute(ATT_FILE_NAME);
            String[] fileNames = new String[]{};
            if (fileName != null) {
                fileNames = fileName.split(",");
            }
            ArrayList patterns = Lists.newArrayList();
            IConfigurationElement[] pathPatternElements = configurationElement.getChildren(ATT_PATH_PATTERN_ELEMENTS);
            int j = 0;
            while (j < pathPatternElements.length) {
                IConfigurationElement pathPatternElement = pathPatternElements[j];
                Pattern pathPattern = Pattern.compile(pathPatternElement.getAttribute(ATT_PATH_PATTERN));
                patterns.add(pathPattern);
                ++j;
            }
            ArrayList natureIds = Lists.newArrayList();
            IConfigurationElement[] natureElements = configurationElement.getChildren(ATT_PROJECT_NATURE_ELEMENTS);
            int j2 = 0;
            while (j2 < natureElements.length) {
                IConfigurationElement natureElement = natureElements[j2];
                String natureId = natureElement.getAttribute(ATT_ID);
                natureIds.add(natureId);
                ++j2;
            }
            return new DependentComputerAttr(configurationElement, fileExtensions, fileNames, natureIds.toArray(new String[0]), patterns.toArray(new Pattern[0]));
        }
        catch (PatternSyntaxException | InvalidRegistryObjectException e) {
            SyncPlugin.logError(e);
            return null;
        }
    }

    private static final class DependentComputerAttr {
        private volatile boolean computerInitialized;
        private DependentContentComputer computer;
        private final IConfigurationElement configurationElement;
        private final String[] fileExtentions;
        private final String[] fileNames;
        private final String[] natureIds;
        private final Pattern[] pathPatterns;

        public DependentComputerAttr(IConfigurationElement configurationElement, String[] fileExtentions, String[] fileNames, String[] natureIds, Pattern[] pathPatterns) {
            this.configurationElement = configurationElement;
            this.fileExtentions = fileExtentions;
            this.fileNames = fileNames;
            this.natureIds = natureIds;
            this.pathPatterns = pathPatterns;
        }

        public synchronized DependentContentComputer getComputer() {
            if (this.computer == null && !this.computerInitialized) {
                this.computerInitialized = true;
                try {
                    this.computer = (DependentContentComputer)this.configurationElement.createExecutableExtension(SynchronizerRegistryImpl.ATT_CLASS);
                }
                catch (CoreException e) {
                    SyncPlugin.logError(e);
                }
            }
            return this.computer;
        }

        public String[] getFileExtentions() {
            return this.fileExtentions;
        }

        public String[] getFileNames() {
            return this.fileNames;
        }

        public String[] getNatureIds() {
            return this.natureIds;
        }

        public Pattern[] getPathPatterns() {
            return this.pathPatterns;
        }
    }

    private static final class SynchronizerAttr {
        private volatile boolean synchronizerInitialized;
        private ResourceSynchronizer synchronizer;
        private final String id;
        private final IConfigurationElement configurationElement;
        private final int priority;
        private final String[] fileExtentions;
        private final String[] fileNames;
        private final String[] natureIds;
        private final Pattern[] pathPatterns;

        public SynchronizerAttr(String id, IConfigurationElement configurationElement, int priority, String[] fileExtentions, String[] fileNames, String[] natureIds, Pattern[] pathPatterns) {
            this.id = id;
            this.configurationElement = configurationElement;
            this.priority = priority;
            this.fileExtentions = fileExtentions;
            this.fileNames = fileNames;
            this.natureIds = natureIds;
            this.pathPatterns = pathPatterns;
        }

        public String getId() {
            return this.id;
        }

        public synchronized ResourceSynchronizer getSynchronizer() {
            if (this.synchronizer == null && !this.synchronizerInitialized) {
                this.synchronizerInitialized = true;
                try {
                    this.synchronizer = (ResourceSynchronizer)this.configurationElement.createExecutableExtension(SynchronizerRegistryImpl.ATT_CLASS);
                }
                catch (CoreException e) {
                    SyncPlugin.logError(e);
                }
            }
            return this.synchronizer;
        }

        public int getPriority() {
            return this.priority;
        }

        public String[] getFileExtentions() {
            return this.fileExtentions;
        }

        public String[] getFileNames() {
            return this.fileNames;
        }

        public String[] getNatureIds() {
            return this.natureIds;
        }

        public Pattern[] getPathPatterns() {
            return this.pathPatterns;
        }
    }
}

