/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.sync.change;

import com.e1c.langtool.internal.sync.SyncPlugin;
import com.e1c.langtool.sync.SyncResourceVisitor;
import com.e1c.langtool.sync.change.ChangeEvent;
import com.e1c.langtool.sync.change.ChangeManager;
import com.e1c.langtool.sync.change.PostChangeListener;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;

public class InMemoryChangeManagerProxy
implements ChangeManager {
    private final IProject sourceProject;
    private final IProject translatedProject;
    private final Set<IPath> updates = Sets.newConcurrentHashSet();
    private final Set<IPath> removes = Sets.newConcurrentHashSet();
    private volatile boolean initialized = false;
    private final ListenerList<PostChangeListener> postChangeListeners = new ListenerList();
    private final AtomicInteger mute = new AtomicInteger(0);
    private volatile boolean dispose = false;

    public InMemoryChangeManagerProxy(IProject sourceProject, IProject translatedProject) {
        this.sourceProject = sourceProject;
        this.translatedProject = translatedProject;
    }

    @Override
    public void clear() {
        this.checkAccess();
        if (!this.initialized) {
            return;
        }
        this.updates.clear();
        this.removes.clear();
        if (!this.isMuted()) {
            this.firePostChanged(new ChangeEvent(this, PostChangeListener.ChangeEventType.Cleared, this.translatedProject.getProject().getProjectRelativePath()));
        }
    }

    @Override
    public void markToSynchronize(IPath fullPath) {
        this.checkAccess();
        if (!this.initialized) {
            return;
        }
        this.updates.add(fullPath);
        if (!this.isMuted()) {
            this.firePostChanged(new ChangeEvent(this, PostChangeListener.ChangeEventType.MarkToSynchronize, fullPath));
        }
    }

    @Override
    public void markToRemove(IPath fullPath) {
        this.checkAccess();
        if (!this.initialized) {
            return;
        }
        this.removes.add(fullPath);
        if (!this.isMuted()) {
            this.firePostChanged(new ChangeEvent(this, PostChangeListener.ChangeEventType.MarkToRemove, fullPath));
        }
    }

    @Override
    public Collection<IPath> getFilesToUpdate() {
        this.checkAccess();
        this.checkInitialized();
        return this.updates;
    }

    @Override
    public Collection<IPath> getFilesToRemove() {
        this.checkAccess();
        this.checkInitialized();
        return this.removes;
    }

    @Override
    public void markToSynchronize(IFile file) {
        this.checkAccess();
        if (!file.isAccessible()) {
            return;
        }
        this.markToSynchronize(file.getFullPath());
    }

    @Override
    public void moved(IFile from, IFile to) {
        this.checkAccess();
        this.markToRemove(from);
        this.markToSynchronize(to);
    }

    @Override
    public void markToRemove(IFile file) {
        this.checkAccess();
        this.markToRemove(file.getFullPath());
    }

    @Override
    public void markSynchronized(IPath fullPath) {
        this.checkAccess();
        if (!this.initialized) {
            return;
        }
        this.updates.remove(fullPath);
        if (!this.isMuted()) {
            this.firePostChanged(new ChangeEvent(this, PostChangeListener.ChangeEventType.MarkSynchronized, fullPath));
        }
    }

    @Override
    public void markRemoved(IPath fullPath) {
        this.checkAccess();
        if (!this.initialized) {
            return;
        }
        this.removes.remove(fullPath);
        if (!this.isMuted()) {
            this.firePostChanged(new ChangeEvent(this, PostChangeListener.ChangeEventType.MarkRemoved, fullPath));
        }
    }

    private void checkInitialized() {
        this.checkAccess();
        if (this.initialized) {
            return;
        }
        throw new IllegalAccessError("The change manager is not initialized yet");
    }

    @Override
    public void mute() {
        this.checkAccess();
        this.mute.incrementAndGet();
    }

    @Override
    public boolean isMuted() {
        return this.mute.get() > 0;
    }

    @Override
    public void unmute() {
        this.checkAccess();
        if (this.mute.get() > 0) {
            this.mute.decrementAndGet();
        }
    }

    @Override
    public void unmute(ChangeEvent event) {
        this.unmute();
        this.firePostChanged(event);
    }

    @Override
    public void addPostChangeListener(PostChangeListener listener) {
        this.checkAccess();
        this.postChangeListeners.add((Object)listener);
    }

    @Override
    public void removePostChangeListener(PostChangeListener listener) {
        this.postChangeListeners.remove((Object)listener);
    }

    @Override
    public synchronized void initialize(IProgressMonitor monitor) {
        if (this.initialized) {
            return;
        }
        this.updates.clear();
        this.removes.clear();
        this.initialized = true;
        try {
            if (this.sourceProject.isAccessible()) {
                this.sourceProject.accept((IResourceVisitor)new SyncResourceVisitor(this, monitor));
            }
        }
        catch (CoreException e) {
            SyncPlugin.logError(e);
        }
        if (!this.isMuted()) {
            this.firePostChanged(new ChangeEvent(this, PostChangeListener.ChangeEventType.MarkToSynchronize, this.sourceProject.getProjectRelativePath()));
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    protected void firePostChanged(ChangeEvent event) {
        if (this.isMuted()) {
            return;
        }
        for (PostChangeListener l : this.postChangeListeners) {
            try {
                SafeRunner.run(() -> l.changed(event));
            }
            catch (Throwable e) {
                SyncPlugin.logError(e);
            }
        }
    }

    @Override
    public void dispose() {
        this.dispose = true;
        this.postChangeListeners.clear();
        this.mute.incrementAndGet();
        this.updates.clear();
        this.removes.clear();
    }

    @Override
    public boolean isDisposed() {
        return this.dispose;
    }

    protected void checkAccess() {
        if (this.isDisposed()) {
            throw new IllegalAccessError("The manager is already disposed");
        }
    }
}

