/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.sync;

import com.e1c.langtool.sync.EqualityState;
import com.e1c.langtool.sync.SynchronizationManager;
import java.util.EventObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class StateChangeEvent
extends EventObject {
    private static final long serialVersionUID = 8737703746041904854L;
    private final transient IProject project;
    private final String projectName;
    private final EqualityState oldState;
    private final EqualityState newState;

    public StateChangeEvent(SynchronizationManager source, IProject project, EqualityState oldState, EqualityState newState) {
        super(source);
        this.project = project;
        this.projectName = project.getName();
        this.oldState = oldState;
        this.newState = newState;
    }

    public SynchronizationManager getManager() {
        return (SynchronizationManager)this.getSource();
    }

    public IProject getProject() {
        if (this.project == null) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        }
        return this.project;
    }

    public EqualityState getOldState() {
        return this.oldState;
    }

    public EqualityState getNewState() {
        return this.newState;
    }
}

