/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.sync;

import com.e1c.langtool.internal.sync.SyncPlugin;
import com.e1c.langtool.sync.DependentContentComputer;
import com.e1c.langtool.sync.SynchronizerRegistry;
import com.e1c.langtool.sync.change.EditingChangeManager;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class SyncResourceVisitor
implements IResourceVisitor {
    private static final Set<String> skipNames = ImmutableSet.of((Object)".project", (Object)".settings");
    private final EditingChangeManager changeManager;
    private final IProgressMonitor monitor;
    @Inject
    private SynchronizerRegistry registry;

    public SyncResourceVisitor(EditingChangeManager changeManager, IProgressMonitor monitor) {
        this.changeManager = changeManager;
        this.monitor = monitor;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (this.monitor.isCanceled() || skipNames.contains(resource.getName())) {
            return false;
        }
        this.markChanged(resource);
        return true;
    }

    private void markChanged(IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            this.changeManager.markToSynchronize(file);
            if (this.getRegistry().dependentContentComputerExist(file)) {
                HashSet toSynchronize = Sets.newHashSet();
                HashSet toRemove = Sets.newHashSet();
                Collection<DependentContentComputer> computers = this.getRegistry().getDependentContentComputers(file);
                for (DependentContentComputer computer : computers) {
                    if (this.monitor.isCanceled()) {
                        return;
                    }
                    toSynchronize.addAll(computer.computeDependentContentToSynchronize(file, false, this.monitor));
                    toRemove.addAll(computer.computeDependentContentToRemove(file, false, this.monitor));
                }
                for (IFile dependent : toSynchronize) {
                    this.markChanged((IResource)dependent);
                }
                for (IFile dependent : toRemove) {
                    this.markToDelete(dependent);
                }
            }
        }
    }

    private void markToDelete(IFile file) {
        this.changeManager.markToRemove(file);
        if (this.getRegistry().dependentContentComputerExist(file)) {
            if (this.monitor.isCanceled()) {
                return;
            }
            HashSet toSynchronize = Sets.newHashSet();
            HashSet toRemove = Sets.newHashSet();
            Collection<DependentContentComputer> computers = this.getRegistry().getDependentContentComputers(file);
            for (DependentContentComputer computer : computers) {
                toSynchronize.addAll(computer.computeDependentContentToSynchronize(file, true, this.monitor));
                toRemove.addAll(computer.computeDependentContentToRemove(file, true, this.monitor));
            }
            for (IFile dependent : toSynchronize) {
                this.markChanged((IResource)dependent);
            }
            for (IFile dependent : toRemove) {
                this.markToDelete(dependent);
            }
        }
    }

    protected SynchronizerRegistry getRegistry() {
        if (this.registry == null) {
            SyncPlugin.getDefault().getInjector().injectMembers((Object)this);
        }
        return this.registry;
    }
}

