/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs;

import com._1c.g5.v8.dt.bm.xtext.IDependentModelProvider;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.dcs.expressions.model.Expressions;
import com._1c.g5.v8.dt.dcs.model.core.LocalString;
import com._1c.g5.v8.dt.dcs.model.core.Presentation;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaDataSetQuery;
import com._1c.g5.v8.dt.dcs.model.schema.DcsPackage;
import com._1c.g5.v8.dt.ql.dcs.resource.IDependentQuerySchemaProvider;
import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.FeatureValueCollector;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.collector.IComputedNameService;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.Utils;
import com.e1c.langtool.v8.dt.collector.CollectingContext;
import com.e1c.langtool.v8.dt.collector.FeaturesCollectorUtil;
import com.e1c.langtool.v8.dt.dcs.DcsProcessor;
import com.e1c.langtool.v8.dt.dcs.settings.DcsFeatureSettings;
import com.e1c.langtool.v8.dt.dcs.settings.impl.ExpressionsField;
import com.e1c.langtool.v8.dt.internal.dcs.DcsPlugin;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DcsFeaturesCollector
extends DcsProcessor
implements FeatureValueCollector {
    @Inject
    private IFeatureSettingsService settingsService;
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private IComputedNameService computedNameService;
    @Inject
    private IFeatureValueCollectingService collectingService;
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IDependentModelProvider dependentModelProvider;
    @Inject
    private IDependentQuerySchemaProvider dependentQuerySchemaProvider;
    private ICollectingParameters parameters;
    private CollectingContext context;
    private BiConsumer<Object, FeatureValue> addAction;
    private String defaultLanguageCode;
    private IFile resourceFile;

    public static DcsFeaturesCollector create(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        Assert.isNotNull((Object)object, (String)"Object cannot be null");
        DcsFeaturesCollector collector = new DcsFeaturesCollector(object, parameters, addAction);
        DcsPlugin.getDefault().getInjector().injectMembers((Object)collector);
        return collector;
    }

    public DcsFeaturesCollector(EObject object, ICollectingParameters parameters, BiConsumer<Object, FeatureValue> addAction) {
        super(object);
        Assert.isLegal((parameters != null ? 1 : 0) != 0, (String)"Parameters cannot be null.");
        this.parameters = parameters;
        super.setProcessChildObjects(parameters.isCollectChildObjects());
        this.addAction = addAction;
    }

    @Override
    protected <T extends EObject> void doProcess(T obj, Class<T> clazz) {
        EFeatureSettings[] features;
        QuerySchema query;
        TranslationSource source;
        if (obj == null) {
            return;
        }
        FeaturesCollectorUtil.collectFeatures(obj, (CollectingContext)this.getContext(), (IProgressMonitor)this.monitor);
        if (clazz.equals(Presentation.class)) {
            this.doProcessInternal((Presentation)obj);
        }
        if (clazz.equals(LocalString.class)) {
            this.doProcessInternal((LocalString)obj);
        }
        if (clazz.equals(DataCompositionSchemaDataSetQuery.class) && this.parameters.isCollectModelStrings() && (source = TranslationUtils.getTranslationSource((Object)(query = this.dependentQuerySchemaProvider.getQuerySchema(obj, (EStructuralFeature)DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_QUERY__QUERY, this.getCancelIndicator())))) != null) {
            this.collectingService.forEachCollected(source, this.parameters, this.monitor, this.addAction);
        }
        if ((features = ExpressionsField.getFeatures(clazz)).length > 0) {
            this.collectExpressionsFromFields(obj, features);
        }
    }

    private void doProcessInternal(Presentation obj) {
        boolean hasValue;
        if (!this.parameters.isCollectInterfaceStrings() || obj.getLocalValue() != null && obj.getLocalValue().getContent() != null && !obj.getLocalValue().getContent().isEmpty()) {
            return;
        }
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)obj, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT);
        HashMap nls = Maps.newHashMap();
        String value = obj.getValue();
        if (value != null) {
            value = value.trim();
        }
        if (StringUtils.isNotEmpty((String)value)) {
            nls.put(this.getDefaultLanguageCode((EObject)obj), value);
        }
        PersistableFeatureValue featureValue = new PersistableFeatureValue(this.getResourceFile(), featureKey, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT, value, false);
        FeaturesCollectorUtil.fillLocalStrings((Map)featureValue.getLocalStrings(), (Map)nls, (Collection)this.parameters.getLanguages());
        boolean bl = hasValue = StringUtils.isNotEmpty((String)value) || !featureValue.getLocalStrings().isEmpty();
        if (!this.parameters.isCollectEmptyValue() && !hasValue) {
            return;
        }
        this.addAction.accept(obj, (FeatureValue)featureValue);
    }

    private IFile getResourceFile() {
        if (this.resourceFile == null) {
            this.resourceFile = this.resourceLookup.getPlatformResource(this.object);
        }
        return this.resourceFile;
    }

    private <T extends EObject> void collectExpressionsFromFields(T obj, EFeatureSettings[] features) {
        IPath basePath = this.getResourceFile().getProjectRelativePath().removeFileExtension().addFileExtension("dcsexpr");
        EFeatureSettings[] eFeatureSettingsArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EFeatureSettings featureSettings = eFeatureSettingsArray[n2];
            Object value = obj.eGet(featureSettings.getEFeature());
            if (value instanceof String && StringUtils.isNotEmpty((String)((String)value))) {
                Expressions expressions = (Expressions)this.dependentModelProvider.getDependentModel(obj, featureSettings.getEFeature(), basePath, this.getCancelIndicator());
                try {
                    TranslationSource source = TranslationUtils.getTranslationSource((Object)expressions);
                    if (source != null) {
                        this.collectingService.forEachCollected(source, this.parameters, this.monitor, this.addAction);
                    }
                }
                finally {
                    this.dependentModelProvider.unload((EObject)expressions);
                }
            }
            ++n2;
        }
    }

    private CollectingContext getContext() {
        if (this.context == null) {
            this.context = new CollectingContext(this.parameters, this.collectingService, this.settingsService, this.featureKeyProvider, this.computedNameService, this.getDefaultLanguageCode(this.object), this.addAction, this.getResourceFile());
        }
        return this.context;
    }

    private String getDefaultLanguageCode(EObject context) {
        if (this.defaultLanguageCode == null) {
            this.defaultLanguageCode = FeaturesCollectorUtil.getDefaultLanguageCode((EObject)context, (IV8ProjectManager)this.v8ProjectManager);
        }
        return this.defaultLanguageCode;
    }

    private void doProcessInternal(LocalString localString) {
        EMap content = localString.getContent();
        String value = (String)content.get((Object)this.getContext().getDefaultLanguageCode());
        if (!StringUtils.isBlank((String)value)) {
            this.collectParams(value, localString, this.resourceFile);
        }
    }

    private void collectParams(String value, LocalString literal, IFile file) {
        Map params = Utils.getParamsMapFromNls((String)value);
        for (Map.Entry entry : params.entrySet()) {
            this.collectStringSingleParam(literal, file.getFullPath().toString(), (String)entry.getKey());
        }
    }

    private void collectStringSingleParam(LocalString literal, String fullPath, String param) {
        if (StringUtils.isNotEmpty((String)param)) {
            HashMap nls = Maps.newHashMap();
            FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)literal, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT).append(param).append("Param");
            PersistableFeatureValue paramValue = new PersistableFeatureValue(fullPath, featureKey, DcsFeatureSettings.Literals.STRING_VALUE__PARAM, param, false);
            nls.put(this.context.getDefaultLanguageCode(), param);
            FeaturesCollectorUtil.fillLocalStrings((FeatureValue)paramValue, (Map)nls, (Collection)this.context.getParameters().getLanguages());
            if (TranslationUtils.isValidValueForCollectModelType((boolean)paramValue.isComputedValue(), (boolean)false, (boolean)paramValue.isTag(), (ICollectingParameters.CollectModelType)this.context.getParameters().getCollectModelType())) {
                this.getContext().getAddAction().accept(literal, paramValue);
            }
        }
    }
}

