/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.check;

import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.dcs.model.core.Presentation;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaDataSetField;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaDataSetFieldFolder;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaDataSetObject;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaDataSetQuery;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaDataSetUnion;
import com._1c.g5.v8.dt.dcs.model.schema.DataSet;
import com._1c.g5.v8.dt.dcs.model.schema.DataSetField;
import com._1c.g5.v8.dt.dcs.model.schema.DcsPackage;
import com._1c.g5.v8.dt.form.model.DynamicListExtInfo;
import com._1c.g5.v8.dt.form.model.FormPackage;
import com._1c.g5.v8.dt.metadata.dbview.DbViewElement;
import com._1c.g5.v8.dt.metadata.dbview.DbViewVirtualFieldDef;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.ql.dcs.resource.IDependentQuerySchemaProvider;
import com._1c.g5.v8.dt.ql.model.AbstractQuerySchemaQuery;
import com._1c.g5.v8.dt.ql.model.CommonExpression;
import com._1c.g5.v8.dt.ql.model.DbViewFieldFieldDefFromQuery;
import com._1c.g5.v8.dt.ql.model.MultiPartCommonExpression;
import com._1c.g5.v8.dt.ql.model.QuerySchema;
import com._1c.g5.v8.dt.ql.model.QuerySchemaExpression;
import com._1c.g5.v8.dt.ql.model.QuerySchemaOperator;
import com._1c.g5.v8.dt.ql.model.QuerySchemaSelectQuery;
import com._1c.g5.v8.dt.ql.resource.QlMapper;
import com._1c.g5.v8.dt.ql.typesystem.IDynamicDbViewFieldComputer;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.e1c.langtool.v8.dt.dcs.check.Messages;
import com.e1c.langtool.v8.dt.internal.dcs.DcsPlugin;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.util.CancelIndicator;

public class DataSetFieldPresentationCheck
extends BasicCheck {
    public static final String CHECK_ID = "dcs-field-title";
    private static final String EXCLUDE_FIELD_NAME_PARAMETER_NAME = "excludeFieldNamePattern";
    private final IV8ProjectManager v8ProjectManager;
    private final IDynamicDbViewFieldComputer dynamicDbViewFieldComputer;
    private final ITranslationFeatureKeyProvider featureKeyProvider;
    private final IResourceLookup resourceLookup;
    private final IDependentQuerySchemaProvider dependentModelProvider;
    private final QlMapper qlMapper;

    @Inject
    public DataSetFieldPresentationCheck(IV8ProjectManager v8ProjectManager, IDynamicDbViewFieldComputer dynamicDbViewFieldComputer, ITranslationFeatureKeyProvider featureKeyProvider, IResourceLookup resourceLookup, IDependentQuerySchemaProvider dependentModelProvider, QlMapper qlMapper) {
        this.v8ProjectManager = v8ProjectManager;
        this.dynamicDbViewFieldComputer = dynamicDbViewFieldComputer;
        this.featureKeyProvider = featureKeyProvider;
        this.resourceLookup = resourceLookup;
        this.dependentModelProvider = dependentModelProvider;
        this.qlMapper = qlMapper;
    }

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        BasicCheck.CheckConfigurer extension = builder.title(Messages.DataSetFieldPresentationCheck_title).description(Messages.DataSetFieldPresentationCheck_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).issueType(IssueType.WARNING).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension());
        extension.topObject(DcsPackage.Literals.DATA_COMPOSITION_SCHEMA).containment(DcsPackage.Literals.DATA_SET_FIELD).features(new EStructuralFeature[]{DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_FIELD_FOLDER__TITLE, DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_FIELD__TITLE}).parameter(EXCLUDE_FIELD_NAME_PARAMETER_NAME, String.class, "", Messages.DataSetFieldPresentationCheck_Exclude_DCS_field_name_pattern);
        extension.topObject(FormPackage.Literals.FORM).containment(DcsPackage.Literals.DATA_SET_FIELD).features(new EStructuralFeature[]{DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_FIELD_FOLDER__TITLE, DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_FIELD__TITLE});
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        if (object instanceof DataSetField) {
            this.checkDataSetField(object, parameters, resultAcceptor);
        }
    }

    private void checkDataSetField(Object object, ICheckParameters parameters, BasicCheck.ResultAcceptor resultAcceptor) {
        DataSetField eObject = (DataSetField)object;
        if (eObject instanceof DataCompositionSchemaDataSetField) {
            DataCompositionSchemaDataSetField field = (DataCompositionSchemaDataSetField)eObject;
            String excludeFieldNamePattern = parameters.getString(EXCLUDE_FIELD_NAME_PARAMETER_NAME);
            if (StringUtils.isNotEmpty((String)excludeFieldNamePattern) && Pattern.matches(excludeFieldNamePattern, field.getField())) {
                return;
            }
            Presentation title = field.getTitle();
            IV8Project project = this.v8ProjectManager.getProject((EObject)eObject);
            if (project.getDefaultLanguage() != null && DataSetFieldPresentationCheck.isPresentationEmpty(title, project.getDefaultLanguage().getLanguageCode()) && !this.hasNameEqualedSource(field)) {
                String dataSetName = this.getDataSetName(eObject);
                String message = MessageFormat.format(Messages.DataSetFieldPresentationCheck_Data_set__0__field__1__title_is_empty, dataSetName, field.getField());
                resultAcceptor.addIssue(message, (EStructuralFeature)DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_FIELD__TITLE);
            }
        } else if (eObject instanceof DataCompositionSchemaDataSetFieldFolder) {
            DataCompositionSchemaDataSetFieldFolder field = (DataCompositionSchemaDataSetFieldFolder)eObject;
            String excludeFieldNamePattern = parameters.getString(EXCLUDE_FIELD_NAME_PARAMETER_NAME);
            if (StringUtils.isNotEmpty((String)excludeFieldNamePattern) && Pattern.matches(excludeFieldNamePattern, field.getDataPath())) {
                return;
            }
            Presentation title = field.getTitle();
            IV8Project project = this.v8ProjectManager.getProject((EObject)eObject);
            if (project.getDefaultLanguage() != null && DataSetFieldPresentationCheck.isPresentationEmpty(title, project.getDefaultLanguage().getLanguageCode())) {
                String dataSetName = this.getDataSetName(eObject);
                String message = MessageFormat.format(Messages.DataSetFieldPresentationCheck_Data_set__0__field_folder__1__title_is_empty, dataSetName, field.getDataPath());
                resultAcceptor.addIssue(message, (EStructuralFeature)DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_FIELD_FOLDER__TITLE);
            }
        }
    }

    private boolean hasNameEqualedSource(DataCompositionSchemaDataSetField field) {
        String fieldName = field.getField();
        if (StringUtils.isNullOrEmpty((String)fieldName)) {
            return false;
        }
        EObject parent = field.eContainer();
        if (parent.eContainer() instanceof DataSet) {
            return true;
        }
        if (parent instanceof DataCompositionSchemaDataSetUnion) {
            return true;
        }
        if (parent instanceof DataCompositionSchemaDataSetObject) {
            return false;
        }
        if (parent instanceof DataCompositionSchemaDataSetQuery) {
            boolean isAutoFillAvailableFields = ((DataCompositionSchemaDataSetQuery)parent).isAutoFillAvailableFields();
            return this.hasQueryFieldEqualedSource(fieldName, parent, DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_DATA_SET_QUERY__QUERY, isAutoFillAvailableFields);
        }
        if (parent instanceof DynamicListExtInfo) {
            boolean isAutoFillAvailableFields = ((DynamicListExtInfo)parent).isAutoFillAvailableFields();
            return this.hasQueryFieldEqualedSource(fieldName, parent, FormPackage.Literals.DYNAMIC_LIST_EXT_INFO__QUERY_TEXT, isAutoFillAvailableFields);
        }
        return false;
    }

    private boolean hasQueryFieldEqualedSource(String fieldName, EObject parent, EAttribute structuralFeature, boolean isAutoFillAvailableFields) {
        IFile file = this.resourceLookup.getPlatformResource(parent);
        if (file == null) {
            return false;
        }
        QuerySchema schema = this.dependentModelProvider.getQuerySchema(parent, (EStructuralFeature)structuralFeature, CancelIndicator.NullImpl);
        if (schema == null || schema.getQueries().isEmpty()) {
            return false;
        }
        QuerySchemaExpression queryField = this.getFieldSource(schema, fieldName);
        if (queryField == null && isAutoFillAvailableFields) {
            return true;
        }
        return this.hasNameEqualedSource(queryField, fieldName);
    }

    private boolean hasNameEqualedSource(QuerySchemaExpression field, String fieldName) {
        if (field == null || !(field.getExpression() instanceof CommonExpression)) {
            return false;
        }
        CommonExpression expression = (CommonExpression)field.getExpression();
        return this.isAiasEqualsContent(expression, fieldName) && this.hasNameEqualedSource(expression, expression.getContent(), (EObject)field);
    }

    private boolean hasNameEqualedSource(CommonExpression expression, String fieldName, EObject context) {
        EObject source;
        Set sourceObjects;
        DbViewElement dbView = null;
        try {
            dbView = this.dynamicDbViewFieldComputer.computeDbView((EObject)expression);
        }
        catch (Exception e) {
            DcsPlugin.logError(e);
            return false;
        }
        if (dbView == null) {
            return false;
        }
        if (dbView != null && dbView.eIsProxy()) {
            dbView = (DbViewElement)EcoreUtil.resolve((EObject)dbView, (EObject)context);
        }
        if (dbView instanceof DbViewVirtualFieldDef) {
            return fieldName.equalsIgnoreCase(dbView.getNameRu()) || fieldName.equalsIgnoreCase(dbView.getName());
        }
        EObject mdObject = dbView.getMdObject();
        if (mdObject instanceof MdObject) {
            return fieldName.equalsIgnoreCase(dbView.getNameRu()) || fieldName.equalsIgnoreCase(dbView.getName());
        }
        if (dbView instanceof DbViewFieldFieldDefFromQuery && !(sourceObjects = this.qlMapper.getSourceObjects((EObject)dbView)).isEmpty() && (source = (EObject)sourceObjects.iterator().next()) instanceof QuerySchemaExpression) {
            return this.hasNameEqualedSource((QuerySchemaExpression)source, fieldName);
        }
        return false;
    }

    private QuerySchemaExpression getFieldSource(QuerySchema schema, String fieldName) {
        AbstractQuerySchemaQuery query = (AbstractQuerySchemaQuery)schema.getQueries().get(schema.getQueries().size() - 1);
        if (query instanceof QuerySchemaSelectQuery) {
            for (QuerySchemaOperator operator : ((QuerySchemaSelectQuery)query).getOperators()) {
                for (QuerySchemaExpression field : operator.getSelectFields()) {
                    if (!fieldName.equalsIgnoreCase(field.getAlias())) continue;
                    return field;
                }
            }
        }
        return null;
    }

    private String getDataSetName(DataSetField eObject) {
        EObject parent = eObject.eContainer();
        FeatureKey featureKey = this.featureKeyProvider.getKey(parent);
        if (featureKey != null) {
            return featureKey.toString();
        }
        featureKey = this.featureKeyProvider.getKey((EObject)eObject);
        return featureKey.toString();
    }

    private static boolean isPresentationEmpty(Presentation title, String defauleLanguageCode) {
        return title == null || StringUtils.isNullOrEmpty((String)title.getValue()) && (title.getLocalValue() == null || StringUtils.isNullOrEmpty((String)((String)title.getLocalValue().getContent().get((Object)defauleLanguageCode))));
    }

    private boolean isAiasEqualsContent(CommonExpression expression, String alias) {
        StringBuilder sb = new StringBuilder(expression.getContent());
        CommonExpression current = expression;
        while (current instanceof MultiPartCommonExpression) {
            if (alias.equalsIgnoreCase(sb.toString())) {
                return true;
            }
            current = ((MultiPartCommonExpression)current).getSourceTable();
            sb.insert(0, current.getContent());
        }
        return alias.equalsIgnoreCase(sb.toString());
    }
}

