/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.check;

import com._1c.g5.v8.dt.dcs.model.core.DcsPackage;
import com._1c.g5.v8.dt.dcs.model.core.Presentation;
import com._1c.g5.v8.dt.dcs.model.schema.DcsPackage;
import com.e1c.g5.v8.dt.check.CheckComplexity;
import com.e1c.g5.v8.dt.check.ICheckParameters;
import com.e1c.g5.v8.dt.check.components.BasicCheck;
import com.e1c.g5.v8.dt.check.components.IBasicCheckExtension;
import com.e1c.g5.v8.dt.check.settings.IssueSeverity;
import com.e1c.g5.v8.dt.check.settings.IssueType;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.check.AbstractTranslationValidator;
import com.e1c.langtool.v8.dt.check.DefaultDisbledCheckExtension;
import com.e1c.langtool.v8.dt.dcs.check.Messages;
import com.e1c.langtool.v8.dt.dcs.settings.DcsFeatureSettings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PresentationTranslationCheck
extends AbstractTranslationValidator {
    private static final String CHECK_ID = "dcs-presentation-translation";

    public String getCheckId() {
        return CHECK_ID;
    }

    protected void configureCheck(BasicCheck.CheckConfigurer builder) {
        super.configureCheck(builder);
        builder.title(Messages.PresentationTranslationCheck_title).description(Messages.PresentationTranslationCheck_description).complexity(CheckComplexity.NORMAL).severity(IssueSeverity.MAJOR).issueType(IssueType.WARNING).extension((IBasicCheckExtension)new DefaultDisbledCheckExtension()).topObject(DcsPackage.Literals.DATA_COMPOSITION_SCHEMA).containment(DcsPackage.Literals.PRESENTATION).features(new EStructuralFeature[]{DcsPackage.Literals.PRESENTATION__VALUE, DcsPackage.Literals.PRESENTATION__LOCAL_VALUE, DcsPackage.Literals.LOCAL_STRING__CONTENT});
    }

    protected void check(Object object, BasicCheck.ResultAcceptor resultAcceptor, ICheckParameters parameters, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        Presentation presentation = (Presentation)object;
        if (presentation.getLocalValue() == null && StringUtils.isNotEmpty((String)presentation.getValue())) {
            IProject project = this.resourceLookup.getProject((EObject)presentation);
            if (project == null) {
                return;
            }
            ITranslatingProject translatingProject = this.projectManager.getProject(project);
            if (!translatingProject.isTranslating()) {
                return;
            }
            List languages = translatingProject.getInterfaceLanguages();
            if (languages.isEmpty()) {
                return;
            }
            Collection languageNames = languages.stream().map(TranslateLanguage::getName).collect(Collectors.toList());
            FeatureKey key = this.featureKeyProvider.getFeatureKey((EObject)presentation, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT);
            this.addNoTranslationMessage((EObject)presentation, resultAcceptor, presentation.getValue(), key, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT, languageNames);
        } else if (presentation.getLocalValue() != null) {
            this.checkTranslation((EObject)presentation.getLocalValue(), resultAcceptor, parameters, monitor);
        }
    }

    protected void addNoTranslationMessage(EObject object, BasicCheck.ResultAcceptor resultAcceptor, String value, FeatureKey key, FeatureSettings featureSettings, Collection<String> languages) {
        if (object instanceof Presentation) {
            super.addNoTranslationMessage(object, resultAcceptor, value, key, featureSettings, Collections.emptyList());
        } else {
            super.addNoTranslationMessage(object.eContainer(), resultAcceptor, value, key, featureSettings, Collections.emptyList());
        }
    }

    protected EStructuralFeature getMessageFeature(FeatureSettings featureSettings) {
        return DcsPackage.Literals.PRESENTATION__LOCAL_VALUE;
    }
}

