/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.sync;

import com._1c.g5.v8.bm.core.IBmNamespace;
import com._1c.g5.v8.bm.core.IBmPlatformTransaction;
import com._1c.g5.v8.dt.dcs.model.core.DataCompositionParameter;
import com._1c.g5.v8.dt.dcs.model.core.DcsFactory;
import com._1c.g5.v8.dt.dcs.model.core.DcsPackage;
import com._1c.g5.v8.dt.dcs.model.core.LocalString;
import com._1c.g5.v8.dt.dcs.model.core.Presentation;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaTotalField;
import com._1c.g5.v8.dt.dcs.model.schema.DcsPackage;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.platform.version.IRuntimeVersionSupport;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.dcs.DcsParameterValueProvider;
import com.e1c.langtool.v8.dt.dcs.settings.DcsFeatureSettings;
import com.e1c.langtool.v8.dt.dcs.translator.TotalFielGroupsTranslationProvider;
import com.e1c.langtool.v8.dt.sync.BmObjectCopier;
import com.e1c.langtool.v8.dt.sync.naming.TranslatedTopObjectFqnGenerator;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DcsObjectCopier
extends BmObjectCopier {
    @Inject
    private ITranslationFeatureKeyProvider featureKeyProvider;
    @Inject
    private TranslatedTopObjectFqnGenerator topObjectFqnGenerator;
    @Inject
    private TotalFielGroupsTranslationProvider totalFielGroupsTranslationProvider;
    @Inject
    private DcsParameterValueProvider dcsParameterValueProvider;
    @Inject
    private IRuntimeVersionSupport runtimeVersionSupport;
    private final EObject sourceRoot;
    private String translatedTopObjectFqn;
    private final IFile sourceFile;

    public DcsObjectCopier(IProject project, IBmPlatformTransaction transaction, IFile sourceFile, EObject sourceRoot, IProjectTranslationProvider translationProvider, IBmNamespace targetNamespace, Version runtimeVersion) {
        super(project, transaction, sourceRoot, translationProvider, targetNamespace, runtimeVersion);
        this.sourceFile = sourceFile;
        this.sourceRoot = sourceRoot;
    }

    protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        super.copyContainment(eReference, eObject, copyEObject);
        if (copyEObject instanceof Presentation && ((Presentation)copyEObject).getLocalValue() == null && !this.translationProvider.getProject().getInterfaceLanguages().isEmpty()) {
            this.modifyPresentationAfterCopy((Presentation)eObject, (Presentation)copyEObject);
        }
        this.replaceParameters(eReference, eObject, copyEObject);
    }

    /*
     * WARNING - void declaration
     */
    private void replaceParameters(EReference eReference, EObject eObject, EObject copyEObject) {
        EObject eObject2 = copyEObject;
        if (eObject2 instanceof LocalString) {
            LocalString localString = (LocalString)eObject2;
            LocalString cfr_ignored_0 = (LocalString)eObject2;
            EObject eObject3 = eObject;
            if (eObject3 instanceof LocalString) {
                void originalLocalString;
                LocalString localString2 = (LocalString)eObject3;
                LocalString cfr_ignored_1 = (LocalString)eObject3;
                List<Pattern> patterns = List.of(StringUtils.PERCENT_PARAMETER_PATTERN, StringUtils.SQUARE_BRACKETS_PARAMETER_PATTERN);
                String defaultLanguageCode = this.translationProvider.getProject().getSourceProject().getDefaultLanguage().getLanguageCode();
                String originalValue = (String)originalLocalString.getContent().get((Object)defaultLanguageCode);
                List originalIndexes = StringUtils.getParamsIndexesFromString((String)originalValue, patterns);
                if (originalIndexes.isEmpty()) {
                    return;
                }
                FeatureKey featureKey = this.featureKeyProvider.getFeatureKey(eObject, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT);
                ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(this.sourceFile, featureKey, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT, originalValue);
                ArrayList originalParams = Lists.newArrayList();
                for (Pair index : originalIndexes) {
                    originalParams.add(originalValue.substring((Integer)index.getKey(), (Integer)index.getValue()));
                }
                for (TranslateLanguage language : this.translationProvider.getProject().getInterfaceLanguages()) {
                    void translatedLocalString;
                    String translatedValue = (String)translatedLocalString.getContent().get((Object)language.getLanguageCode());
                    if (!StringUtils.isNotEmpty((String)translatedValue) || !StringUtils.isNotEmpty((String)originalValue)) continue;
                    List translatedIndexes = StringUtils.getParamsIndexesFromString((String)translatedValue, patterns);
                    ArrayList translatedParams = Lists.newArrayList();
                    for (Pair index : translatedIndexes) {
                        translatedParams.add(translatedValue.substring((Integer)index.getKey(), (Integer)index.getValue()));
                    }
                    if (originalParams.size() != translatedParams.size()) continue;
                    int i = 0;
                    while (i < originalParams.size()) {
                        translatedValue = translatedValue.replaceFirst(((String)translatedParams.get(i)).replace("[", "\\[").replace("]", "\\]"), (String)originalParams.get(i));
                        ++i;
                    }
                    String newValue = this.replaceTranslatedStringParameters((ContextTranslationKey)contextKey, language, translatedValue);
                    if (newValue.equals(translatedValue)) continue;
                    translatedLocalString.getContent().put((Object)language.getLanguageCode(), (Object)newValue);
                }
            }
        }
    }

    protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
        super.copyAttribute(eAttribute, eObject, copyEObject);
        if (DcsPackage.Literals.DATA_COMPOSITION_SCHEMA_TOTAL_FIELD__GROUPS == eAttribute && eObject instanceof DataCompositionSchemaTotalField && copyEObject instanceof DataCompositionSchemaTotalField) {
            this.updateTotalFieldGroups((DataCompositionSchemaTotalField)eObject, (DataCompositionSchemaTotalField)copyEObject);
        }
        if (DcsPackage.Literals.DATA_COMPOSITION_PARAMETER__VALUE == eAttribute && eObject instanceof DataCompositionParameter && copyEObject instanceof DataCompositionParameter) {
            this.updateParameterName((DataCompositionParameter)eObject, (DataCompositionParameter)copyEObject);
        }
    }

    protected String getTranslatedTopObjectFqn() {
        if (this.translatedTopObjectFqn == null) {
            this.translatedTopObjectFqn = this.topObjectFqnGenerator.generateFqn(this.sourceRoot, this.translationProvider);
        }
        return this.translatedTopObjectFqn;
    }

    private void modifyPresentationAfterCopy(Presentation eObject, Presentation copyEObject) {
        LocalString local = DcsFactory.eINSTANCE.createLocalString();
        copyEObject.setLocalValue(local);
        String value = copyEObject.getValue();
        copyEObject.eUnset((EStructuralFeature)DcsPackage.Literals.PRESENTATION__VALUE);
        if (StringUtils.isNotEmpty((String)value)) {
            String defaultLanguageCode = this.translationProvider.getProject().getSourceProject().getDefaultLanguage().getLanguageCode();
            local.getContent().put((Object)defaultLanguageCode, (Object)value);
        }
        EMap featureValue = local.getContent();
        Iterator iterator = featureValue.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (this.getLanguageCodes().contains(entry.getKey())) continue;
            iterator.remove();
        }
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)eObject, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT);
        ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(this.sourceFile, featureKey, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT, eObject.getValue());
        for (TranslateLanguage language : this.translationProvider.getProject().getInterfaceLanguages()) {
            String translation = this.translationProvider.getTranslation((EObject)eObject, (ContextTranslationKey)contextKey, language);
            if (!StringUtils.isNotEmpty((String)translation) || translation.equals(featureValue.get((Object)language.getLanguageCode()))) continue;
            featureValue.put((Object)language.getLanguageCode(), (Object)translation);
        }
    }

    private void updateTotalFieldGroups(DataCompositionSchemaTotalField eObject, DataCompositionSchemaTotalField copyEObject) {
        EList sourceGroups = eObject.getGroups();
        EList copyGroups = copyEObject.getGroups();
        if (!sourceGroups.isEmpty() && sourceGroups.size() == copyGroups.size() && (this.translationProvider.getProject().isChangeDefaultLanguage() || this.translationProvider.getProject().isChangeScriptVariant())) {
            TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
            int i = 0;
            while (i < sourceGroups.size()) {
                String translation;
                String group = (String)sourceGroups.get(i);
                if (!StringUtils.isNullOrEmpty((String)group) && !StringUtils.isNullOrEmpty((String)(translation = this.totalFielGroupsTranslationProvider.computeTranslatedString((EObject)eObject, group, this.translationProvider, language)))) {
                    copyGroups.set(i, translation);
                }
                ++i;
            }
        }
    }

    private void updateParameterName(DataCompositionParameter eObject, DataCompositionParameter copyEObject) {
        boolean isRussian;
        Version version;
        String value = eObject.getValue();
        EObject parent = eObject.eContainer();
        if (parent != null) {
            parent = parent.eContainer();
        }
        if (value == null) {
            return;
        }
        String typeName = parent == null ? null : parent.eClass().getName();
        String name = this.dcsParameterValueProvider.getParameterName(value, typeName, version = this.runtimeVersionSupport.getRuntimeVersionOrDefault((EObject)eObject, Version.LATEST), isRussian = this.translationProvider.getProject().getScriptVariant() == ScriptVariant.RUSSIAN);
        if (StringUtils.isNotEmpty((String)name)) {
            copyEObject.setValue(name);
        } else {
            name = this.dcsParameterValueProvider.getParameterName(value, version, isRussian);
            if (StringUtils.isNotEmpty((String)name)) {
                copyEObject.setValue(name);
            }
        }
    }

    private String replaceTranslatedStringParameters(ContextTranslationKey key, TranslateLanguage language, String translation) {
        List originalStringIndexes = StringUtils.getParamsIndexesFromString((String)key.getValue(), List.of(StringUtils.PERCENT_PARAMETER_PATTERN, StringUtils.SQUARE_BRACKETS_PARAMETER_PATTERN));
        if (!originalStringIndexes.isEmpty()) {
            List translationStringIndexes;
            List translations = StringUtils.replaceStringLiteralParams((String)key.getValue(), (List)Lists.newArrayList((Object[])new String[]{translation}));
            if (!translations.isEmpty()) {
                translation = (String)translations.get(0);
            }
            if (StringUtils.isBlank((String)translation)) {
                translation = key.getValue();
            }
            if ((translationStringIndexes = StringUtils.getParamsIndexesFromString((String)translation, List.of(StringUtils.PERCENT_PARAMETER_PATTERN, StringUtils.SQUARE_BRACKETS_PARAMETER_PATTERN))).size() == originalStringIndexes.size()) {
                int i = 0;
                while (i < originalStringIndexes.size()) {
                    Pair originalStringIndex = (Pair)originalStringIndexes.get(i);
                    String originalParameter = key.getValue().substring((Integer)originalStringIndex.getKey() + 1, (Integer)originalStringIndex.getValue() - 1);
                    FeatureKey paramFeatureKey = key.getFeatureKey().append(originalParameter).append("Param");
                    ContextTranslationKeyImpl paramKey = new ContextTranslationKeyImpl(key.getFullPath(), paramFeatureKey, DcsFeatureSettings.Literals.STRING_VALUE__PARAM, originalParameter);
                    String paramTranslation = this.translationProvider.getStoredTranslation((ContextTranslationKey)paramKey, language, new ITranslationStorageProvider.Storage.Type[0]);
                    if (StringUtils.isNotEmpty((String)paramTranslation)) {
                        translation = translation.replaceFirst(originalParameter, paramTranslation);
                    }
                    ++i;
                }
            }
        }
        return translation;
    }
}

