/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.dcs.translator;

import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchema;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchemaCalculatedField;
import com._1c.g5.v8.dt.dcs.model.schema.DataSetField;
import com._1c.g5.v8.dt.dcs.util.DcsTerms;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.dcs.translator.AbstractFieldProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Singleton;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

@Singleton
public class TotalFielGroupsTranslationProvider
extends AbstractFieldProvider {
    private static final String OVERALL = DcsTerms.kDCSDCOverallTerm[0];
    private static final String OVERALL_RU = DcsTerms.kDCSDCOverallTerm[1];
    private static final String HIERARCHY = " " + DcsTerms.kDCSDCHierarchyTerm[0];
    private static final String HIERARCHY_RU = " " + DcsTerms.kDCSDCHierarchyTerm[1];

    public String computeTranslatedString(EObject object, String dataPath, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        String hierarchy;
        String newDataPath;
        if (OVERALL_RU.equalsIgnoreCase(dataPath) || OVERALL.equalsIgnoreCase(dataPath)) {
            boolean isRu = translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
            return isRu ? OVERALL_RU : OVERALL;
        }
        DataCompositionSchema schema = (DataCompositionSchema)EcoreUtil2.getContainerOfType((EObject)object, DataCompositionSchema.class);
        if (schema == null) {
            return null;
        }
        if (dataPath.endsWith(HIERARCHY)) {
            newDataPath = dataPath.substring(0, dataPath.length() - HIERARCHY.length());
            isRu = translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
            hierarchy = isRu ? HIERARCHY_RU : HIERARCHY;
        } else if (dataPath.endsWith(HIERARCHY_RU)) {
            newDataPath = dataPath.substring(0, dataPath.length() - HIERARCHY_RU.length());
            isRu = translationProvider.getProject().getScriptVariant().equals((Object)ScriptVariant.RUSSIAN);
            hierarchy = isRu ? HIERARCHY_RU : HIERARCHY;
        } else {
            newDataPath = dataPath;
            hierarchy = "";
        }
        Optional<DataCompositionSchemaCalculatedField> calcField = this.getCalculatedFields(schema, newDataPath);
        if (calcField.isPresent()) {
            return calcField.map(f -> {
                String translation = this.getCalculatedFieldTranslation((DataCompositionSchemaCalculatedField)f, translationProvider, language);
                if (translation != null) {
                    translation = translation.concat(hierarchy);
                }
                return translation;
            }).orElse(null);
        }
        Optional<DataSetField> field = this.getDataSetField(schema, newDataPath);
        return field.map(f -> {
            String translation = this.getDataSetFieldTranslation((DataSetField)f, translationProvider, language);
            if (translation != null) {
                translation = translation.concat(hierarchy);
            }
            return translation;
        }).orElse(null);
    }
}

