/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.dcs.i18n;

import com._1c.g5.v8.dt.core.platform.V8ParametersStringParser;
import com._1c.g5.v8.dt.dcs.model.core.DataCompositionParameter;
import com._1c.g5.v8.dt.dcs.model.core.DcsFactory;
import com._1c.g5.v8.dt.dcs.model.core.DcsPackage;
import com._1c.g5.v8.dt.dcs.model.core.LocalString;
import com._1c.g5.v8.dt.dcs.model.core.Presentation;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchema;
import com._1c.g5.v8.dt.dcs.model.settings.SettingsParameterValue;
import com._1c.g5.v8.dt.dcs.parameters.DcsAvailableParameter;
import com._1c.g5.v8.dt.dcs.parameters.DcsAvailableParameters;
import com._1c.g5.v8.dt.dcs.parameters.DcsAvailableParametersService;
import com._1c.g5.v8.dt.dcs.parameters.DcsParameterValuesBase;
import com._1c.g5.v8.dt.dcs.parameters.appearance.AppearanceTemplateAppearanceParameters;
import com._1c.g5.v8.dt.dcs.parameters.appearance.DynamicListAppearanceParameters;
import com._1c.g5.v8.dt.dcs.parameters.appearance.FormAppearanceParameters;
import com._1c.g5.v8.dt.dcs.parameters.input.DcsInputParameters;
import com._1c.g5.v8.dt.dcs.parameters.output.DcsChartGroupOutputParameters;
import com._1c.g5.v8.dt.dcs.parameters.output.DcsChartOutputParameters;
import com._1c.g5.v8.dt.dcs.parameters.output.DcsGroupOutputParameters;
import com._1c.g5.v8.dt.dcs.parameters.output.DcsOutputParameters;
import com._1c.g5.v8.dt.dcs.parameters.output.DcsTableGroupOutputParameters;
import com._1c.g5.v8.dt.dcs.parameters.output.DcsTableOutputParameters;
import com._1c.g5.v8.dt.dcs.path.DcsPathException;
import com._1c.g5.v8.dt.mcore.StringValue;
import com._1c.g5.v8.dt.mcore.TypeItem;
import com._1c.g5.v8.dt.mcore.Value;
import com._1c.g5.v8.dt.platform.version.IRuntimeVersionSupport;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.TranslationProperties;
import com.e1c.langtool.v8.dt.dcs.DcsProcessor;
import com.e1c.langtool.v8.dt.dcs.settings.DcsFeatureSettings;
import com.e1c.langtool.v8.dt.dcs.settings.impl.ExpressionsField;
import com.e1c.langtool.v8.dt.internal.dcs.DcsPlugin;
import com.e1c.langtool.v8.dt.internal.dcs.i18n.DcsExprFeatureKeyComputer2;
import com.e1c.langtool.v8.dt.internal.dcs.i18n.DcsNStrUtil;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DcsLoadingPostprocessor
extends DcsProcessor {
    private final ITranslationFeatureKeyProvider featureKeyProvider;
    private final URI resourceURI;
    private final IFile resourceFile;
    private final String defaultLanguageCode;
    private final Collection<TranslateLanguage> languages;
    private final ITranslationStorageProvider.ContextStorage storage;
    private final TranslationProperties properties;
    private final DcsExprFeatureKeyComputer2 featureKeyComputer;
    @Inject
    private IRuntimeVersionSupport runtimeVersionSupport;
    private static final Set<Class<? extends DcsParameterValuesBase>> PARAMETER_CREATORS_SET = new HashSet<Class<? extends DcsParameterValuesBase>>();

    static {
        PARAMETER_CREATORS_SET.add(DynamicListAppearanceParameters.class);
        PARAMETER_CREATORS_SET.add(DcsChartGroupOutputParameters.class);
        PARAMETER_CREATORS_SET.add(DcsChartOutputParameters.class);
        PARAMETER_CREATORS_SET.add(DcsGroupOutputParameters.class);
        PARAMETER_CREATORS_SET.add(DcsOutputParameters.class);
        PARAMETER_CREATORS_SET.add(DcsTableGroupOutputParameters.class);
        PARAMETER_CREATORS_SET.add(DcsTableOutputParameters.class);
        PARAMETER_CREATORS_SET.add(AppearanceTemplateAppearanceParameters.class);
        PARAMETER_CREATORS_SET.add(FormAppearanceParameters.class);
        PARAMETER_CREATORS_SET.add(DcsInputParameters.class);
    }

    public DcsLoadingPostprocessor(ITranslationFeatureKeyProvider featureKeyProvider, DcsExprFeatureKeyComputer2 featureKeyComputer, DataCompositionSchema document, URI resourceURI, IFile resourceFile, String defaultLanguageCode, Collection<TranslateLanguage> languages, ITranslationStorageProvider.ContextStorage storage, TranslationProperties properties) {
        super((EObject)document);
        this.featureKeyProvider = featureKeyProvider;
        this.featureKeyComputer = featureKeyComputer;
        this.resourceURI = resourceURI;
        this.resourceFile = resourceFile;
        this.defaultLanguageCode = defaultLanguageCode;
        this.languages = languages;
        this.storage = storage;
        this.properties = properties;
    }

    @Override
    protected <T extends EObject> void doProcess(T object, Class<T> clazz) {
        if (clazz.equals(Presentation.class)) {
            this.doProcessInternal((Presentation)object);
        } else if (clazz.equals(SettingsParameterValue.class)) {
            this.doProcessInternal((SettingsParameterValue)object);
        } else {
            Set<Class<?>> allSupportedClasses = ExpressionsField.getAllSupportedClasses();
            if (allSupportedClasses.contains(clazz)) {
                this.processObjectFieldsWithNStr(object, clazz);
            }
        }
    }

    private void doProcessInternal(SettingsParameterValue parameterValue) {
        Value value;
        EList values;
        if (this.isLocalStringParameter(parameterValue.getParameter()) && (values = parameterValue.getValues()).size() == 1 && (value = (Value)values.get(0)) instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            String stringValueContent = stringValue.getValue();
            FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)stringValue, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT);
            ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(this.resourceFile, featureKey, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT, stringValueContent);
            LocalString localString = DcsFactory.eINSTANCE.createLocalString();
            EMap localStringContent = localString.getContent();
            localStringContent.put((Object)this.defaultLanguageCode, (Object)stringValueContent);
            values.clear();
            values.add((Object)localString);
            this.fillStringsWithTranslations((ContextTranslationKey)contextKey, (EMap<String, String>)localStringContent);
        }
    }

    private boolean isLocalStringParameter(DataCompositionParameter parameter) {
        String parameterName = parameter.getValue();
        Version version = this.runtimeVersionSupport.getRuntimeVersion((EObject)parameter);
        for (Class<? extends DcsParameterValuesBase> clazz : PARAMETER_CREATORS_SET) {
            DcsAvailableParameter availableParameter;
            DcsAvailableParameters availableParameters = this.geAvailableParameters(clazz, version);
            if (availableParameters == null || (availableParameter = availableParameters.getParameters().findItem(parameterName)) == null) continue;
            EList types = availableParameter.getType().getTypes();
            for (TypeItem type : types) {
                if (!"LocalString".equals(type.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private DcsAvailableParameters geAvailableParameters(Class<? extends DcsParameterValuesBase> clazz, Version version) {
        if (clazz != null) {
            try {
                DcsParameterValuesBase parameterValues = DcsAvailableParametersService.INSTANCE.loadParameterValues(null, clazz, version, this.defaultLanguageCode);
                return parameterValues.getAvailableParameters();
            }
            catch (DcsPathException e) {
                DcsPlugin.log(DcsPlugin.createErrorStatus(e.getMessage(), e));
            }
        }
        return null;
    }

    private void doProcessInternal(Presentation object) {
        EMap localStringContent;
        String value = object.getValue();
        if (object.getLocalValue() == null) {
            LocalString localString = DcsFactory.eINSTANCE.createLocalString();
            object.setLocalValue(localString);
            object.eUnset((EStructuralFeature)DcsPackage.Literals.PRESENTATION__VALUE);
            EMap localStringContent2 = localString.getContent();
            localStringContent2.put((Object)this.defaultLanguageCode, (Object)value);
        } else if (object.eIsSet((EStructuralFeature)DcsPackage.Literals.PRESENTATION__VALUE)) {
            object.eUnset((EStructuralFeature)DcsPackage.Literals.PRESENTATION__VALUE);
            localStringContent = object.getLocalValue().getContent();
            localStringContent.put((Object)this.defaultLanguageCode, (Object)value);
        }
        if (object.getLocalValue().getContent().containsKey((Object)this.defaultLanguageCode)) {
            value = (String)object.getLocalValue().getContent().get((Object)this.defaultLanguageCode);
        }
        localStringContent = object.getLocalValue().getContent();
        FeatureKey featureKey = this.featureKeyProvider.getFeatureKey((EObject)object, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT);
        ContextTranslationKeyImpl contextKey = new ContextTranslationKeyImpl(this.resourceFile, featureKey, (FeatureSettings)DcsFeatureSettings.Literals.LOCAL_STRING__CONTENT, value);
        this.fillStringsWithTranslations((ContextTranslationKey)contextKey, (EMap<String, String>)localStringContent);
    }

    private void fillStringsWithTranslations(ContextTranslationKey contextKey, EMap<String, String> localStringContent) {
        for (TranslateLanguage language : this.languages) {
            String translation = this.storage.getTranslation(contextKey, language);
            if (!StringUtils.isNotEmpty((String)translation) || translation.equals(localStringContent.get((Object)language.getLanguageCode()))) continue;
            localStringContent.put((Object)language.getLanguageCode(), (Object)translation);
        }
        if (this.properties.fillEmptyInterfaceTranslation()) {
            for (TranslateLanguage language : this.languages) {
                if (localStringContent.containsKey((Object)language.getLanguageCode()) && !StringUtils.isNullOrEmpty((String)((String)localStringContent.get((Object)language.getLanguageCode())))) continue;
                this.fillupEmptyInterface(localStringContent, language);
            }
        }
    }

    private <T extends EObject> void processObjectFieldsWithNStr(EObject object, Class<T> clazz) {
        EFeatureSettings[] features;
        EFeatureSettings[] eFeatureSettingsArray = features = ExpressionsField.getFeatures(clazz);
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EFeatureSettings feature = eFeatureSettingsArray[n2];
            EStructuralFeature structuralFeature = feature.getEFeature();
            if (object.eIsSet(structuralFeature)) {
                String expression = (String)object.eGet(structuralFeature);
                FeatureKey fieldFeatureKey = this.featureKeyComputer.computeFqn(object, feature);
                String processedExpression = DcsNStrUtil.processExpressionWithNStr(fieldFeatureKey, expression, this::processNStr);
                object.eSet(structuralFeature, (Object)processedExpression);
            }
            ++n2;
        }
    }

    private String processNStr(FeatureKey fieldFeatureKey, String value) {
        V8ParametersStringParser parser = new V8ParametersStringParser(value);
        if (parser.getStatus().isOK()) {
            Map parameters = parser.getParameters();
            String sourceString = (String)parameters.get(this.defaultLanguageCode);
            ContextTranslationKey contextKey = DcsNStrUtil.buildNStrContextTranslationKey(this.resourceFile, this.resourceURI, fieldFeatureKey, sourceString);
            for (TranslateLanguage language : this.languages) {
                String translation = this.storage.getTranslation(contextKey, language);
                if (!StringUtils.isNotEmpty((String)translation) || translation.equals(parameters.get(language.getLanguageCode()))) continue;
                parameters.put(language.getLanguageCode(), translation);
            }
            if (this.properties.fillEmptyInterfaceTranslation()) {
                for (TranslateLanguage language : this.languages) {
                    if (parameters.containsKey(language.getLanguageCode()) && !StringUtils.isNullOrEmpty((String)((String)parameters.get(language.getLanguageCode())))) continue;
                    this.fillupEmptyInterface(parameters, language);
                }
            }
            return DcsNStrUtil.formatNStr(parameters);
        }
        return value;
    }

    private void fillupEmptyInterface(EMap<String, String> values, TranslateLanguage language) {
        TranslateLanguage newLang = this.properties.getLanguageToFillEmptyInterfaceTranslation(language);
        if (newLang == null) {
            return;
        }
        HashSet<String> checked = new HashSet<String>();
        checked.add(language.getLanguageCode());
        while (newLang != null && !checked.contains(newLang.getLanguageCode())) {
            String value = (String)values.get((Object)newLang.getLanguageCode());
            if (StringUtils.isNullOrEmpty((String)value)) {
                checked.add(newLang.getLanguageCode());
                newLang = this.properties.getLanguageToFillEmptyInterfaceTranslation(newLang);
                continue;
            }
            values.put((Object)language.getLanguageCode(), (Object)value);
            return;
        }
    }

    private void fillupEmptyInterface(Map<String, String> values, TranslateLanguage language) {
        TranslateLanguage newLang = this.properties.getLanguageToFillEmptyInterfaceTranslation(language);
        if (newLang == null) {
            return;
        }
        HashSet<String> checked = new HashSet<String>();
        checked.add(language.getLanguageCode());
        while (newLang != null && !checked.contains(newLang.getLanguageCode())) {
            String value = values.get(newLang.getLanguageCode());
            if (StringUtils.isNullOrEmpty((String)value)) {
                checked.add(newLang.getLanguageCode());
                newLang = this.properties.getLanguageToFillEmptyInterfaceTranslation(newLang);
                continue;
            }
            values.put(language.getLanguageCode(), value);
            return;
        }
    }
}

