/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.dcs.i18n;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.v8.dt.dcs.expressions.settings.DcsExprFeatureSettings;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;

public class DcsNStrUtil {
    private static final String ONE_DOUBLE_QUOTE = "\"";
    private static final String TWO_DOUBLE_QUOTES = "\"\"";
    private static final String NSTR_RU = "\u041d\u0421\u0422\u0420";
    private static final String NSTR_EN = "NSTR";
    private static final QName QNAME_EXPRESSION = new QName("expression");
    private static final Pattern PATTERN_NSTR = Pattern.compile("(\\b(?:\u041d\u0421\u0442\u0440|NStr)\\s*\\(\\s*\")((?:\"\"|[^\"])+)(\"\\s*\\))", 66);
    private static final String SINGLE_ENTRY_NSTR_TEMPLATE = "%s = '%s'";
    private static final String FEATURE_KEY_NSTR = "NStr";
    private static final String FEATURE_KEY_VALUE = "Value";

    private DcsNStrUtil() {
    }

    public static boolean canContainNStr(String value) {
        if (value != null) {
            String uppercaseValue = value.toUpperCase();
            return uppercaseValue.contains(NSTR_RU) || uppercaseValue.contains(NSTR_EN);
        }
        return false;
    }

    public static boolean isExpressionWithNStr(String value, QName elementName) {
        if (value != null && QNAME_EXPRESSION.equals(elementName)) {
            return DcsNStrUtil.canContainNStr(value);
        }
        return false;
    }

    public static String processExpressionWithNStr(FeatureKey fieldFeatureKey, String expression, BiFunction<FeatureKey, String, String> processor) {
        Matcher matcher = PATTERN_NSTR.matcher(expression);
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            String unescapedStringBody = matcher.group(2).replace(TWO_DOUBLE_QUOTES, ONE_DOUBLE_QUOTE);
            String processedStringBody = processor.apply(fieldFeatureKey, unescapedStringBody);
            String escapedStringBody = processedStringBody.replace(ONE_DOUBLE_QUOTE, TWO_DOUBLE_QUOTES);
            matcher.appendReplacement(builder, matcher.group(1) + escapedStringBody + matcher.group(3));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    public static String formatNStr(Map<String, String> strings) {
        return strings.entrySet().stream().map(entry -> String.format(SINGLE_ENTRY_NSTR_TEMPLATE, entry.getKey(), ((String)entry.getValue()).replace("'", "''"))).collect(Collectors.joining("; "));
    }

    public static ContextTranslationKey buildNStrContextTranslationKey(IFile file, URI fileURI, FeatureKey featureKey, String sourceString) {
        FeatureKey featureNStrKey = featureKey.append(FEATURE_KEY_NSTR).append(sourceString).append(FEATURE_KEY_VALUE);
        return new ContextTranslationKeyImpl(file, featureNStrKey, (FeatureSettings)DcsExprFeatureSettings.Literals.NSTR_STRING_LITERAL__VALUE, sourceString);
    }
}

