/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.dcs.i18n.xml;

import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.dcs.DcsPlugin;
import com._1c.g5.v8.dt.dcs.model.schema.DataCompositionSchema;
import com._1c.g5.v8.dt.dcs.util.DcsV8Serializer;
import com._1c.g5.v8.dt.export.ExportException;
import com._1c.g5.v8.dt.export.IExportArtifactBuilder;
import com._1c.g5.v8.dt.export.xml.IExportContext;
import com._1c.g5.v8.dt.export.xml.IExporter;
import com._1c.g5.v8.dt.lifecycle.LifecycleParticipant;
import com._1c.g5.v8.dt.lifecycle.LifecyclePhase;
import com._1c.g5.v8.dt.lifecycle.LifecycleService;
import com._1c.g5.v8.dt.md.export.xml.IXmlExporterExtension;
import com._1c.g5.v8.dt.md.export.xml.IXmlExporterExtensionManager;
import com._1c.g5.v8.dt.metadata.mdclass.BasicTemplate;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com._1c.g5.v8.dt.metadata.mdclass.TemplateType;
import com._1c.g5.v8.dt.xml.LineFeedConverter;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.v8.dt.documentprocessingsettings.IDocumentProcessingSettingsManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@LifecycleService(name="DcsXmlExporterExtension")
@Singleton
public class DcsXmlExporterExtension
implements IXmlExporterExtension {
    private static final String LF_STRING = "\n";
    private final ITranslatingProjectManager translatingProjectManager;
    private final IDocumentProcessingSettingsManager documentProcessingSettingsManager;
    private final IResourceLookup resourceLookup;
    private final IXmlExporterExtensionManager xmlExporterExtensionManager;
    private boolean initialized = false;

    @Inject
    public DcsXmlExporterExtension(ITranslatingProjectManager translatingProjectManager, IDocumentProcessingSettingsManager documentProcessingSettingsManager, IResourceLookup resourceLookup, IXmlExporterExtensionManager xmlExporterExtensionManager) {
        this.translatingProjectManager = translatingProjectManager;
        this.documentProcessingSettingsManager = documentProcessingSettingsManager;
        this.resourceLookup = resourceLookup;
        this.xmlExporterExtensionManager = xmlExporterExtensionManager;
    }

    public void copyTemplateWithLineFeedConversion(IExporter exporter, EObject eObject, IExportContext exportContext, IExportArtifactBuilder artifactBuilder, Path source, Path target, LineFeedConverter.ConvertOption ... options) throws ExportException {
        EObject dcsTemplate;
        if (DcsPlugin.getDefault().isDebugging()) {
            DcsPlugin.log((IStatus)DcsPlugin.createInfoStatus((String)"Exporting DCS to Platform XML."));
            DcsPlugin.log((IStatus)DcsPlugin.createInfoStatus((String)("DCS template name: " + ((MdObject)eObject).getName())));
        }
        if ((dcsTemplate = ((BasicTemplate)eObject).getTemplate()) instanceof DataCompositionSchema) {
            DataCompositionSchema dcs = (DataCompositionSchema)dcsTemplate;
            Path outputPath = exporter.getOutputPath(eObject, (EStructuralFeature)MdClassPackage.Literals.BASIC_TEMPLATE__TEMPLATE, exportContext.getProjectVersion());
            if (outputPath == null) {
                DcsPlugin.log((IStatus)DcsPlugin.createErrorStatus((String)("Unable to determine DCS output file. Template: " + String.valueOf(eObject)), null));
            } else {
                this.documentProcessingSettingsManager.lockDocumentSaveProcessing();
                try {
                    try {
                        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                        IDtProject dtProject = this.resourceLookup.getDtProject((EObject)dcs);
                        DcsV8Serializer serializer = new DcsV8Serializer(dtProject, exportContext.getProjectVersion(), this.resourceLookup);
                        serializer.serializeXML((EObject)dcs, (OutputStream)outputStream, LF_STRING, dtProject);
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                        Throwable throwable = null;
                        Object var16_19 = null;
                        try (BufferedInputStream bufferedInput = new BufferedInputStream(inputStream);){
                            Throwable throwable2 = null;
                            Object var19_24 = null;
                            try (BufferedOutputStream bufferedOutput = new BufferedOutputStream(artifactBuilder.newOutputStream(target));){
                                LineFeedConverter.convert((InputStream)bufferedInput, (OutputStream)bufferedOutput, (LineFeedConverter.ConvertOption[])options);
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable e) {
                        String message = MessageFormat.format("Cannot add interfaces at xml export to DCS: {0}", outputPath);
                        DcsPlugin.log((IStatus)DcsPlugin.createErrorStatus((String)message, (Throwable)e));
                        this.documentProcessingSettingsManager.unlockDocumentSaveProcessing();
                    }
                }
                finally {
                    this.documentProcessingSettingsManager.unlockDocumentSaveProcessing();
                }
            }
        }
    }

    @LifecycleParticipant(phase=LifecyclePhase.LINKING)
    public void link() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.xmlExporterExtensionManager.registerExtension((IXmlExporterExtension)this);
    }

    public boolean overridesTemplateCopying(EObject eObject, IExportContext exportContext) {
        BasicTemplate template;
        if (eObject instanceof BasicTemplate && (template = (BasicTemplate)eObject).getTemplateType() == TemplateType.DATA_COMPOSITION_SCHEMA) {
            ITranslatingProject translatingProject = this.translatingProjectManager.getProject(exportContext.getExportProject());
            return translatingProject.isTranslating();
        }
        return false;
    }
}

