/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.participant;

import com.e1c.langtool.builder.ITranslationBuilderParticipant;
import com.e1c.langtool.history.db.HistoryDataBaseException;
import com.e1c.langtool.history.db.IProjectTranslation;
import com.e1c.langtool.history.db.IProjectTranslationStorage;
import com.e1c.langtool.history.db.query.Criteries;
import com.e1c.langtool.history.db.query.ExpressionBuilder;
import com.e1c.langtool.history.db.query.IExpression;
import com.e1c.langtool.internal.history.HistoryPlugin;
import com.e1c.langtool.internal.history.participant.ITranslationCollectingService;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;

public final class HistoryBuilderParticipant
implements ITranslationBuilderParticipant {
    @Inject
    private ITranslationCollectingService collectingService;
    @Inject
    private IProjectTranslationStorage projectTranslationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(ITranslationBuilderParticipant.IBuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        ITranslationBuilderParticipant.IBuildContext iBuildContext = context;
        synchronized (iBuildContext) {
            Collection<IProjectTranslation> translations = this.collectingService.collect(context);
            try {
                switch (context.getActionType()) {
                    case ADDED: {
                        this.update(translations);
                        break;
                    }
                    case CHANGED: {
                        this.update(translations);
                        break;
                    }
                    case REMOVED: {
                        this.remove(translations);
                        break;
                    }
                    case CLEANED: {
                        this.clean(context.getSource().getProject().getName());
                    }
                }
            }
            catch (HistoryDataBaseException e) {
                HistoryPlugin.logError(e);
            }
        }
    }

    private void add(Collection<IProjectTranslation> translations) {
        translations.forEach(trans -> this.projectTranslationService.addTranslation(trans));
    }

    private void clean(String projectName) {
        this.projectTranslationService.deleteByProject(projectName);
    }

    private void remove(Collection<IProjectTranslation> translations) {
        HashSet resourceIds = new HashSet();
        translations.forEach(trans -> {
            String resId = trans.getResourceId();
            if (!resourceIds.contains(resId)) {
                resourceIds.add(resId);
                this.removeTranslationsByResourceId(resId);
            }
        });
    }

    private void update(Collection<IProjectTranslation> translations) {
        this.remove(translations);
        this.add(translations);
    }

    private void removeTranslationsByResourceId(String resourceId) {
        this.projectTranslationService.deleteTranslations(ExpressionBuilder.where((IExpression)Criteries.ownerEqual((String)resourceId)).build());
    }
}

