/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.provider;

import com.e1c.langtool.builder.IBuiltResourceQueue;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.history.db.IProjectTranslationStorage;
import com.e1c.langtool.history.provider.IHistoryTranslationProvider;
import com.e1c.langtool.history.provider.IScopedTranslationProvider;
import com.e1c.langtool.query.ContextTranslationQuery;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;

public final class ExternalTranslationProvider
implements IExternalTranslationProvider {
    private static final Set<String> TRUSTED_SCOPE_IDS = ImmutableSet.of((Object)"scope_0", (Object)"scope_2", (Object)"scope_1", (Object)"scope_3");
    @Inject
    private IScopedTranslationProvider provider;
    @Inject
    private IProjectTranslationStorage storage;
    @Inject
    private IBuiltResourceQueue builtResourceQueue;

    public String getTranslationItemImageName() {
        return "icons/obj16/history_trans.png";
    }

    public List<String> translate(String text, String sourceLocale, String targetLocale) {
        this.updateTranslationIndex(null);
        return this.translate((IContextTranslationQuery)new ContextTranslationQuery.Builder(text, targetLocale).sourceLanguage(sourceLocale).build());
    }

    public Map<String, List<String>> translate(List<String> texts, String sourceLocale, String targetLocale) {
        this.updateTranslationIndex(null);
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String text : texts) {
            result.put(text, this.translate(text, sourceLocale, targetLocale));
        }
        return result;
    }

    public List<String> translate(IContextTranslationQuery query) {
        this.updateTranslationIndex(query.getProjectName());
        return this.provider.translate(query).stream().filter(trans -> TRUSTED_SCOPE_IDS.contains(trans.getScopeId())).map(IHistoryTranslationProvider.ITranslationResult::value).collect(Collectors.toList());
    }

    public Set<String> getLanguageCodes() {
        this.startUpdateTranslationIndex();
        return this.storage.getLanguages().stream().collect(Collectors.toSet());
    }

    public Map<String, String> getLanguages(String targetLocale) {
        this.startUpdateTranslationIndex();
        return this.storage.getLanguages().stream().collect(Collectors.toMap(x -> x, x -> x));
    }

    @Deprecated
    public boolean isActive() {
        return true;
    }

    private void updateTranslationIndex(String projectName) {
        Optional<IProject> project;
        Collection projects = this.builtResourceQueue.getBuiltProjects();
        if (projectName != null && (project = projects.stream().filter(p -> p.getName().equals(projectName)).findFirst()).isPresent()) {
            this.builtResourceQueue.syncInvokeParticipants(project.get(), (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        projects.forEach(proj -> this.builtResourceQueue.syncInvokeParticipants(proj, (IProgressMonitor)new NullProgressMonitor()));
    }

    private void startUpdateTranslationIndex() {
        Collection projects = this.builtResourceQueue.getBuiltProjects();
        projects.forEach(proj -> {
            Job job = this.builtResourceQueue.asyncInvokeParticipants(proj, () -> {});
        });
    }
}

