/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.provider;

import com.e1c.langtool.history.db.Context;
import com.e1c.langtool.history.db.IProjectTranslationStorage;
import com.e1c.langtool.history.db.query.Criteries;
import com.e1c.langtool.history.db.query.ExpressionBuilder;
import com.e1c.langtool.history.db.query.ICriteria;
import com.e1c.langtool.history.db.query.IExpression;
import com.e1c.langtool.history.provider.IHistoryTranslationProvider;
import com.e1c.langtool.internal.history.provider.BaseTranslationProvider;
import com.e1c.langtool.internal.history.query.IProjectTranslatingQuery;
import com.e1c.langtool.internal.history.query.ProjectTranslatingQuery;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.google.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;

public class HistoryTranslationProvider
extends BaseTranslationProvider
implements IHistoryTranslationProvider {
    @Inject
    public HistoryTranslationProvider(IProjectTranslationStorage service) {
        super(service);
    }

    @Override
    public List<IHistoryTranslationProvider.ITranslationResult> translate(IContextTranslationQuery contextQuery) {
        ProjectTranslatingQuery query = ProjectTranslatingQuery.fromContextQuery(contextQuery);
        IExpression baseQuery = this.createBaseQuery(query);
        String value = query.getValue() == null ? "" : query.getValue();
        IExpression searchQuery = ExpressionBuilder.and((IExpression)Criteries.valueLike((String)value), (IExpression)baseQuery);
        return this.translate(baseQuery, searchQuery).stream().limit(this.getMaxResultsNumber()).collect(Collectors.toList());
    }

    private IExpression createBaseQuery(IProjectTranslatingQuery query) {
        ExpressionBuilder builder = null;
        if (query.getProjectPath() != null) {
            builder = this.whereOrAnd(builder, Criteries.projectEqual((String)query.getProjectPath()));
        }
        if (query.getStorageId() != null) {
            builder = this.whereOrAnd(builder, Criteries.storageIdEqual((String)query.getStorageId()));
        }
        if (query.getOwner() != null) {
            builder = this.whereOrAnd(builder, Criteries.ownerEqual((String)query.getOwner()));
        }
        if (query.getFeatureKey() != null) {
            builder = this.whereOrAnd(builder, Criteries.featureKeyEqual((String)query.getFeatureKey()));
        }
        if (query.getFeatureName() != null) {
            builder = this.whereOrAnd(builder, Criteries.featureNameEqual((String)query.getFeatureName()));
        }
        if (query.getContext() != null) {
            Context context = query.getContext() == IProjectTranslatingQuery.ContextType.INTERFACE ? Context.INTERFACE : Context.MODEL;
            builder = this.whereOrAnd(builder, Criteries.contextEqual((Context)context));
        }
        if (query.getLanguage() != null) {
            builder = this.whereOrAnd(builder, Criteries.langEqual((String)query.getLanguage()));
        }
        return builder == null ? null : builder.build();
    }

    private ExpressionBuilder whereOrAnd(ExpressionBuilder builder, ICriteria criteria) {
        if (builder != null) {
            builder.and((IExpression)criteria);
            return builder;
        }
        return ExpressionBuilder.where((IExpression)criteria);
    }
}

