/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.history.query;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.internal.history.query.IProjectTranslatingQuery;
import com.e1c.langtool.query.IContextTranslationQuery;

public final class ProjectTranslatingQuery
implements IProjectTranslatingQuery {
    private final IContextTranslationQuery query;

    public static ProjectTranslatingQuery fromContextQuery(IContextTranslationQuery query) {
        return new ProjectTranslatingQuery(query);
    }

    private ProjectTranslatingQuery(IContextTranslationQuery query) {
        this.query = query;
    }

    @Override
    public String getLanguage() {
        return this.query.getTargetLanguage();
    }

    @Override
    public String getStorageId() {
        return this.query.getStorageId() != null ? this.query.getStorageId().toString() : null;
    }

    @Override
    public String getOwner() {
        FeatureValue fv = this.query.getFeatureValue();
        if (fv == null) {
            return null;
        }
        return fv.getContextKey().getResourceId().toString();
    }

    @Override
    public String getFeatureKey() {
        FeatureValue fv = this.query.getFeatureValue();
        if (fv == null) {
            return null;
        }
        return fv.getContextKey().getFeatureKey() != null ? fv.getContextKey().getFeatureKey().toString() : null;
    }

    @Override
    public String getFeatureName() {
        FeatureValue fv = this.query.getFeatureValue();
        if (fv == null) {
            return null;
        }
        return fv.getContextKey().getFeatureSettings().getName();
    }

    @Override
    public String getValue() {
        return this.query.getText();
    }

    @Override
    public IProjectTranslatingQuery.ContextType getContext() {
        FeatureValue fv = this.query.getFeatureValue();
        if (fv == null) {
            return null;
        }
        return IProjectTranslatingQuery.ContextType.valueOf(fv.getContextKey().getFeatureSettings().isInterface());
    }

    @Override
    public String getProjectPath() {
        return this.query.getProjectName();
    }
}

