/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.collector;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.ui.collector.IDelegatingSelectionCollector;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.MultiPageEditorPart;

@Singleton
public class DelegatingSelectionCollectorRegistry {
    private static final String EXTENSION_POINT_ID = "selectionCollectors";
    private static final String ATT_CLASS = "class";
    private static final String ATT_PARTID = "partid";
    private static final String COMPATIBILITY_EDITOR_ID = "org.eclipse.e4.ui.compatibility.editor";
    private Map<String, IDelegatingSelectionCollector> delegates;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, IDelegatingSelectionCollector> getDelegates() {
        if (this.delegates != null) return this.delegates;
        Class<DelegatingSelectionCollectorRegistry> clazz = DelegatingSelectionCollectorRegistry.class;
        synchronized (DelegatingSelectionCollectorRegistry.class) {
            if (this.delegates != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.delegates;
            }
            this.delegates = this.load();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.delegates;
        }
    }

    public IDelegatingSelectionCollector getDelegateCollector(IWorkbenchPart part) {
        if (part == null || part.getSite() == null) {
            return null;
        }
        IDelegatingSelectionCollector delegate = null;
        if (part instanceof MultiPageEditorPart) {
            Display display = part.getSite().getShell().getDisplay();
            if (!display.isDisposed()) {
                String[] id = new String[1];
                display.syncExec(() -> {
                    Object page = ((MultiPageEditorPart)part).getSelectedPage();
                    if (page instanceof IFormPage) {
                        stringArray[0] = ((IFormPage)page).getId();
                    }
                });
                if (id[0] != null) {
                    delegate = this.getDelegates().get(id[0]);
                }
            }
        } else {
            delegate = this.getDelegates().get(part.getSite().getId());
        }
        if (delegate == null) {
            delegate = this.getDelegates().get(COMPATIBILITY_EDITOR_ID);
        }
        return delegate;
    }

    private Map<String, IDelegatingSelectionCollector> load() {
        IConfigurationElement[] configElements;
        HashMap<String, IDelegatingSelectionCollector> result = new HashMap<String, IDelegatingSelectionCollector>();
        IConfigurationElement[] elements = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.e1c.langtool.ui", EXTENSION_POINT_ID);
        int length = configElements.length;
        int index = 0;
        while (index < length) {
            IConfigurationElement configElement = elements[index];
            try {
                String partId = configElement.getAttribute(ATT_PARTID);
                String filterClassName = configElement.getAttribute(ATT_CLASS);
                if (!StringUtils.isNullOrEmpty((String)filterClassName)) {
                    IDelegatingSelectionCollector e = (IDelegatingSelectionCollector)configElement.createExecutableExtension(ATT_CLASS);
                    result.put(partId, e);
                }
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
            }
            ++index;
        }
        return Map.copyOf(result);
    }
}

