/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.collector;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.CollectingException;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.internal.ui.collector.DelegatingSelectionCollectorRegistry;
import com.e1c.langtool.internal.ui.collector.Messages;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.GlobalEditingContext;
import com.e1c.langtool.storage.IEditingContext;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.ui.ExecutionErrorDialog;
import com.e1c.langtool.ui.collector.CommonFeatureValueCollectingResult;
import com.e1c.langtool.ui.collector.FeatureValueCollectingResult;
import com.e1c.langtool.ui.collector.IDelegatingSelectionCollector;
import com.e1c.langtool.ui.collector.ISelectionCollectingService;
import com.e1c.langtool.ui.collector.SelectionCollectingEvent;
import com.e1c.langtool.ui.collector.SelectionCollectingRequester;
import com.e1c.langtool.ui.collector.SelectionCollectingStatus;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SelectionCollectingServiceImpl
implements ISelectionCollectingService {
    @Inject
    private IFeatureValueCollectingService collectingService;
    @Inject
    private ITranslationStorageManager translationStorageManager;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private DelegatingSelectionCollectorRegistry delegatingSelectionCollectorRegistry;
    private final Map<SelectionCollectingRequester, IWorkbenchWindow> requesters = new ConcurrentHashMap<SelectionCollectingRequester, IWorkbenchWindow>();
    private Map<IWorkbenchWindow, ISelectionListener> windowListeners = new ConcurrentHashMap<IWorkbenchWindow, ISelectionListener>();
    private final IWindowListener windowListener = new WindowListener();

    public void activate() {
    }

    public void deactivate() {
        PlatformUI.getWorkbench().removeWindowListener(this.windowListener);
        this.windowListeners.forEach((w, l) -> w.getSelectionService().removePostSelectionListener(l));
        this.requesters.clear();
    }

    @Override
    public void addRequester(SelectionCollectingRequester requester, IWorkbenchWindow window) {
        Assert.isNotNull((Object)requester);
        Assert.isNotNull((Object)window);
        IWorkbenchWindow oldWindow = this.requesters.get(requester);
        this.requesters.put(requester, window);
        ISelectionListener listener = this.windowListeners.computeIfAbsent(window, w -> new SelectionListener((IWorkbenchWindow)w));
        window.getSelectionService().addPostSelectionListener(listener);
        if (oldWindow != null && oldWindow != window && this.windowListeners.containsKey(oldWindow)) {
            listener = this.windowListeners.get(oldWindow);
            oldWindow.getSelectionService().removePostSelectionListener(listener);
        }
        PlatformUI.getWorkbench().addWindowListener(this.windowListener);
    }

    @Override
    public void removeRequester(SelectionCollectingRequester requestoer) {
        IWorkbenchWindow window = this.requesters.remove(requestoer);
        if (window != null && (this.requesters.isEmpty() || !this.requesters.containsValue(window))) {
            this.windowListeners.computeIfPresent(window, (w, l) -> {
                w.getSelectionService().removePostSelectionListener(l);
                return null;
            });
        }
    }

    @Override
    public void refresh(SelectionCollectingRequester requester, FeatureValueCollectingResult result) {
        requester.statusChanged(new SelectionCollectingEvent(requester, SelectionCollectingStatus.COLLECTING));
        IWorkbenchWindow window = this.requesters.get(requester);
        if (window != null) {
            IWorkbenchPart part = result.getSelectedPart();
            ISelection selection = result.getSelection();
            if (part != null && selection != null) {
                this.startCollect(requester, part, selection);
                return;
            }
        }
        requester.statusChanged(new SelectionCollectingEvent(requester, SelectionCollectingStatus.NOT_SELECTED));
    }

    @Override
    public void cancel(SelectionCollectingRequester requester) {
        Job[] jobs = Job.getJobManager().find((Object)requester);
        int i = 0;
        while (i < jobs.length) {
            Job job = jobs[i];
            if (job.getState() != 0) {
                job.cancel();
            }
            ++i;
        }
    }

    private void startCollect(SelectionCollectingRequester requester, IWorkbenchPart part, ISelection selection) {
        this.cancel(requester);
        UpdateJob job = new UpdateJob(requester, part, selection);
        job.schedule();
    }

    private final class SelectionListener
    implements ISelectionListener {
        private final IWorkbenchWindow window;

        public SelectionListener(IWorkbenchWindow window) {
            this.window = window;
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            for (Map.Entry<SelectionCollectingRequester, IWorkbenchWindow> entry : SelectionCollectingServiceImpl.this.requesters.entrySet()) {
                if (this.window != entry.getValue() || !entry.getKey().canProcessPart(part)) continue;
                SelectionCollectingServiceImpl.this.startCollect(entry.getKey(), part, selection);
            }
        }
    }

    private class UpdateJob
    extends Job {
        private final SelectionCollectingRequester requester;
        private final IWorkbenchPart part;
        private final ISelection selection;

        public UpdateJob(SelectionCollectingRequester requester, IWorkbenchPart part, ISelection selection) {
            super(Messages.SelectionCollectingServiceImpl_Processing_selection_for_translations);
            this.setSystem(false);
            this.setUser(true);
            this.requester = requester;
            this.part = part;
            this.selection = selection;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.SelectionCollectingServiceImpl_Processing_selection_for_translations, -1);
            this.requester.statusChanged(new SelectionCollectingEvent(this.part, SelectionCollectingStatus.COLLECTING));
            IStatus status = Status.CANCEL_STATUS;
            try {
                try {
                    status = this.internalRun(monitor);
                }
                catch (CollectingException e) {
                    Display display = Display.getDefault();
                    if (!display.isDisposed() && !monitor.isCanceled()) {
                        display.asyncExec(() -> {
                            int n = ExecutionErrorDialog.openError(display.getActiveShell(), e.getLocalizedMessage(), e);
                        });
                    }
                    if (monitor.isCanceled()) {
                        IStatus iStatus = status = Status.CANCEL_STATUS;
                        if (!status.isOK()) {
                            this.requester.statusChanged(new SelectionCollectingEvent(this.part, SelectionCollectingStatus.NOT_SELECTED));
                        }
                        return iStatus;
                    }
                    IStatus iStatus = status = UiPlugin.createErrorStatus(e.getLocalizedMessage(), e);
                    if (!status.isOK()) {
                        this.requester.statusChanged(new SelectionCollectingEvent(this.part, SelectionCollectingStatus.NOT_SELECTED));
                    }
                    return iStatus;
                }
            }
            finally {
                if (!status.isOK()) {
                    this.requester.statusChanged(new SelectionCollectingEvent(this.part, SelectionCollectingStatus.NOT_SELECTED));
                }
            }
            return status;
        }

        private IStatus internalRun(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                this.requester.statusChanged(new SelectionCollectingEvent(this.part, SelectionCollectingStatus.NOT_SELECTED));
                return Status.CANCEL_STATUS;
            }
            IDelegatingSelectionCollector delegate = SelectionCollectingServiceImpl.this.delegatingSelectionCollectorRegistry.getDelegateCollector(this.part);
            ICollectingParameters parameters = this.requester.getCollectingParameters();
            if (delegate != null && parameters != null) {
                FeatureValueCollectingResult result = delegate.collectSelection(this.part, this.selection, parameters, monitor);
                if (result != null && !monitor.isCanceled()) {
                    this.requester.statusChanged(new SelectionCollectingEvent(this.part, SelectionCollectingStatus.UPDATED, result));
                    return Status.OK_STATUS;
                }
                if (monitor.isCanceled()) {
                    this.requester.statusChanged(new SelectionCollectingEvent(this.part, SelectionCollectingStatus.NOT_SELECTED));
                    return Status.CANCEL_STATUS;
                }
            }
            if (this.selection instanceof IStructuredSelection && parameters != null) {
                IStructuredSelection ss = (IStructuredSelection)this.selection;
                Iterator iterator = ss.iterator();
                while (iterator.hasNext()) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Object item = iterator.next();
                    TranslationSource source = TranslationUtils.getTranslationSource(item);
                    if (source == null || monitor.isCanceled()) continue;
                    this.collectSource(source, monitor);
                    return Status.OK_STATUS;
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.requester.statusChanged(new SelectionCollectingEvent(this.part, SelectionCollectingStatus.NOT_SELECTED));
            return Status.OK_STATUS;
        }

        private void collectSource(TranslationSource source, IProgressMonitor monitor) {
            ConcurrentHashMap.KeySetView values = ConcurrentHashMap.newKeySet();
            SelectionCollectingServiceImpl.this.collectingService.forEachCollected(source, this.requester.getCollectingParameters(), monitor, (sourceObject, feature) -> values.add(feature));
            if (monitor.isCanceled()) {
                values.clear();
            }
            GlobalEditingContext context = new GlobalEditingContext(source.getProject(), SelectionCollectingServiceImpl.this.translationStorageManager);
            CommonFeatureValueCollectingResult result = new CommonFeatureValueCollectingResult(source, values, this.part, this.selection, (IEditingContext)context, s -> SelectionCollectingServiceImpl.this.translatingProjectManager.getProject(s.getProject()));
            this.requester.statusChanged(new SelectionCollectingEvent(this.part, SelectionCollectingStatus.UPDATED, result));
        }

        public boolean belongsTo(Object family) {
            return family instanceof SelectionCollectingRequester && this.requester == family;
        }
    }

    private final class WindowListener
    implements IWindowListener {
        private WindowListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            Iterator<Map.Entry<SelectionCollectingRequester, IWorkbenchWindow>> iterator = SelectionCollectingServiceImpl.this.requesters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<SelectionCollectingRequester, IWorkbenchWindow> entry = iterator.next();
                if (entry.getValue() != window) continue;
                iterator.remove();
            }
            SelectionCollectingServiceImpl.this.windowListeners.computeIfPresent(window, (w, l) -> {
                w.getSelectionService().removePostSelectionListener(l);
                return null;
            });
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }
}

