/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.commands;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.ignore.IgnoreTranslationCheckingService;
import com.e1c.langtool.ignore.TransIgnoreFile;
import com.e1c.langtool.ignore.TransIgnoreFileUtil;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.ui.tree.IFeatureValueItem;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class IgnoreFeatureValueTranslationHandler
extends AbstractHandler {
    @Inject
    private IgnoreTranslationCheckingService ignoreService;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        @Nullable IProject project = (IProject)HandlerUtil.getActivePart((ExecutionEvent)event).getAdapter(IProject.class);
        if (project == null) {
            return null;
        }
        Map<IPath, List<FeatureValue>> values = this.getFeatureValues(event).stream().filter(fv -> !this.ignoreService.ignoreTranslation(project, fv.getContextKey(), (IProgressMonitor)new NullProgressMonitor())).collect(Collectors.groupingBy(fv -> fv.getContextKey().getResourceId().removeLastSegments(1)));
        for (Map.Entry<IPath, List<FeatureValue>> entry : values.entrySet()) {
            this.addIgnoreFile(project, entry.getKey(), (Collection<FeatureValue>)entry.getValue());
        }
        return null;
    }

    private void addIgnoreFile(IProject project, final IPath path, final Collection<FeatureValue> values) {
        final IFile file = project.getFile(path.append(".transignore"));
        Job job = new Job("Saving ignore file"){

            protected IStatus run(IProgressMonitor monitor) {
                TransIgnoreFile ignoreFile = TransIgnoreFileUtil.createNew((IPath)path);
                if (file.exists()) {
                    try {
                        TransIgnoreFileUtil.load((TransIgnoreFile)ignoreFile, (IFile)file);
                    }
                    catch (IOException | CoreException e) {
                        String message = MessageFormat.format("Cannot read trans ignore file: {0}", file);
                        IStatus status = UiPlugin.createErrorStatus(message, e);
                        UiPlugin.log(status);
                        return status;
                    }
                }
                for (FeatureValue source : values) {
                    IPath resource = source.getContextKey().getResourceId();
                    if (ignoreFile.ignore(source.getContextKey().getResourceId(), source.getContextKey().getFeatureKey())) continue;
                    ignoreFile.addLine((TransIgnoreFile.Line)new TransIgnoreFile.Rule(resource.lastSegment(), source.getContextKey().getFeatureKey().toString()));
                }
                try {
                    TransIgnoreFileUtil.save((TransIgnoreFile)ignoreFile, (IFile)file, (IProgressMonitor)monitor);
                }
                catch (IOException | CoreException e) {
                    return UiPlugin.createErrorStatus(MessageFormat.format("Error while saving file: {0}", file.getFullPath()), e);
                }
                return Status.OK_STATUS;
            }
        };
        if (file.isAccessible()) {
            job.setRule((ISchedulingRule)file);
        }
        job.schedule();
    }

    private Collection<FeatureValue> getFeatureValues(ExecutionEvent event) {
        ArrayList items = Lists.newArrayList();
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object item : sel) {
                if (item instanceof FeatureValue) {
                    items.add((FeatureValue)item);
                    continue;
                }
                if (!(item instanceof IFeatureValueItem)) continue;
                items.add(((IFeatureValueItem)item).getFeatureValue());
            }
        }
        return items;
    }
}

