/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.common.tools;

import com.e1c.langtool.internal.ui.common.tools.IErrorComponent;
import com.e1c.langtool.internal.ui.common.tools.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ErrorComponent
implements IErrorComponent {
    private Composite top;
    private Label errorMsgLabel;
    private Button detailsButton;
    private ErrorDialog errorDialog;
    private final String preferencePageId;
    private final String pluginId;

    public static void setExclusion(Composite composite, boolean state) {
        GridData gridData = (GridData)composite.getLayoutData();
        gridData.exclude = state;
        composite.setLayoutData((Object)gridData);
        composite.setVisible(!state);
    }

    public ErrorComponent(String pluginId, String preferencePageId) {
        this.pluginId = pluginId;
        this.preferencePageId = preferencePageId;
    }

    @Override
    public void createComponent(Composite parent) {
        this.top = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        rowLayout.pack = true;
        rowLayout.justify = false;
        rowLayout.type = 256;
        this.top.setLayout((Layout)rowLayout);
        GridData gridData = new GridData(4, 4, true, false);
        this.top.setLayoutData((Object)gridData);
        Composite errorMessageCompoiste = new Composite(this.top, 0);
        RowLayout errorRowLayout = new RowLayout();
        errorRowLayout.wrap = false;
        errorRowLayout.pack = true;
        errorRowLayout.justify = false;
        errorRowLayout.type = 256;
        errorMessageCompoiste.setLayout((Layout)errorRowLayout);
        this.createErrorIcon(errorMessageCompoiste);
        this.createErrorMessage(errorMessageCompoiste);
        this.createDetailButton(this.top);
        this.createSettingsButton(this.top);
        this.hide();
    }

    private void createSettingsButton(final Composite top) {
        Button openProtpertiesButton = new Button(top, 0);
        openProtpertiesButton.setText(Messages.ErrorComponent_SettingButton);
        openProtpertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)top.getShell(), (String)ErrorComponent.this.preferencePageId, null, null);
                dialog.open();
            }
        });
    }

    @Override
    public void showError(String msg, String detail, Throwable exc) {
        Status status = new Status(4, this.pluginId, detail, exc);
        this.errorMsgLabel.setText(msg);
        this.errorDialog = new ErrorDialog(this.top.getShell(), Messages.ErrorComponent_ErrorDialogTitle, msg, (IStatus)status, 4);
        this.top.setVisible(true);
        this.top.layout(true);
    }

    @Override
    public void hide() {
        this.top.setVisible(false);
    }

    @Override
    public boolean isErrorVisible() {
        return this.top.getVisible();
    }

    protected void createErrorIcon(Composite top) {
        Label errorIcon = new Label(top, 0);
        errorIcon.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
    }

    protected void createErrorMessage(Composite top) {
        this.errorMsgLabel = new Label(top, 0);
    }

    protected void createDetailButton(Composite top) {
        this.detailsButton = new Button(top, 0);
        this.detailsButton.setText(Messages.ErrorComponent_DetailButton);
        this.detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorComponent.this.errorDialog.open();
            }
        });
    }
}

