/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.common.tools;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class ExtendStyledText
extends StyledText {
    public static final int DEFAULT_MAX_HEIGHT = 80;
    private int maxHeight = 80;
    private Color defaultMarginColor;
    private final List<Integer> defaultMargins = Arrays.asList(2, 4, 4, 2);
    private boolean isErrorShown = false;
    private final Color hintTextColor = this.getDisplay().getSystemColor(16);
    private String hintMessage = "";
    private ControlDecoration errorDecorator;
    private boolean emptyText = true;

    public ExtendStyledText(Composite parent, int style, int errorDectorationPos, String errorMsg) {
        super(parent, style);
        this.initErrorDecorator(errorDectorationPos, errorMsg);
        this.initMessageHandler();
        this.addPaintListener(this::handlePaintEvent);
    }

    public ExtendStyledText(Composite parent, int style, String errorMsg) {
        this(parent, style, 16512, errorMsg);
    }

    public void setMaxHeight(int height) {
        if (height >= 0) {
            this.maxHeight = height;
        }
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void showError() {
        if (!this.isErrorShown) {
            this.storeState();
            this.setMargins(1, 1, 1, 1);
            this.setMarginColor(this.getDisplay().getSystemColor(3));
            this.errorDecorator.show();
            this.errorDecorator.showHoverText(this.errorDecorator.getDescriptionText());
            this.isErrorShown = true;
        }
    }

    public void hideError() {
        if (this.isErrorShown) {
            this.loadState();
            this.isErrorShown = false;
        }
        this.errorDecorator.hide();
    }

    public void setHintMessage(String hintMessage) {
        this.hintMessage = hintMessage;
    }

    public String getHintMessage() {
        return this.hintMessage;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point preferredSize = super.computeSize(wHint, hHint, changed);
        return new Point(preferredSize.x, Math.min(preferredSize.y, this.maxHeight));
    }

    protected void checkSubclass() {
    }

    private void initErrorDecorator(int position, String errorMsg) {
        this.errorDecorator = new ControlDecoration((Control)this, position);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        Image errorIcon = fieldDecoration.getImage();
        this.errorDecorator.setImage(errorIcon);
        this.errorDecorator.setDescriptionText(errorMsg);
        this.errorDecorator.hide();
        this.addModifyListener(event -> this.hideError());
    }

    private void initMessageHandler() {
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (ExtendStyledText.this.getText().length() == 0) {
                    ExtendStyledText.this.emptyText = true;
                } else if (ExtendStyledText.this.emptyText) {
                    ExtendStyledText.this.emptyText = false;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ExtendStyledText.this.hideError();
                ExtendStyledText.this.redraw();
            }

            public void focusGained(FocusEvent e) {
                ExtendStyledText.this.redraw();
            }
        });
    }

    private void handlePaintEvent(PaintEvent event) {
        if (this.getText().isEmpty() && !this.isFocusControl()) {
            this.drawHint(event.gc);
        }
    }

    private void drawHint(GC gc) {
        int leftMargin = this.getLeftMargin();
        int topMargin = this.getTopMargin();
        gc.setForeground(this.hintTextColor);
        gc.drawText(this.hintMessage, leftMargin, topMargin, 3);
    }

    private synchronized void storeState() {
        this.defaultMarginColor = this.getMarginColor();
        this.defaultMargins.set(0, this.getLeftMargin());
        this.defaultMargins.set(1, this.getTopMargin());
        this.defaultMargins.set(2, this.getRightMargin());
        this.defaultMargins.set(3, this.getBottomMargin());
    }

    private synchronized void loadState() {
        this.setMarginColor(this.defaultMarginColor);
        this.setMargins(this.defaultMargins.get(0), this.defaultMargins.get(1), this.defaultMargins.get(2), this.defaultMargins.get(3));
    }
}

