/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.preferences;

import com.e1c.langtool.common.Pair;
import com.e1c.langtool.external.ExternalTranslationProviderAttrs;
import com.e1c.langtool.external.IExternalTranslationManager;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.external.ITranslationProviderRegistry;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.internal.ui.preferences.Messages;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.FrameworkUtil;

public class TranslationAssistPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.e1c.langtool.ui.translationAssist";
    public static final String TRANSLATION_ASSIST_PROVIDERS = "translationAssistProviders";
    private final SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TranslationAssistPreferencePage.this.handleButtonPressed((Button)e.widget);
        }
    };
    private final List<String> providerIds = new CopyOnWriteArrayList<String>();
    private final IObservableList<Pair<String, String>> providers = new WritableList();
    @Inject
    protected IExternalTranslationManager translationManager;
    private Button upButton;
    private Button downButton;
    private CheckboxTableViewer viewer;

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        button.setEnabled(false);
        button.addSelectionListener(this.buttonListener);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)data);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        return button;
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        topLevel.setLayout((Layout)layout);
        topLevel.setLayoutData((Object)new GridData(272));
        Composite tableAndButtons = new Composite(topLevel, 0);
        tableAndButtons.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)tableAndButtons, (int)2048);
        this.viewer.getTable().setLayoutData((Object)new GridData(1040));
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setLabelProvider(this.getTableLabelProvider((ObservableListContentProvider<Pair<String, String>>)contentProvider));
        this.loadProviders();
        this.viewer.setInput(this.providers);
        this.viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                if (element instanceof Pair) {
                    return TranslationAssistPreferencePage.this.providerIds.contains(((Pair)element).getKey());
                }
                return false;
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.viewer.addCheckStateListener(event -> {
            if (event.getElement() instanceof Pair) {
                Pair pair = (Pair)event.getElement();
                if (event.getChecked() && !this.providerIds.contains(pair.getKey())) {
                    this.providerIds.add((String)pair.getKey());
                } else if (!event.getChecked() && this.providerIds.contains(pair.getKey())) {
                    this.providerIds.remove(pair.getKey());
                }
            }
        });
        this.viewer.addPostSelectionChangedListener(event -> this.handleTableSelectionChanged());
        this.initializeValues();
        Composite buttonArea = new Composite(tableAndButtons, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setFont(font);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.upButton = this.createButton(buttonArea, Messages.TranslationAssistPreferencePage_Up);
        this.downButton = this.createButton(buttonArea, Messages.TranslationAssistPreferencePage_Down);
        return topLevel;
    }

    private IBaseLabelProvider getTableLabelProvider(ObservableListContentProvider<Pair<String, String>> contentProvider) {
        return new ObservableMapLabelProvider(Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])new IValueProperty[]{Properties.convertedValue(Pair::getValue)})){

            public Image getColumnImage(Object element, int columnIndex) {
                if (element instanceof Pair && ((Pair)element).getKey() instanceof String) {
                    String providerId = (String)((Pair)element).getKey();
                    IExternalTranslationProvider provider = TranslationAssistPreferencePage.this.translationManager.getTranslationProviderRegistry().getExternalTranslationProvider(providerId);
                    return this.getProviderTranslationItemImage(provider);
                }
                return null;
            }

            private Image getProviderTranslationItemImage(IExternalTranslationProvider provider) {
                String bundleName;
                Optional imageDescriptor;
                String name = provider.getTranslationItemImageName();
                if (name != null && (imageDescriptor = ResourceLocator.imageDescriptorFromBundle((String)(bundleName = FrameworkUtil.getBundle(provider.getClass()).getSymbolicName()), (String)name)).isPresent()) {
                    return imageDescriptor.map(d -> JFaceResources.getResources().createImageWithDefault(d)).orElse(null);
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof Pair && ((Pair)element).getValue() instanceof String) {
                    return (String)((Pair)element).getValue();
                }
                return super.getText(element);
            }
        };
    }

    private void handleButtonPressed(Button button) {
        if (button == this.upButton) {
            this.moveSelectionUp();
        } else if (button == this.downButton) {
            this.moveSelectionDown();
        }
        if (this.getControl().isDisposed()) {
            return;
        }
        this.handleTableSelectionChanged();
        this.viewer.getTable().setFocus();
    }

    private void handleTableSelectionChanged() {
        boolean enableUp = false;
        boolean enableDown = false;
        IStructuredSelection sel = this.viewer.getStructuredSelection();
        if (!sel.isEmpty()) {
            int index = this.providers.indexOf(sel.getFirstElement());
            if (index > 0) {
                enableUp = true;
            }
            if (index < this.providers.size() - 1) {
                enableDown = true;
            }
        }
        this.upButton.setEnabled(enableUp);
        this.downButton.setEnabled(enableDown);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(UiPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.TranslationAssistPreferencePage_Description);
    }

    private void initializeValues() {
        String listOfIds = this.getPreferenceStore().getString(TRANSLATION_ASSIST_PROVIDERS);
        if (listOfIds == null) {
            listOfIds = "";
        }
        String[] ids = listOfIds.split(",");
        this.providerIds.clear();
        int i = 0;
        while (i < ids.length) {
            String id = ids[i];
            this.providerIds.add(id);
            ++i;
        }
        this.sortProviders();
    }

    private void loadProviders() {
        this.providers.clear();
        ITranslationProviderRegistry registry = this.translationManager.getTranslationProviderRegistry();
        for (Map.Entry entry : registry.getAllExternalTranslationProviders().entrySet()) {
            String providerId = (String)entry.getKey();
            ExternalTranslationProviderAttrs attrs = registry.getExternalTranslationProviderAttrs(providerId);
            this.providers.add((Object)new Pair((Object)providerId, (Object)attrs.getName()));
        }
    }

    private void moveSelectionDown() {
        int index;
        IStructuredSelection sel = this.viewer.getStructuredSelection();
        if (!sel.isEmpty() && (index = this.providers.indexOf(sel.getFirstElement())) < this.providers.size() - 1) {
            this.providers.move(index, index + 1);
        }
    }

    private void moveSelectionUp() {
        int index;
        IStructuredSelection sel = this.viewer.getStructuredSelection();
        if (!sel.isEmpty() && (index = this.providers.indexOf(sel.getFirstElement())) > 0) {
            this.providers.move(index, index - 1);
        }
    }

    protected void performDefaults() {
        this.initializeValues();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        this.getControl().getDisplay().asyncExec(this::sortProviders);
        return super.performOk();
    }

    private void sortProviders() {
        ITranslationProviderRegistry registry = this.translationManager.getTranslationProviderRegistry();
        Comparator comparator = (p1, p2) -> {
            int index1 = this.providerIds.indexOf(p1.getKey());
            int index2 = this.providerIds.indexOf(p2.getKey());
            if (index1 > -1 && index2 > -1) {
                return index1 - index2;
            }
            if (index1 > -1) {
                return -(index1 + 1);
            }
            if (index2 > -1) {
                return index2 + 1;
            }
            ExternalTranslationProviderAttrs attrs1 = registry.getExternalTranslationProviderAttrs((String)p1.getKey());
            ExternalTranslationProviderAttrs attrs2 = registry.getExternalTranslationProviderAttrs((String)p2.getKey());
            if (attrs1.getOrder() > 0) {
                return attrs1.getOrder() - attrs2.getOrder();
            }
            return ((String)p1.getValue()).compareTo((String)p2.getValue());
        };
        Pair[] a = (Pair[])this.providers.toArray((Object[])new Pair[0]);
        Arrays.sort(a, comparator);
        int i = 0;
        while (i < a.length) {
            Pair object = a[i];
            this.providers.set(i, (Object)object);
            ++i;
        }
    }

    private void storeValues() {
        List ids = this.providers.stream().filter(e -> this.providerIds.contains(e.getKey())).map(Pair::getKey).collect(Collectors.toList());
        this.providerIds.clear();
        this.providerIds.addAll(ids);
        String listOfIds = String.join((CharSequence)",", this.providerIds);
        this.getPreferenceStore().setValue(TRANSLATION_ASSIST_PROVIDERS, listOfIds);
    }
}

