/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.preferences;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.ui.UiPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class TranslationPreferences {
    public static final String KEY_TREE_EXPANDED = "keyTreeExpanded";
    public static final String KEY_TREE_HIERARCHICAL = "keyTreeHierarchical";
    public static final String SHOW_LANGUAGES_IN_TREE = "showLanguagesInTree";
    public static final String SHOW_INTERFACE = "showInterface";
    public static final String SHOW_MODEL = "showModel";
    public static final String SHOW_COMPUTED = "showComputed";
    public static final String SHOW_CHILD_OBJECTS = "showChildObjects";
    public static final String SHOW_SUBRESOURCES = "showSubresources";
    public static final String SHOW_ALL_VALUES = "showAllValues";
    public static final String HIDE_FILLED_TRANSLATION = "hideFilledTranslation";
    public static final String SHOW_ONLY_LANGUAGES = "showOnlyLanguages";
    private static final IPreferenceStore PREFS = UiPlugin.getDefault().getPreferenceStore();
    private static final String[] EMPTY_LANGUAGES = new String[0];

    public static boolean getKeyTreeExpanded() {
        return PREFS.getBoolean(KEY_TREE_EXPANDED);
    }

    public static boolean getKeyTreeHierarchical() {
        return PREFS.getBoolean(KEY_TREE_HIERARCHICAL);
    }

    public static int getShowLanguagesInTree() {
        return PREFS.getInt(SHOW_LANGUAGES_IN_TREE);
    }

    public static boolean getShowInterface() {
        return PREFS.getBoolean(SHOW_INTERFACE);
    }

    public static boolean getShowModel() {
        return PREFS.getBoolean(SHOW_MODEL);
    }

    public static boolean getShowComputed() {
        return PREFS.getBoolean(SHOW_COMPUTED);
    }

    public static boolean getShowChildObjects() {
        return PREFS.getBoolean(SHOW_CHILD_OBJECTS);
    }

    public static boolean getShowSubresources() {
        return PREFS.getBoolean(SHOW_SUBRESOURCES);
    }

    public static boolean getShowAllValues() {
        return PREFS.getBoolean(SHOW_ALL_VALUES);
    }

    public static boolean getHideFilledTranslation() {
        return PREFS.getBoolean(HIDE_FILLED_TRANSLATION);
    }

    public static String[] getShowOnlyLanguages() {
        String languages = PREFS.getString(SHOW_ONLY_LANGUAGES);
        if (StringUtils.isNullOrEmpty((String)languages)) {
            return EMPTY_LANGUAGES;
        }
        return languages.split("\\,");
    }
}

