/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.view;

import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.internal.ui.view.FeatureValueCellEditorValidator;
import com.e1c.langtool.internal.ui.view.IQuerySelectionService;
import com.e1c.langtool.internal.ui.view.MultiStorageFeatureValueTextCellEditor;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.query.IApplicable;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.e1c.langtool.query.ISingleTranslationQuery;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.settings.ValidatorRegistry;
import com.e1c.langtool.storage.IEditingContext;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.ui.tree.IFeatureValueItem;
import com.google.inject.Inject;
import java.util.function.Supplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class LanguageColumnEditingSupport
extends EditingSupport {
    @Inject
    private ValidatorRegistry registry;
    @Inject
    private ITranslationStorageManager translationStorageManager;
    private final IQuerySelectionService selectionService;
    private final int currnetColumn;
    private final TranslateLanguage sourceLanguage;
    private final TranslateLanguage targetLanguage;
    private final MultiStorageFeatureValueTextCellEditor cellEditor;
    private final MultiStorageFeatureValueTextCellEditor cellEditorMulti;
    private final IEditingContext context;
    private boolean selfActivation = false;
    private ApplicableTranslationQuery query;
    private FeatureValue currentFeatureValue;
    private final Supplier<StorageID> storageId;
    private final IProject project;

    public LanguageColumnEditingSupport(ColumnViewer viewer, int column, TranslateLanguage sourceLanguage, TranslateLanguage targetLanguage, IEditingContext context, IQuerySelectionService selectionService, IProject project, Supplier<StorageID> currentStorageId) {
        super(viewer);
        this.cellEditor = new MultiStorageFeatureValueTextCellEditor((Composite)viewer.getControl(), context, targetLanguage, currentStorageId);
        this.cellEditorMulti = new MultiStorageFeatureValueTextCellEditor((Composite)viewer.getControl(), 66, context, targetLanguage, currentStorageId);
        this.currnetColumn = column;
        this.sourceLanguage = sourceLanguage;
        this.targetLanguage = targetLanguage;
        this.context = context;
        this.selectionService = selectionService;
        this.storageId = currentStorageId;
        this.project = project;
    }

    protected CellEditor getCellEditor(Object element) {
        MultiStorageFeatureValueTextCellEditor editor = this.cellEditor;
        if (element instanceof IFeatureValueItem) {
            this.currentFeatureValue = ((IFeatureValueItem)element).getFeatureValue();
            if (this.currentFeatureValue.getContextKey().getFeatureSettings().isMultiLine()) {
                editor = this.cellEditorMulti;
            }
            FeatureValueValidator.ValidationContext validationContext = new FeatureValueValidator.ValidationContext(){

                public IProject getProject() {
                    return LanguageColumnEditingSupport.this.project;
                }

                public TranslationKey getTranslationKey() {
                    return LanguageColumnEditingSupport.this.currentFeatureValue.getContextKey();
                }

                public TranslateLanguage getLanguage() {
                    return LanguageColumnEditingSupport.this.targetLanguage;
                }

                public ITranslationStorageProvider.Storage getStorage() {
                    return LanguageColumnEditingSupport.this.translationStorageManager.getStorage(LanguageColumnEditingSupport.this.project, LanguageColumnEditingSupport.this.storageId.get());
                }
            };
            this.init();
            editor.setValidator(new FeatureValueCellEditorValidator(this.registry, validationContext));
        } else {
            this.currentFeatureValue = null;
            this.cellEditor.setValidator(null);
            this.cellEditorMulti.setValidator(null);
        }
        return editor;
    }

    protected boolean canEdit(Object element) {
        if (element instanceof IFeatureValueItem) {
            FeatureValue value = ((IFeatureValueItem)element).getFeatureValue();
            return TranslationUtils.isValidFeatureForLanguage((FeatureSettings)value.getContextKey().getFeatureSettings(), (TranslateLanguage)this.targetLanguage);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue(Object element) {
        String textValue = null;
        if (element instanceof IFeatureValueItem) {
            FeatureValue value = ((IFeatureValueItem)element).getFeatureValue();
            textValue = this.context.getTranslation(this.storageId.get(), (TranslationKey)value, this.targetLanguage);
            LanguageColumnEditingSupport languageColumnEditingSupport = this;
            synchronized (languageColumnEditingSupport) {
                if (!this.selfActivation && this.selectionService != null) {
                    this.selectionService.fireQuery(this.getQuery(element, value));
                }
                this.cellEditor.setFeatueValue(value);
                this.cellEditorMulti.setFeatueValue(value);
            }
        }
        if (textValue == null) {
            textValue = "";
        }
        return textValue;
    }

    protected void setValue(Object element, Object newValue) {
        if (element instanceof IFeatureValueItem) {
            FeatureValue value = ((IFeatureValueItem)element).getFeatureValue();
            this.context.setTranslation(this.storageId.get(), (TranslationKey)value, this.targetLanguage, (String)newValue);
        }
        this.getViewer().refresh(element);
    }

    private ISingleTranslationQuery getQuery(Object element, FeatureValue value) {
        if (this.query == null || !this.query.getTranslationKey().equals(value.getContextKey())) {
            this.query = new ApplicableTranslationQuery(element, value);
        }
        return this.query;
    }

    private void init() {
        if (this.registry == null) {
            UiPlugin.getDefault().getInjector().injectMembers((Object)this);
        }
    }

    private class ApplicableTranslationQuery
    implements IContextTranslationQuery,
    IApplicable,
    FeatureValueValidator.ValidationContext {
        private final Object element;
        private final FeatureValue fv;

        public ApplicableTranslationQuery(Object element, FeatureValue featureValue) {
            this.element = element;
            this.fv = featureValue;
        }

        public FeatureValue getFeatureValue() {
            return this.fv;
        }

        public TranslationKey getTranslationKey() {
            return this.fv.getContextKey();
        }

        public String getText() {
            return this.fv.getContextKey().getValue();
        }

        public String getSourceLanguage() {
            return LanguageColumnEditingSupport.this.sourceLanguage.getLanguageCode();
        }

        public String getTargetLanguage() {
            return LanguageColumnEditingSupport.this.targetLanguage.getLanguageCode();
        }

        public boolean isProcessingNeeded() {
            return this.fv.getContextKey().getFeatureSettings().isCamelCase();
        }

        public void apply(String translation) {
            Display display;
            MultiStorageFeatureValueTextCellEditor editor = this.fv.getContextKey().getFeatureSettings().isMultiLine() ? LanguageColumnEditingSupport.this.cellEditorMulti : LanguageColumnEditingSupport.this.cellEditor;
            FeatureValueValidator validator = LanguageColumnEditingSupport.this.registry.getValidator(this.fv.getContextKey().getFeatureSettings());
            String newValue = validator.preprocessValue(translation, (FeatureValueValidator.ValidationContext)this);
            if (editor != null && !editor.getControl().isDisposed() && StringUtils.isNotEmpty((String)newValue) && !newValue.equals(editor.getValue()) && this.fv.equals(LanguageColumnEditingSupport.this.currentFeatureValue) && !(display = editor.getControl().getDisplay()).isDisposed()) {
                display.syncExec(() -> {
                    LanguageColumnEditingSupport languageColumnEditingSupport = LanguageColumnEditingSupport.this;
                    synchronized (languageColumnEditingSupport) {
                        LanguageColumnEditingSupport.this.selfActivation = true;
                    }
                    int[] order = ((TreeViewer)LanguageColumnEditingSupport.this.getViewer()).getTree().getColumnOrder();
                    int column = -1;
                    int i = 0;
                    while (i < order.length) {
                        if (order[i] == LanguageColumnEditingSupport.this.currnetColumn) {
                            column = LanguageColumnEditingSupport.this.currnetColumn;
                            break;
                        }
                        ++i;
                    }
                    if (column > -1) {
                        LanguageColumnEditingSupport.this.getViewer().getControl().setFocus();
                        LanguageColumnEditingSupport.this.getViewer().editElement(this.element, column);
                        editor.setValue(newValue);
                        editor.setFocus();
                    }
                    LanguageColumnEditingSupport languageColumnEditingSupport2 = LanguageColumnEditingSupport.this;
                    synchronized (languageColumnEditingSupport2) {
                        LanguageColumnEditingSupport.this.selfActivation = false;
                    }
                });
            }
        }

        public StorageID getStorageId() {
            return LanguageColumnEditingSupport.this.storageId.get();
        }

        public String getProjectName() {
            return LanguageColumnEditingSupport.this.project == null ? null : LanguageColumnEditingSupport.this.project.getName();
        }

        public IProject getProject() {
            return LanguageColumnEditingSupport.this.project;
        }

        public TranslateLanguage getLanguage() {
            return LanguageColumnEditingSupport.this.targetLanguage;
        }

        public ITranslationStorageProvider.Storage getStorage() {
            return LanguageColumnEditingSupport.this.translationStorageManager.getStorage(LanguageColumnEditingSupport.this.project, LanguageColumnEditingSupport.this.storageId.get());
        }
    }
}

