/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.view;

import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.internal.ui.view.IQuerySelectionService;
import com.e1c.langtool.query.ISingleTranslationQuery;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

public class QuerySelectionProvider
implements IPostSelectionProvider,
IQuerySelectionService {
    private final TreeViewer viewer;
    private ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();
    private ListenerList<ISelectionChangedListener> postSelectionChangedListeners = new ListenerList();
    private ISingleTranslationQuery query;
    private boolean enableViewerSelection;

    public QuerySelectionProvider(TreeViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void fireQuery(ISingleTranslationQuery query) {
        this.query = query;
        this.handleSet();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
        if (this.enableViewerSelection) {
            this.viewer.addSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        if (this.query != null) {
            return new StructuredSelection((Object)this.query);
        }
        return this.viewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
        this.viewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.viewer.setSelection(selection);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionChangedListeners.add((Object)listener);
        if (this.enableViewerSelection) {
            this.viewer.addPostSelectionChangedListener(listener);
        }
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionChangedListeners.remove((Object)listener);
        this.viewer.removePostSelectionChangedListener(listener);
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        for (ISelectionChangedListener l : this.selectionChangedListeners) {
            try {
                SafeRunnable.run(() -> l.selectionChanged(event));
            }
            catch (Throwable e) {
                UiPlugin.logError(e);
            }
        }
    }

    protected void firePostSelectionChanged(SelectionChangedEvent event) {
        for (ISelectionChangedListener l : this.postSelectionChangedListeners) {
            try {
                SafeRunnable.run(() -> l.selectionChanged(event));
            }
            catch (Throwable e) {
                UiPlugin.logError(e);
            }
        }
    }

    private void handleSet() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        this.fireSelectionChanged(event);
        Display display = this.viewer.getControl().getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)QuerySelectionProvider.this, QuerySelectionProvider.this.getSelection());
                    QuerySelectionProvider.this.firePostSelectionChanged(event);
                }
            });
        }
    }

    public void setEnableViewerSelection(boolean enableViewerSelection) {
        this.enableViewerSelection = enableViewerSelection;
        for (ISelectionChangedListener l : this.selectionChangedListeners) {
            if (enableViewerSelection) {
                this.viewer.addSelectionChangedListener(l);
                continue;
            }
            this.viewer.removeSelectionChangedListener(l);
        }
        for (ISelectionChangedListener l : this.postSelectionChangedListeners) {
            if (enableViewerSelection) {
                this.viewer.addPostSelectionChangedListener(l);
                continue;
            }
            this.viewer.removePostSelectionChangedListener(l);
        }
    }
}

