/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.ui.view;

import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.query.IApplicable;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.settings.ValidatorRegistry;
import com.e1c.langtool.storage.IEditingContext;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.ui.tree.FeatureValueItem;
import com.e1c.langtool.ui.tree.ITreeItem;
import org.eclipse.core.resources.IProject;

public class SingleLanguageFeatureValueItem
extends FeatureValueItem
implements IContextTranslationQuery,
IApplicable {
    protected final TranslateLanguage targetLanguage;
    protected final TranslateLanguage sourceLanguage;
    protected final IEditingContext context;
    private final StorageID storageId;
    private final IProject project;
    private final ITranslationStorageManager storageManager;
    private final ValidatorRegistry registry;

    public SingleLanguageFeatureValueItem(ITreeItem parent, FeatureValue value, int skipKeySegments, TranslateLanguage sourceLanguage, TranslateLanguage targetLanguage, IEditingContext context, IProject project, StorageID storageId, ITranslationStorageManager storageManager, ValidatorRegistry registry) {
        super(parent, value, skipKeySegments);
        this.sourceLanguage = sourceLanguage;
        this.targetLanguage = targetLanguage;
        this.context = context;
        this.storageId = storageId;
        this.project = project;
        this.storageManager = storageManager;
        this.registry = registry;
    }

    public String getSourceLanguage() {
        return this.sourceLanguage.getLanguageCode();
    }

    public String getTargetLanguage() {
        return this.targetLanguage.getLanguageCode();
    }

    public boolean isProcessingNeeded() {
        return this.value.getContextKey().getFeatureSettings().isCamelCase();
    }

    public String getText() {
        return this.value.getContextKey().getValue();
    }

    public void apply(String text) {
        String newValue;
        FeatureValueValidator.ValidationContext validationContext = new FeatureValueValidator.ValidationContext(){

            public IProject getProject() {
                return SingleLanguageFeatureValueItem.this.project;
            }

            public ITranslationStorageProvider.Storage getStorage() {
                return SingleLanguageFeatureValueItem.this.storageManager.getStorage(SingleLanguageFeatureValueItem.this.project, SingleLanguageFeatureValueItem.this.storageId);
            }

            public TranslateLanguage getLanguage() {
                return SingleLanguageFeatureValueItem.this.targetLanguage;
            }

            public TranslationKey getTranslationKey() {
                return SingleLanguageFeatureValueItem.this.value.getContextKey();
            }
        };
        FeatureValueValidator validator = this.registry.getValidator(this.value.getContextKey().getFeatureSettings());
        if (validator.isValid(newValue = validator.preprocessValue(text, validationContext), validationContext).isOK()) {
            this.context.setTranslation(this.storageId, (TranslationKey)this.value, this.targetLanguage, newValue);
        }
    }

    public StorageID getStorageId() {
        return this.storageId;
    }

    public String getProjectName() {
        return this.project == null ? null : this.project.getName();
    }
}

