/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui;

import com.e1c.langtool.ui.Messages;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ExecutionErrorDialog
extends MessageDialog {
    private Control details;
    private Button detailsButton;
    private Throwable exception;
    private boolean initiallyOpened;

    public static int openError(Shell parentShell, IStatus status) {
        ExecutionErrorDialog dialog = new ExecutionErrorDialog(parentShell, status);
        return dialog.open();
    }

    public static int openError(Shell parentShell, String message, Throwable exception) {
        ExecutionErrorDialog dialog = new ExecutionErrorDialog(parentShell, message, exception);
        return dialog.open();
    }

    public ExecutionErrorDialog(Shell parentShell, IStatus status) {
        this(parentShell, status.getMessage(), status.getException());
    }

    public ExecutionErrorDialog(Shell parentShell, String message, Throwable exception) {
        super(parentShell, Messages.ExecutionErrorDialog_Error, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.exception = exception;
        this.initiallyOpened = this.isInitiallyOpened(exception);
    }

    public void setInitiallyOpened(boolean initiallyOpened) {
        this.initiallyOpened = initiallyOpened;
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void initializeBounds() {
        super.initializeBounds();
        if (this.initiallyOpened) {
            this.toggleDetailsArea();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.exception != null) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    protected Control createDetailsArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)composite);
        StyledText stackTrace = new StyledText(composite, 2818);
        stackTrace.setEditable(false);
        stackTrace.setText(this.getMessage(this.exception));
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 200).applyTo((Control)stackTrace);
        return composite;
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        if (this.details != null) {
            this.details.dispose();
            this.details = null;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.details = this.createDetailsArea((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, newSize.y));
    }

    protected String getMessage(Throwable exception) {
        if (exception == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    protected String toString(IStatus status, String prefix) {
        StringBuilder result = new StringBuilder();
        result.append(prefix);
        result.append(status.getMessage());
        if (status.isMultiStatus()) {
            result.append(System.lineSeparator());
            result.append(Arrays.stream(status.getChildren()).map(child -> this.toString((IStatus)child, prefix + "\t")).collect(Collectors.joining(System.lineSeparator())));
            return result.toString();
        }
        return result.toString();
    }

    protected boolean isInitiallyOpened(Throwable throwable) {
        return false;
    }
}

