/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui;

import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.IStorageValueChangedListener;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.StorageValueChangeEvent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StorageTranslationCache {
    private final ITranslatingProject project;
    private IStorageSettingsManager storageSettingsManager;
    private ITranslationStorageManager storageManager;
    private List<TranslateLanguage> languages;
    private final Map<CacheKey, String> translations = new ConcurrentHashMap<CacheKey, String>();
    private StorageChangeListener listener = new StorageChangeListener();
    private boolean isDisposed = false;

    public StorageTranslationCache(ITranslatingProject project) {
        this.project = project;
    }

    public void clear() {
        this.checkAccess();
        this.translations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<StorageTranslationCache> clazz = StorageTranslationCache.class;
        synchronized (StorageTranslationCache.class) {
            this.isDisposed = true;
            this.translations.clear();
            List storages = this.getStorageSettingsManager().getReadStorageIds(this.project.getProject());
            for (StorageID storageSetting : storages) {
                ITranslationStorageProvider.Storage storage = this.getStorageManager().getStorage(this.project.getProject(), storageSetting);
                storage.removeValueChangedListener((IStorageValueChangedListener)this.listener);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<StorageTranslationCache> clazz = StorageTranslationCache.class;
        synchronized (StorageTranslationCache.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.isDisposed;
        }
    }

    public String getTranslation(ITranslationStorageProvider.Storage storage, FeatureValue value, TranslateLanguage language) {
        this.checkAccess();
        CacheKey key = new CacheKey(storage.getId(), (TranslationKey)value.getContextKey(), language);
        if (this.translations.containsKey(key)) {
            return this.translations.get(key);
        }
        String translation = storage.getTranslation(value, language);
        storage.addValueChangedListener((IStorageValueChangedListener)this.listener);
        this.translations.put(key, translation);
        return translation;
    }

    public String getTranslation(StorageID id, FeatureValue value, TranslateLanguage language) {
        this.checkAccess();
        CacheKey key = new CacheKey(id, (TranslationKey)value.getContextKey(), language);
        if (this.translations.containsKey(key)) {
            return this.translations.get(key);
        }
        ITranslationStorageProvider.Storage storage = this.getStorageManager().getStorage(this.project.getProject(), id);
        String translation = storage.getTranslation(value, language);
        this.translations.put(key, translation);
        return translation;
    }

    public boolean hasTranslation(FeatureValue value) {
        this.checkAccess();
        List checkLanguages = this.getLanguages();
        boolean isLocalizable = value.getContextKey().getFeatureSettings().isInterface();
        if (checkLanguages == null || checkLanguages.isEmpty()) {
            checkLanguages = isLocalizable ? this.project.getInterfaceLanguages() : this.project.getModelLanguages();
        }
        if (checkLanguages.isEmpty()) {
            return false;
        }
        List storages = this.getStorageSettingsManager().getReadStorageIds(this.project.getProject());
        for (TranslateLanguage language : checkLanguages) {
            if (!isLocalizable && TranslationOption.INTERFACE_ONLY.equals((Object)language.getOption())) continue;
            boolean hasTranslation = false;
            for (StorageID storageSetting : storages) {
                ITranslationStorageProvider.Storage storage = this.getStorageManager().getStorage(this.project.getProject(), storageSetting);
                if (!this.hasTranslation(storage, value, language)) continue;
                hasTranslation = true;
                break;
            }
            if (hasTranslation) continue;
            return false;
        }
        return true;
    }

    public boolean hasTranslation(FeatureValue value, TranslateLanguage language) {
        this.checkAccess();
        List storages = this.getStorageSettingsManager().getReadStorageIds(this.project.getProject());
        for (StorageID storageSetting : storages) {
            ITranslationStorageProvider.Storage storage = this.getStorageManager().getStorage(this.project.getProject(), storageSetting);
            if (!this.hasTranslation(storage, value, language)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTranslation(ITranslationStorageProvider.Storage storage, FeatureValue value, TranslateLanguage language) {
        this.checkAccess();
        String translation = this.getTranslation(storage, value, language);
        return StringUtils.isNotEmpty((String)translation);
    }

    public IStorageSettingsManager getStorageSettingsManager() {
        this.checkAccess();
        return this.storageSettingsManager;
    }

    public void setStorageSettingsManager(IStorageSettingsManager storageSettingsManager) {
        this.checkAccess();
        this.storageSettingsManager = storageSettingsManager;
    }

    public ITranslationStorageManager getStorageManager() {
        this.checkAccess();
        return this.storageManager;
    }

    public void setStorageManager(ITranslationStorageManager storageManager) {
        this.checkAccess();
        this.storageManager = storageManager;
    }

    public List<TranslateLanguage> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<TranslateLanguage> languages) {
        this.languages = languages;
    }

    private void checkAccess() {
        if (this.isDisposed()) {
            throw new IllegalStateException("The object had disposed yet.");
        }
    }

    public final class CacheKey {
        private final StorageID storageId;
        private final TranslationKey featureValue;
        private final TranslateLanguage language;

        CacheKey(StorageID storageId, TranslationKey featureValue, TranslateLanguage language) {
            this.storageId = storageId;
            this.featureValue = featureValue;
            this.language = language;
        }

        public StorageID getStorageId() {
            return this.storageId;
        }

        public TranslationKey getFeatureValue() {
            return this.featureValue;
        }

        public TranslateLanguage getLanguage() {
            return this.language;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.featureValue == null ? 0 : this.featureValue.hashCode());
            result = 31 * result + (this.storageId == null ? 0 : this.storageId.hashCode());
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.featureValue == null ? other.featureValue != null : !this.featureValue.equals(other.featureValue)) {
                return false;
            }
            if (this.storageId == null ? other.storageId != null : !this.storageId.equals((Object)other.storageId)) {
                return false;
            }
            return !(this.language == null ? other.language != null : !this.language.equals(other.language));
        }

        public String toString() {
            return "CacheKey [id=" + String.valueOf(this.storageId) + ", fv=" + String.valueOf(this.featureValue) + ", language=" + String.valueOf(this.language) + "]";
        }
    }

    private class StorageChangeListener
    implements IStorageValueChangedListener {
        private StorageChangeListener() {
        }

        public void changed(StorageValueChangeEvent event) {
            StorageID id;
            CacheKey key;
            TranslateLanguage language = event.getLanguage();
            if (language != null && event.getSource() instanceof ITranslationStorageProvider.Storage && StorageTranslationCache.this.translations.containsKey(key = new CacheKey(id = event.getStorageID(), event.getTranslationKey(), language))) {
                if (event.getNewTranslation() != null) {
                    StorageTranslationCache.this.translations.put(key, event.getNewTranslation());
                } else {
                    StorageTranslationCache.this.translations.remove(key);
                }
            }
        }
    }
}

