/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.collector;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.GlobalEditingContext;
import com.e1c.langtool.storage.IEditingContext;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.ui.collector.CommonFeatureValueCollectingResult;
import com.e1c.langtool.ui.collector.FeatureValueCollectingResult;
import com.e1c.langtool.ui.collector.IDelegatingSelectionCollector;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public abstract class BaseDelegatedSelectionCollector
implements IDelegatingSelectionCollector {
    private final ITranslatingProjectManager translatingProjectManager;
    private final IFeatureValueCollectingService collectingService;
    private final ITranslationStorageManager translationStorageManager;

    protected BaseDelegatedSelectionCollector(ITranslatingProjectManager translatingProjectManager, IFeatureValueCollectingService collectingService, ITranslationStorageManager translationStorageManager) {
        this.translatingProjectManager = translatingProjectManager;
        this.collectingService = collectingService;
        this.translationStorageManager = translationStorageManager;
    }

    protected FeatureValueCollectingResult collectSource(TranslationSource source, ICollectingParameters parameters, IWorkbenchPart part, ISelection selection, IProgressMonitor monitor) {
        ConcurrentHashMap.KeySetView values = ConcurrentHashMap.newKeySet();
        this.collectingService.forEachCollected(source, parameters, monitor, (sourceObject, feature) -> values.add(feature));
        if (monitor.isCanceled()) {
            values.clear();
        }
        IEditingContext context = this.createEditingContext(source, part);
        return new CommonFeatureValueCollectingResult(source, values, part, selection, context, s -> this.translatingProjectManager.getProject(s.getProject()));
    }

    protected IEditingContext createEditingContext(TranslationSource source, IWorkbenchPart part) {
        return new GlobalEditingContext(source.getProject(), this.translationStorageManager);
    }
}

