/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.collector;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.generatestring.TranslationStringsGenerator;
import com.e1c.langtool.ui.collector.Messages;
import com.e1c.langtool.ui.generatestring.FilterSettingSection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;

public class RegExCollectingFilterSettingSection
implements FilterSettingSection {
    private @NonNull TranslationStringsGenerator generator;
    private @NonNull WizardPage page;
    private Text resourceIdRegExtText;
    private Text featureKeyRegExtText;
    private Text featureValueRegExtText;
    private final Map<String, String> errors = new HashMap<String, String>();

    @Override
    public @NonNull String getTitle() {
        return Messages.RegExCollectingFilterSettingSection_title;
    }

    @Override
    public String getDescription() {
        return Messages.RegExCollectingFilterSettingSection_description;
    }

    @Override
    public void createContent(@NonNull TranslationStringsGenerator generator, @NonNull WizardPage page, @NonNull Composite parent, Section section) {
        this.generator = generator;
        this.page = page;
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout(2, false));
        topLevel.setLayoutData((Object)new GridData(4, 4, true, true));
        topLevel.setFont(font);
        Label resourceIdRegExLabel = new Label(topLevel, 0);
        resourceIdRegExLabel.setText(Messages.RegExCollectingFilterSettingSection_Resource_ID);
        this.resourceIdRegExtText = new Text(topLevel, 2052);
        this.resourceIdRegExtText.setMessage(Messages.RegExCollectingFilterSettingSection_input_regular_expression_or_leave_blank);
        this.resourceIdRegExtText.setLayoutData((Object)new GridData(768));
        this.resourceIdRegExtText.addModifyListener(e -> this.validateRegEx("resource-id-regex", this.resourceIdRegExtText, Messages.RegExCollectingFilterSettingSection_Resource_ID_RegEx_is_not_valid___E));
        Label featureKeyRegExLabel = new Label(topLevel, 0);
        featureKeyRegExLabel.setText(Messages.RegExCollectingFilterSettingSection_Feature_key);
        this.featureKeyRegExtText = new Text(topLevel, 2052);
        this.featureKeyRegExtText.setMessage(Messages.RegExCollectingFilterSettingSection_input_regular_expression_or_leave_blank);
        this.featureKeyRegExtText.setLayoutData((Object)new GridData(768));
        this.featureKeyRegExtText.addModifyListener(e -> this.validateRegEx("feature-key-regex", this.featureKeyRegExtText, Messages.RegExCollectingFilterSettingSection_Feature_key_RegEx_is_not_valid___E));
        Label featureValueRegExLabel = new Label(topLevel, 0);
        featureValueRegExLabel.setText(Messages.RegExCollectingFilterSettingSection_Feature_value);
        this.featureValueRegExtText = new Text(topLevel, 2052);
        this.featureValueRegExtText.setMessage(Messages.RegExCollectingFilterSettingSection_input_regular_expression_or_leave_blank);
        this.featureValueRegExtText.setLayoutData((Object)new GridData(768));
        this.featureValueRegExtText.addModifyListener(e -> this.validateRegEx("feature-value-regex", this.featureValueRegExtText, Messages.RegExCollectingFilterSettingSection_Feature_Value_RegEx_is_not_valid___E));
    }

    private void validateRegEx(String id, Text field, String errorPattern) {
        String text = field.getText();
        if (StringUtils.isNullOrEmpty((String)text)) {
            this.errors.remove(id);
        } else {
            try {
                Pattern.compile(text);
                this.errors.remove(id);
            }
            catch (PatternSyntaxException e) {
                this.errors.put(id, MessageFormat.format(errorPattern, e.getLocalizedMessage()));
            }
        }
        this.page.setErrorMessage(this.getErrorMessage());
    }

    @Override
    public void dispose() {
        this.resourceIdRegExtText.dispose();
        this.featureKeyRegExtText.dispose();
        this.featureValueRegExtText.dispose();
    }

    @Override
    public boolean isSectionComplete() {
        return this.errors.isEmpty();
    }

    @Override
    public @Nullable String getErrorMessage() {
        return String.join((CharSequence)"; ", this.errors.values());
    }

    @Override
    public void updateFilterParameters(@NonNull Map<String, Object> parameters) {
        this.updatePadameter("resource-id-regex", this.resourceIdRegExtText, parameters);
        this.updatePadameter("feature-key-regex", this.featureKeyRegExtText, parameters);
        this.updatePadameter("feature-value-regex", this.featureValueRegExtText, parameters);
    }

    private void updatePadameter(String id, Text field, @NonNull Map<String, Object> parameters) {
        String text = field.getText();
        if (StringUtils.isNotEmpty((String)text)) {
            try {
                Pattern pattern = Pattern.compile(text);
                parameters.put(id, pattern);
            }
            catch (PatternSyntaxException e) {
                this.errors.put(id, e.getLocalizedMessage());
                parameters.remove(id);
            }
        } else {
            parameters.remove(id);
        }
    }
}

