/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.common;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class UiSynchronizer {
    public static void asyncExec(Widget contextWidget, Runnable runnable) {
        Display display = UiSynchronizer.getDisplay(contextWidget);
        if (display != null) {
            display.asyncExec(runnable);
        }
    }

    public static void syncExec(Widget contextWidget, Runnable runnable) {
        Display display = UiSynchronizer.getDisplay(contextWidget);
        if (display != null) {
            display.syncExec(runnable);
        }
    }

    public static void defaultSyncExec(Runnable runnable) {
        Display display = Display.getCurrent();
        if (display != null) {
            display = Display.getDefault();
        }
        display.syncExec(runnable);
    }

    public static void defaultAsyncExec(Runnable runnable) {
        Display display = Display.getCurrent();
        if (display != null) {
            display = Display.getDefault();
        }
        display.asyncExec(runnable);
    }

    private static Display getDisplay(Widget widget) {
        Display result = null;
        if (!widget.isDisposed()) {
            try {
                result = widget.getDisplay();
            }
            catch (SWTException e) {
                UiSynchronizer.handleException(e);
            }
        }
        return result;
    }

    private static void handleException(SWTException exception) {
        if (exception.code != 24) {
            throw exception;
        }
    }
}

