/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.common.combo;

import com.e1c.langtool.ui.common.combo.IComboBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class MenuActionComboBox<T>
extends Action
implements IComboBox<T>,
IAction,
IMenuCreator {
    private IContributionItemFactory<T> itemFactory;
    private ListenerList<SelectionListener> listenerList = new ListenerList();
    private Menu menu;
    private int selectedIndex = -1;
    private List<T> data = new ArrayList<T>();

    public MenuActionComboBox(IContributionItemFactory<T> itemFactory) {
        this.itemFactory = itemFactory;
        this.setMenuCreator(this);
    }

    public MenuActionComboBox(ILabelProvider labelProvider) {
        this.itemFactory = new ItemFactory<T>(this, labelProvider);
        this.setMenuCreator(this);
    }

    public MenuActionComboBox(ILabelProvider labelProvider, List<T> content) {
        this.itemFactory = new ItemFactory<T>(this, labelProvider);
        this.data = content;
        this.setMenuCreator(this);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.listenerList.add((Object)selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.listenerList.remove((Object)selectionListener);
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        int i = 0;
        while (i < this.data.size()) {
            IContributionItem item = this.itemFactory.create(this.data.get(i), i);
            item.fill(this.menu, -1);
            ++i;
        }
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    @Override
    public synchronized void deselect() {
        this.selectedIndex = -1;
        this.fireSelectionListeners();
    }

    @Override
    public synchronized void select(int index) {
        if (index < 0 || index >= this.data.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.selectedIndex = index;
        this.fireSelectionListeners();
    }

    @Override
    public int indexOf(T item) {
        int i = 0;
        while (i < this.data.size()) {
            if (this.data.get(i).equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void addItem(int index, T item) {
        this.data.add(index, item);
    }

    @Override
    public void addItem(T item) {
        this.data.add(item);
    }

    @Override
    public void removeItem(int index) {
        this.data.remove(index);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public T getItem(int index) {
        return this.data.get(index);
    }

    @Override
    public int count() {
        return this.data.size();
    }

    @Override
    public int getSelectionIndex() {
        return this.selectedIndex;
    }

    @Override
    public Optional<T> getSelectionItem() {
        return this.selectedIndex < 0 || this.selectedIndex >= this.data.size() ? Optional.empty() : Optional.of(this.data.get(this.selectedIndex));
    }

    private void fireSelectionListeners() {
        this.listenerList.forEach(listener -> listener.widgetSelected(null));
    }

    public static interface IContributionItemFactory<V> {
        public IContributionItem create(V var1, int var2);
    }

    public static class ItemFactory<V>
    implements IContributionItemFactory<V> {
        private MenuActionComboBox<V> combo;
        private ILabelProvider labelProvider;

        public ItemFactory(MenuActionComboBox<V> combo, ILabelProvider labelProvider) {
            this.combo = combo;
            this.labelProvider = labelProvider;
        }

        @Override
        public IContributionItem create(V item, int index) {
            return new ActionContributionItem((IAction)this.createAction(item, index));
        }

        protected Action createAction(V item, final int index) {
            Image image;
            Action action = new Action(){

                public void run() {
                    combo.select(index);
                }
            };
            String text = this.labelProvider.getText(item);
            if (text != null) {
                action.setText(text);
            }
            if ((image = this.labelProvider.getImage(item)) != null) {
                ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)image);
                action.setImageDescriptor(descriptor);
            }
            return action;
        }
    }
}

