/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.common.tools;

import com.e1c.langtool.internal.ui.common.tools.ErrorComponent;
import com.e1c.langtool.internal.ui.common.tools.ExtendStyledText;
import com.e1c.langtool.internal.ui.common.tools.IErrorComponent;
import com.e1c.langtool.query.IApplicable;
import com.e1c.langtool.ui.common.ManagedViewPart;
import com.e1c.langtool.ui.common.tools.Messages;
import java.util.Optional;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class AbstractServiceView
extends ManagedViewPart {
    private static final String PREFERENCE_PAGE_ID = "com.e1c.langtool.ui";
    private Composite top;
    private IErrorComponent errorComponent;
    private Composite errorComponentParent;
    private ExtendStyledText activeText;
    private Optional<IApplicable> applicableObject = Optional.empty();
    private Optional<Job> activeJob = Optional.empty();
    private final String preferencePageId;

    public AbstractServiceView(String preferencePageId) {
        this.preferencePageId = preferencePageId;
    }

    public AbstractServiceView() {
        this.preferencePageId = PREFERENCE_PAGE_ID;
    }

    public Composite getTopComposite() {
        return this.top;
    }

    public synchronized <T extends IApplicable> void setApplicableObject(T applicable) {
        this.applicableObject = Optional.ofNullable(applicable);
    }

    public synchronized Optional<IApplicable> getApplicalbleObject() {
        return this.applicableObject;
    }

    public synchronized void setActiveText(String text) {
        this.activeText.setText(text);
    }

    public synchronized String getActiveText() {
        return this.activeText.getText();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.top = new Composite(parent, 0);
        this.top.setLayoutData((Object)new GridData(4, 1, true, true));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        this.top.setLayout((Layout)layout);
        this.createTranslationText(this.top);
        this.initMainControl(this.top);
        this.createErrorComponent(this.top);
        this.initActionBars(this.getViewSite().getActionBars());
    }

    public void setFocus() {
        this.top.setFocus();
    }

    public synchronized void startTranslating() {
        if (!this.checkInputText(this.getActiveText())) {
            this.activeText.showError();
            return;
        }
        this.stopTranslating();
        this.activeJob = Optional.ofNullable(this.createTranslationJob());
        this.activeJob.ifPresent(job -> {
            this.hideError();
            job.schedule();
        });
    }

    public synchronized void stopTranslating() {
        this.activeJob.ifPresent(job -> {
            if (job.getState() == 4) {
                job.cancel();
            }
        });
    }

    protected void initMenu(IMenuManager menuManager) {
        Action pluginPropertiesAction = new Action(Messages.AbstractServiceView_PropertiesMenuAction){

            public void run() {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)AbstractServiceView.this.getSite().getShell(), (String)AbstractServiceView.this.preferencePageId, null, null);
                dialog.open();
            }
        };
        menuManager.add((IAction)pluginPropertiesAction);
    }

    protected abstract void initToolBar(IToolBarManager var1);

    protected abstract void initMainControl(Composite var1);

    protected abstract Job createTranslationJob();

    protected void clear() {
        this.activeText.setText("");
        this.applicableObject = Optional.empty();
    }

    protected void showError(String msg, String detail, Throwable exc) {
        ErrorComponent.setExclusion(this.errorComponentParent, false);
        this.errorComponent.showError(msg, detail, exc);
        this.errorComponentParent.redraw();
        this.top.layout();
    }

    protected void hideError() {
        this.errorComponent.hide();
        ErrorComponent.setExclusion(this.errorComponentParent, true);
        this.top.layout();
    }

    protected boolean isErrorVisible() {
        return this.errorComponent.isErrorVisible();
    }

    protected void createTranslationText(Composite top) {
        Composite composite = new Composite(top, 0);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        String emtyErrorMsg = Messages.AbstractServiceView_InputTextErrorMsg;
        this.activeText = new ExtendStyledText(composite, 2626, emtyErrorMsg);
        this.activeText.setLayoutData(new GridData(4, 4, true, true));
        this.activeText.setHintMessage(Messages.AbstractServiceView_TranslatingTextHintMessage);
        this.activeText.setMargins(2, 4, 2, 4);
        this.activeText.setToolTipText(Messages.AbstractServiceView_TranslationTextToolTip);
        this.activeText.addModifyListener(event -> top.layout());
        this.activeText.addListener(31, event -> {
            int mask = event.stateMask;
            if (event.detail == 4 && mask != 131072 && mask != 262144) {
                this.startTranslating();
            }
        });
        this.activeText.addVerifyKeyListener(event -> {
            if ((event.keyCode == 13 || event.keyCode == 10) && event.stateMask != 131072 && event.stateMask != 262144) {
                event.doit = false;
            }
        });
    }

    protected void addListenerToActiveText(int eventType, Listener listener) {
        this.activeText.addListener(eventType, listener);
    }

    protected void removeListenerFromActiveText(int eventType, Listener listener) {
        this.activeText.removeListener(eventType, listener);
    }

    protected boolean checkInputText(String text) {
        return text.trim().length() > 0;
    }

    private void createErrorComponent(Composite top) {
        this.errorComponentParent = new Composite(top, 0);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        this.errorComponentParent.setLayoutData((Object)gridData);
        this.errorComponentParent.setLayout((Layout)new GridLayout());
        String id = this.getViewSite().getSecondaryId();
        if (id == null) {
            id = this.getTitle();
        }
        this.errorComponent = new ErrorComponent(id, this.preferencePageId);
        this.errorComponent.createComponent(this.errorComponentParent);
        this.hideError();
    }

    private void initActionBars(IActionBars actionBars) {
        this.initToolBar(actionBars.getToolBarManager());
        this.initMenu(actionBars.getMenuManager());
    }
}

