/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.external;

import com.e1c.langtool.external.ServiceUnavailableException;
import com.e1c.langtool.external.TranslationServiceException;
import com.e1c.langtool.external.cache.ITranslationCacheManager;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.ui.external.Messages;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractTranslationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String providerId;
    protected boolean isApiKeyValueChanged;
    private final ITranslationCacheManager translationCacheManager;

    public AbstractTranslationPreferencePage(ITranslationCacheManager translationCacheManager, String providerId) {
        Objects.requireNonNull(translationCacheManager);
        Objects.requireNonNull(providerId);
        this.translationCacheManager = translationCacheManager;
        this.providerId = providerId;
        this.isApiKeyValueChanged = false;
    }

    public boolean performOk() {
        this.storeValues();
        if (this.isApiKeyValueChanged) {
            this.getControl().getDisplay().asyncExec(this::reloadView);
            this.isApiKeyValueChanged = false;
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.initializeValues();
        super.performDefaults();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        this.createAccessKeyGroup(composite);
        this.createClearCacheGroup(composite);
        this.initializeValues();
        return composite;
    }

    protected abstract void createAccessKeyGroup(Composite var1);

    protected void createGetAccessKeyLink(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(Messages.AbstractTranslationPreferencePage_GetApiKeyLink);
        link.addSelectionListener(this.createLinkSelectionListener());
    }

    protected void clearCache() {
        ITranslationCacheManager cacheManager = (ITranslationCacheManager)UiPlugin.getDefault().getInjector().getInstance(ITranslationCacheManager.class);
        ITranslationCacheManager.ITranslationCache cache = cacheManager.getCacheByProviderId(this.providerId);
        if (cache != null) {
            cache.removeAll();
        }
    }

    protected void createClearCacheButton(Composite parent) {
        Button clearCacheButton = new Button(parent, 0);
        GridData gridData = new GridData(131072, 4, true, true);
        gridData.widthHint = 80;
        clearCacheButton.setLayoutData((Object)gridData);
        clearCacheButton.setText(Messages.AbstractPreferencePage_ClearCacheBtn);
        clearCacheButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String title = Messages.AbstractPreferencePage_ClearCacheMessageDialogTitle;
                String msg = Messages.AbstractPreferencePage_ClearCacheMessageDialogMsg;
                if (MessageDialog.openConfirm((Shell)AbstractTranslationPreferencePage.this.getShell(), (String)title, (String)msg)) {
                    AbstractTranslationPreferencePage.this.clearCache();
                }
            }
        });
    }

    protected void createClearCacheGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        GridData data = new GridData(768);
        group.setLayoutData((Object)data);
        group.setText(Messages.AbstractPreferencePage_CacheGroupLabel);
        Label label = new Label((Composite)group, 16448);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        ITranslationCacheManager.ITranslationCache cache = this.translationCacheManager.getCacheByProviderId(this.providerId);
        long total = cache.size();
        label.setText(MessageFormat.format(Messages.AbstractPreferencePage_ClearCacheLabel, total));
        this.createClearCacheButton((Composite)group);
    }

    protected void createCheckAccessKeyButton(Composite parent) {
        Button checkKeyBtn = new Button(parent, 0);
        checkKeyBtn.setText(Messages.AbstractPreferencePage_ValidateApiKeyButton);
        checkKeyBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Display.getDefault().asyncExec(() -> {
                    boolean isValid;
                    try {
                        isValid = AbstractTranslationPreferencePage.this.checkAccessKey(AbstractTranslationPreferencePage.this.getAccessKey());
                    }
                    catch (ServiceUnavailableException exc) {
                        MessageDialog.openError((Shell)AbstractTranslationPreferencePage.this.getShell(), (String)Messages.AbstractTranslationPreferencePage_ServiceUnavailableDialogTitle, (String)Messages.AbstractTranslationPreferencePage_ServiceUnavailableDialogDetailMsg);
                        return;
                    }
                    catch (TranslationServiceException exc) {
                        MessageDialog.openError((Shell)AbstractTranslationPreferencePage.this.getShell(), (String)Messages.AbstractTranslationPreferencePage_ServiceErrorKeyDialogTitle, (String)exc.getMessage());
                        return;
                    }
                    if (isValid) {
                        MessageDialog.openInformation((Shell)AbstractTranslationPreferencePage.this.getShell(), (String)Messages.AbstractPreferencePage_ValidateApiKeyDialogTitle, (String)Messages.AbstractPreferencePage_ValidateApiKeyDialogMsgForValidValue);
                    } else {
                        MessageDialog.openError((Shell)AbstractTranslationPreferencePage.this.getShell(), (String)Messages.AbstractPreferencePage_ValidateApiKeyDialogTitle, (String)Messages.AbstractPreferencePage_ValidateApiKeyDialogMsgForInvalidValue);
                    }
                });
            }
        });
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return this.getPreferenceStore();
    }

    protected abstract String getAccessKey();

    protected abstract boolean checkAccessKey(String var1);

    protected abstract void reloadView();

    protected abstract SelectionListener createLinkSelectionListener();

    protected abstract void initializeValues();

    protected abstract void storeValues();
}

