/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.external;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.external.ExceededQuotaException;
import com.e1c.langtool.external.IExternalTranslationManager;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.external.InvalidAccessKeyException;
import com.e1c.langtool.external.InvalidLanguagesException;
import com.e1c.langtool.external.InvalidTextException;
import com.e1c.langtool.external.LocaleUtils;
import com.e1c.langtool.external.ServiceUnavailableException;
import com.e1c.langtool.external.TranslationServiceException;
import com.e1c.langtool.flags.ui.SharedImages;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.internal.ui.common.tools.ExtendStyledText;
import com.e1c.langtool.query.IApplicable;
import com.e1c.langtool.query.ISingleTranslationQuery;
import com.e1c.langtool.query.SingleTranslationQuery;
import com.e1c.langtool.ui.common.combo.IComboBox;
import com.e1c.langtool.ui.common.combo.MenuActionComboBox;
import com.e1c.langtool.ui.common.memento.IPersistableComponent;
import com.e1c.langtool.ui.common.memento.PersistableActionFactory;
import com.e1c.langtool.ui.common.memento.annotation.AnnotationEngine;
import com.e1c.langtool.ui.common.tools.AbstractServiceView;
import com.e1c.langtool.ui.common.tools.LanguageLabelProvider;
import com.e1c.langtool.ui.common.tools.ToolBarBuilder;
import com.e1c.langtool.ui.external.Messages;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class ExternalTranslationView
extends AbstractServiceView {
    private IComboBox<String> sourceLanguage;
    private IComboBox<String> targetLanguage;
    private IAction autoTranslatableAction;
    private IAction textProcessingAction;
    private IAction copyAction;
    protected TableViewer translationTableViewer;
    private IPersistableComponent persistable;
    private IDialogSettings settings;
    private ISelectionListener selectionListener;
    protected final IExternalTranslationManager translationManager;
    private final String providerId;
    private List<String> translations = new CopyOnWriteArrayList<String>();
    protected volatile boolean isLangsInitialized = false;
    private Composite parent;
    private LanguageLabelProvider labelProvider;

    public ExternalTranslationView(IExternalTranslationManager manager, String providerId, String preferencePageId) {
        super(preferencePageId);
        this.translationManager = manager;
        this.providerId = providerId;
        this.selectionListener = this.createSelectionListener();
    }

    public synchronized void setSourceLanguage(String locale) {
        this.setLanguage(this.sourceLanguage, locale);
    }

    public synchronized void setTargetLanguage(String locale) {
        this.setLanguage(this.targetLanguage, locale);
    }

    public synchronized Optional<String> getSourceLanguage() {
        return this.sourceLanguage.getSelectionItem();
    }

    public synchronized Optional<String> getTargetLanguage() {
        return this.targetLanguage.getSelectionItem();
    }

    @Override
    public void createPartControl(Composite parent) {
        this.parent = parent;
        super.createPartControl(parent);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.selectionListener);
        this.initPersistableComponent();
    }

    @Override
    public void closed() {
        this.persistable.saveState(this.settings);
        super.closed();
    }

    @Override
    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.selectionListener);
        this.selectionListener = null;
        super.dispose();
    }

    public boolean isInitialized() {
        return this.isLangsInitialized;
    }

    protected void handleTextSelection(ITextSelection selection) {
        if (!StringUtils.isBlank((String)selection.getText())) {
            this.clear();
            this.setActiveText(selection.getText());
            if (StringUtils.isCamelCase((String)selection.getText())) {
                this.textProcessingAction.setChecked(true);
            } else {
                this.textProcessingAction.setChecked(false);
            }
            if (this.autoTranslatableAction.isChecked()) {
                this.startTranslating();
            }
        } else {
            this.clear();
        }
    }

    protected void handleStructedSelection(IStructuredSelection selection) {
        Object data = selection.getFirstElement();
        boolean isQuery = false;
        try {
            ISingleTranslationQuery query = this.getAdapter(data, ISingleTranslationQuery.class);
            if (query != null) {
                this.clear();
                this.setActiveQuery(query);
                isQuery = true;
            }
            if (data instanceof IApplicable) {
                IApplicable applicable = (IApplicable)data;
                this.setApplicableObject(applicable);
            }
        }
        catch (InvalidLanguagesException exc) {
            this.handleTranslationException((TranslationServiceException)((Object)exc));
        }
        catch (NullPointerException exc) {
            UiPlugin.logError(exc);
        }
        if (isQuery && this.autoTranslatableAction.isChecked()) {
            this.startTranslating();
        }
    }

    @Override
    protected void initMainControl(Composite top) {
        Composite composite = new Composite(top, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableColumnLayout);
        Table translationTable = new Table(composite, 67584);
        translationTable.setLinesVisible(true);
        translationTable.setHeaderVisible(true);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        TableColumn column = new TableColumn(translationTable, 0);
        column.setText(Messages.ExternalTranslationView_TranslationTableHeader);
        column.pack();
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(20, 10, true));
        this.translationTableViewer = new TableViewer(translationTable);
        translationTable.layout(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.translationTableViewer);
        this.translationTableViewer.setContentProvider(this.getTranslationTableContentProvider());
        this.translationTableViewer.setLabelProvider(this.getTranslationTableLabelProvider());
        this.translationTableViewer.setInput(this.getTranslationInput());
        this.translationTableViewer.addDoubleClickListener(event -> {
            TableItem item = this.translationTableViewer.getTable().getSelection()[0];
            if (item != null && this.getApplicalbleObject().isPresent()) {
                this.getApplicalbleObject().ifPresent(q -> SafeRunner.run(() -> q.apply(item.getText())));
            }
        });
        this.copyAction = this.createCopyAction();
        this.createContextMenu();
        this.hookGlobalActions();
    }

    protected Object getTranslationInput() {
        return this.translations;
    }

    protected IContentProvider getTranslationTableContentProvider() {
        return ArrayContentProvider.getInstance();
    }

    protected IBaseLabelProvider getTranslationTableLabelProvider() {
        return new ColumnLabelProvider(){

            public String getToolTipText(Object element) {
                return !ExternalTranslationView.this.getApplicalbleObject().isPresent() ? null : Messages.ExternalTranslationView_TranslationTableToolTip;
            }
        };
    }

    @Override
    protected void initMenu(IMenuManager menuManager) {
        menuManager.add(this.autoTranslatableAction);
        menuManager.add(this.textProcessingAction);
        menuManager.add((IContributionItem)new Separator());
        super.initMenu(menuManager);
    }

    @Override
    protected void clear() {
        super.clear();
        this.translationTableViewer.getTable().removeAll();
        this.hideError();
    }

    @Override
    protected Job createTranslationJob() {
        Optional<ISingleTranslationQuery> query = this.createQueryFromState();
        return query.isPresent() ? this.createJobFromQuery(query.get()) : null;
    }

    protected Job createJobFromQuery(final ISingleTranslationQuery query) {
        return new Job(this.getTitle()){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    if (subMonitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    List res = ExternalTranslationView.this.translationManager.translate(query, ExternalTranslationView.this.providerId, (IProgressMonitor)subMonitor);
                    if (subMonitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ExternalTranslationView.this.translations.clear();
                    if (!res.isEmpty()) {
                        ExternalTranslationView.this.translations.addAll(res);
                    }
                    Display.getDefault().asyncExec(() -> ExternalTranslationView.this.showTranslations());
                }
                catch (TranslationServiceException exc) {
                    ExternalTranslationView.this.handleTranslationException(exc);
                }
                return Status.OK_STATUS;
            }
        };
    }

    @Override
    protected void initToolBar(IToolBarManager tbm) {
        final ToolBarManager toolBarManager = (ToolBarManager)tbm;
        this.labelProvider = new LanguageLabelProvider(Collections.emptyMap());
        final MenuActionComboBox<String> sourceCombo = new MenuActionComboBox<String>((ILabelProvider)this.labelProvider);
        final MenuActionComboBox<String> targetCombo = new MenuActionComboBox<String>((ILabelProvider)this.labelProvider);
        sourceCombo.setText("  -  ");
        targetCombo.setText("  -  ");
        sourceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sourceCombo.setText(sourceCombo.getSelectionItem().orElse(" - "));
                String img = sourceCombo.getSelectionItem().orElse("com.e1c.langtool.flags.ui/obj16/default.png");
                sourceCombo.setImageDescriptor(SharedImages.getImageDescriptor((String)img));
                toolBarManager.getControl().pack(true);
                toolBarManager.getControl().update();
                toolBarManager.getControl().redraw();
            }
        });
        targetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                targetCombo.setText(targetCombo.getSelectionItem().orElse(" - "));
                String img = targetCombo.getSelectionItem().orElse("com.e1c.langtool.flags.ui/obj16/default.png");
                targetCombo.setImageDescriptor(SharedImages.getImageDescriptor((String)img));
                toolBarManager.getControl().pack(true);
                toolBarManager.getControl().update();
                toolBarManager.getControl().redraw();
            }
        });
        ActionContributionItem sourceItem = new ActionContributionItem(sourceCombo);
        sourceItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        ActionContributionItem targetItem = new ActionContributionItem(targetCombo);
        targetItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        sourceCombo.setImageDescriptor(SharedImages.getImageDescriptor((String)"com.e1c.langtool.flags.ui/obj16/default.png"));
        targetCombo.setImageDescriptor(SharedImages.getImageDescriptor((String)"com.e1c.langtool.flags.ui/obj16/default.png"));
        this.sourceLanguage = sourceCombo;
        this.targetLanguage = targetCombo;
        new ToolBarBuilder(tbm).item((ContributionItem)sourceItem).swapLanguagesAction(sourceCombo, targetCombo).item((ContributionItem)targetItem).separator().runTranslationAction(this::startTranslating).autoTranslatableAction(action -> {
            IAction iAction = this.autoTranslatableAction = action;
        }).textProcessingAction(action -> {
            IAction iAction = this.textProcessingAction = action;
        }).build();
        this.updateLanguages();
    }

    protected void updateLanguages() {
        Job.create((String)Messages.ExternalTranslationView_GettingSupportedLanguagesJobMessage, monitor -> {
            Map<String, String> langs;
            if (this.parent != null && !this.parent.isDisposed() && !this.parent.getDisplay().isDisposed()) {
                this.parent.getDisplay().syncExec(() -> {
                    this.sourceLanguage.clear();
                    this.targetLanguage.clear();
                });
            }
            try {
                langs = this.getSupportedLanguages();
            }
            catch (TranslationServiceException e) {
                this.handleTranslationException(e);
                return;
            }
            if (this.parent != null && !this.parent.isDisposed() && !this.parent.getDisplay().isDisposed()) {
                this.parent.getDisplay().asyncExec(() -> {
                    langs.forEach((code, name) -> {
                        this.sourceLanguage.addItem((String)code);
                        this.targetLanguage.addItem((String)code);
                    });
                    this.labelProvider.setLanguages(langs);
                    this.sourceLanguage.select(Math.max(0, this.sourceLanguage.indexOf("ru")));
                    this.targetLanguage.select(Math.max(0, this.sourceLanguage.indexOf("en")));
                    this.hideError();
                });
            }
        }).schedule();
    }

    private void hookGlobalActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyAction);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(mgr -> mgr.add(this.copyAction));
        Menu menu = menuMgr.createContextMenu(this.translationTableViewer.getControl());
        this.translationTableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.translationTableViewer);
    }

    private IAction createCopyAction() {
        return new Action(Messages.ExternalTranslationView_CopyTranslationMenuItemText){

            public void run() {
                ExternalTranslationView.this.copyTranslationText();
            }
        };
    }

    private void initPersistableComponent() {
        this.settings = DialogSettings.getOrCreateSection((IDialogSettings)UiPlugin.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getName());
        PersistableActionFactory.ActionPersistableComponent autoTranslatablePersistant = new PersistableActionFactory.ActionPersistableComponent(this.autoTranslatableAction, "autoTranslatableAction");
        PersistableActionFactory.ActionPersistableComponent textProcessingPersistant = new PersistableActionFactory.ActionPersistableComponent(this.textProcessingAction, "textProcessingAction");
        this.persistable = new AnnotationEngine.CompositePersistableComponent(Set.of(autoTranslatablePersistant, textProcessingPersistant));
        this.persistable.initState(this.settings);
    }

    protected Optional<ISingleTranslationQuery> createQueryFromState() {
        if (this.getSourceLanguage().isPresent() && this.getTargetLanguage().isPresent()) {
            return Optional.of(SingleTranslationQuery.createQuery((String)this.getActiveText(), (String)this.getSourceLanguage().get(), (String)this.getTargetLanguage().get(), (boolean)this.textProcessingAction.isChecked()));
        }
        if (!this.isLangsInitialized) {
            this.showLangsInitError();
        }
        return Optional.empty();
    }

    protected void handleTranslationException(TranslationServiceException exc) {
        if (exc instanceof InvalidAccessKeyException) {
            this.syncShowError(Messages.ExternalTranslationView_InvalidAccessKeyMsg, Messages.ExternalTranslationView_InvalidAccessKeyDetail, exc);
        } else if (exc instanceof InvalidLanguagesException) {
            this.syncShowError(Messages.ExternalTranslationView_InvalidLanguagesMsg, Messages.ExternalTranslationView_InvalidLanguagesDetail, exc);
        } else if (exc instanceof InvalidTextException) {
            this.syncShowError(Messages.ExternalTranslationView_InvalidTextMsg, Messages.ExternalTranslationView_InvalidTextDetail, exc);
        } else if (exc instanceof ExceededQuotaException) {
            this.syncShowError(Messages.ExternalTranslationView_ExceededQuotaMsg, Messages.ExternalTranslationView_ExceededQuotaDetail, exc);
        } else if (exc instanceof ServiceUnavailableException) {
            this.syncShowError(Messages.ExternalTranslationView_ServiceUnavailableMsg, Messages.ExternalTranslationView_ServiceUnavailableMsgDetail, exc);
        } else {
            String message = exc.getMessage().isBlank() ? Messages.ExternalTranslationView_UnknowErrorDetail : exc.getMessage();
            this.syncShowError(Messages.ExternalTranslationView_UnknowErrorMsg, message, exc);
        }
    }

    private void syncShowError(String msg, String detail, Throwable exc) {
        if (!this.parent.isDisposed() && !this.parent.getDisplay().isDisposed()) {
            this.parent.getDisplay().syncExec(() -> this.showError(msg, detail, exc));
        }
    }

    private void showTranslations() {
        if (!this.translationTableViewer.getTable().isDisposed()) {
            this.translationTableViewer.refresh();
        }
    }

    protected Map<String, String> getSupportedLanguages() {
        String currentLocale;
        IExternalTranslationProvider provider = this.translationManager.getTranslationProviderRegistry().getExternalTranslationProvider(this.providerId);
        Map langsMap = provider.getLanguages(LocaleUtils.getCode((String)(currentLocale = Locale.getDefault().toLanguageTag())));
        if (langsMap == null && (langsMap = provider.getLanguages("en")) == null) {
            try {
                langsMap = provider.getLanguages((String)provider.getLanguageCodes().iterator().next());
            }
            catch (NoSuchElementException exc) {
                throw new TranslationServiceException(Messages.ExternalTranslationView_NoSupportedLanguagesExceptionMsg, (Throwable)exc);
            }
        }
        if (langsMap.size() == 0) {
            throw new TranslationServiceException(Messages.ExternalTranslationView_NoSupportedLanguagesExceptionMsg);
        }
        this.isLangsInitialized = true;
        return langsMap;
    }

    private ISelectionListener createSelectionListener() {
        return new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (!ExternalTranslationView.this.isLangsInitialized) {
                    ExternalTranslationView.this.showLangsInitError();
                    return;
                }
                if (part != ExternalTranslationView.this && !selection.isEmpty()) {
                    if (selection instanceof IStructuredSelection) {
                        ExternalTranslationView.this.handleStructedSelection((IStructuredSelection)selection);
                    } else if (selection instanceof ITextSelection) {
                        ExternalTranslationView.this.handleTextSelection((ITextSelection)selection);
                    }
                } else {
                    ExternalTranslationView.this.clear();
                }
            }
        };
    }

    private void setLanguage(IComboBox<String> combo, String language) {
        if (combo.indexOf(language) > -1) {
            combo.select(combo.indexOf(language));
        } else if (!this.isLangsInitialized) {
            this.showLangsInitError();
        } else {
            this.showError(Messages.ExternalTranslationView_InvalidLanguagesMsg, Messages.ExternalTranslationView_InvalidLanguagesDetail, null);
            throw new InvalidLanguagesException(Messages.ExternalTranslationView_InvalidLanguagesMsg);
        }
    }

    private void copyTranslationText() {
        String textData;
        Control control = this.getViewSite().getWorkbenchWindow().getWorkbench().getDisplay().getFocusControl();
        Display display = control.getDisplay();
        Clipboard clipboard = new Clipboard(display);
        if (control instanceof ExtendStyledText) {
            textData = ((ExtendStyledText)control).getSelectionText();
        } else if (control instanceof Table) {
            Table translationTable = this.translationTableViewer.getTable();
            if (translationTable.getSelectionCount() < 1) {
                return;
            }
            textData = translationTable.getSelection()[0].getText();
        } else {
            return;
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] transfers = new Transfer[]{textTransfer};
        Object[] data = new Object[]{textData};
        clipboard.setContents(data, transfers);
        clipboard.dispose();
    }

    private <T> T getAdapter(Object obj, Class<T> clazz) {
        if (obj == null) {
            return null;
        }
        if (clazz.isInstance(obj)) {
            return (T)obj;
        }
        if (obj instanceof IAdaptable) {
            return (T)((IAdaptable)obj).getAdapter(clazz);
        }
        return (T)Platform.getAdapterManager().loadAdapter(obj, clazz.getName());
    }

    protected void setActiveQuery(ISingleTranslationQuery query) {
        this.setActiveText(query.getText());
        this.setSourceLanguage(query.getSourceLanguage());
        this.setTargetLanguage(query.getTargetLanguage());
        this.textProcessingAction.setChecked(query.isProcessingNeeded());
    }

    private void showLangsInitError() {
        if (!this.isErrorVisible()) {
            this.showError(Messages.ExternalTranslationView_LanguagesInitializationErrorTitle, Messages.ExternalTranslationView_LanguagesInitializationErrorDetailMsg, null);
        }
    }
}

