/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.generatestring;

import com.e1c.langtool.collector.CollectingServiceRegistry;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.ui.generatestring.FilterSettingSection;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

@Singleton
public class FilterSettingsPageSectionFactory {
    private static final String EXTENSION_POINT_ID = "generateStringsFilterSettingSection";
    private static final String ATT_CLASS = "class";
    private static final String ATT_FILTER = "filter";
    private final CollectingServiceRegistry collectingServiceRegistry = (CollectingServiceRegistry)UiPlugin.getDefault().getInjector().getInstance(CollectingServiceRegistry.class);

    public boolean hasSections(ITranslatingProject translatingProject) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.e1c.langtool.ui", EXTENSION_POINT_ID);
        return elements.length > 0;
    }

    public List<FilterSettingSection> createPageSections(ITranslatingProject translatingProject) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.e1c.langtool.ui", EXTENSION_POINT_ID);
        ArrayList<FilterSettingSection> sections = new ArrayList<FilterSettingSection>();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement configElement = elements[i];
            String filterId = configElement.getAttribute(ATT_FILTER);
            if (this.collectingServiceRegistry.getFilterParticipants(filterId) == null) {
                String message = MessageFormat.format("Generate Strings Filter section registred for unknown filter id: {0} with class name: {1}", filterId, configElement.getAttribute(ATT_CLASS));
                UiPlugin.log(UiPlugin.createErrorStatus(message, null));
            } else {
                try {
                    FilterSettingSection e = (FilterSettingSection)configElement.createExecutableExtension(ATT_CLASS);
                    sections.add(e);
                }
                catch (CoreException e) {
                    UiPlugin.logError(e);
                }
            }
            ++i;
        }
        return sections;
    }
}

