/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.generatestring;

import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.flags.ui.SharedImages;
import com.e1c.langtool.generatestring.TranslationStringsGenerator;
import com.e1c.langtool.internal.ui.UiPlugin;
import com.e1c.langtool.internal.ui.view.FeatureValueCellEditorValidator;
import com.e1c.langtool.internal.ui.view.FeatureValueTextCellEditor;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.settings.ValidatorRegistry;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.ui.SearchText;
import com.e1c.langtool.ui.TableViewerColumnComparator;
import com.e1c.langtool.ui.TransSharedImages;
import com.e1c.langtool.ui.generatestring.Messages;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class PreviewStringsWizardPage
extends WizardPage
implements IPageChangedListener {
    private static final String COLUMN_DATA_NAME = "name";
    private static final String COLUNM_NAME_RESOURCE = "resource";
    private static final String COLUNM_NAME_KEY = "key";
    private static final String COLUNM_NAME_VALUE = "value";
    @Inject
    protected ITranslationStorageManager storageManager;
    @Inject
    private ValidatorRegistry registry;
    private TableViewer viewer;
    private ITableLabelProvider labelProvider = new FeatureNlsValuesTableLableProvider();
    private Map<TranslateLanguage, TableViewerColumn> languageColumns;
    private SearchText searchText;
    private String currentSearchString = "";
    private ViewerFilter searchFilter;
    private List<FeatureValue> values = Lists.newArrayList();
    private TableViewerColumnComparator comparator;
    private TranslationStringsGenerator generator;
    private Label totalLabel;

    public PreviewStringsWizardPage() {
        super("PreviewStringsPage", Messages.PreviewStringsWizardPage_Collected_translatable_strings, TransSharedImages.getImageDescriptor("com.e1c.langtool.ui/wizban/generatestring_preview_wizard.png"));
        this.setDescription(Messages.PreviewStringsWizardPage_Description);
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(font);
        this.searchText = new SearchText(topLevel);
        this.searchText.setLayoutData(new GridData(768));
        this.searchText.setFont(font);
        this.searchText.getTextControl().setToolTipText(Messages.PreviewStringsWizardPage_Enter_search_string_or_regular_expression_pattern);
        this.searchText.addPostSearchModifyListener(new SearchText.SearchModifyListener(){

            @Override
            public void modifyText(final SearchText.SearchTextModifyEvent e) {
                if (!PreviewStringsWizardPage.this.searchText.getDisplay().isDisposed()) {
                    PreviewStringsWizardPage.this.searchText.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).PreviewStringsWizardPage.this.currentSearchString = e.getText();
                            (this).PreviewStringsWizardPage.this.viewer.refresh();
                        }
                    });
                }
            }
        });
        Composite viewerComposite = new Composite(topLevel, 0);
        viewerComposite.setLayout((Layout)new GridLayout());
        viewerComposite.setLayoutData((Object)new GridData(1808));
        viewerComposite.setFont(font);
        this.viewer = new TableViewer(viewerComposite, 68354);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setFont(font);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setToolTipText(Messages.PreviewStringsWizardPage_Use_SPACE_or_DEL_to_inverse_check_state_or_to_delete_selected_rows);
        table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    IStructuredSelection selection = (IStructuredSelection)PreviewStringsWizardPage.this.viewer.getSelection();
                    Collection collectedValues = PreviewStringsWizardPage.this.getGenerator().getCollectedValues();
                    for (FeatureValue value : selection) {
                        PreviewStringsWizardPage.this.values.remove(value);
                        collectedValues.remove(value);
                    }
                    PreviewStringsWizardPage.this.viewer.refresh();
                    PreviewStringsWizardPage.this.updateTotalLabel();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.createViewerColumns(viewerComposite);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.searchFilter = new TextSearchFilter();
        this.viewer.addFilter(this.searchFilter);
        if (this.getContainer() instanceof IPageChangeProvider) {
            IPageChangeProvider provider = (IPageChangeProvider)this.getContainer();
            provider.addPageChangedListener((IPageChangedListener)this);
        }
        this.comparator = new TableViewerColumnComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.totalLabel = new Label(topLevel, 64);
        this.totalLabel.setLayoutData((Object)new GridData(768));
        this.totalLabel.setFont(font);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
        this.setPageComplete(false);
    }

    public void dispose() {
        if (this.getContainer() instanceof IPageChangeProvider) {
            IPageChangeProvider provider = (IPageChangeProvider)this.getContainer();
            provider.removePageChangedListener((IPageChangedListener)this);
        }
        super.dispose();
    }

    private void createViewerColumns(Composite tableComposite) {
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        Pair resourceColumn = new Pair((Object)COLUNM_NAME_RESOURCE, (Object)Messages.PreviewStringsWizardPage_Resource);
        Pair keyColumn = new Pair((Object)COLUNM_NAME_KEY, (Object)Messages.PreviewStringsWizardPage_Key);
        Pair valueColumn = new Pair((Object)COLUNM_NAME_VALUE, (Object)Messages.PreviewStringsWizardPage_Value);
        ArrayList columnHeaders = Lists.newArrayList((Object[])new Pair[]{resourceColumn, keyColumn, valueColumn});
        int i = 0;
        while (i < columnHeaders.size()) {
            TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
            column.getColumn().setText((String)((Pair)columnHeaders.get(i)).getValue());
            tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 100));
            column.getColumn().setMoveable(true);
            column.getColumn().setData(COLUMN_DATA_NAME, ((Pair)columnHeaders.get(i)).getKey());
            int index = this.viewer.getTable().getColumnCount() - 1;
            column.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(column.getColumn(), index));
            ++i;
        }
        List languages = this.getGenerator().getTranslatingProject().getInterfaceLanguages();
        this.languageColumns = new HashMap<TranslateLanguage, TableViewerColumn>();
        for (TranslateLanguage language : languages) {
            TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
            this.languageColumns.put(language, column);
            String columnText = language.getPresentation();
            if (StringUtils.isNullOrEmpty((String)columnText)) {
                columnText = language.getName();
            }
            column.getColumn().setText(columnText);
            tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 100));
            column.getColumn().setMoveable(true);
            column.getColumn().setData(COLUMN_DATA_NAME, (Object)language.getLanguageCode());
            column.setEditingSupport((EditingSupport)new ViewerTextEditingSupport((ColumnViewer)this.viewer, language));
            column.getColumn().setImage(SharedImages.getLanguageFlagImage((IProject)this.getGenerator().getProject(), (String)language.getLanguageCode()));
            int index = this.viewer.getTable().getColumnCount() - 1;
            column.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(column.getColumn(), index));
        }
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewStringsWizardPage.this.comparator.setColumn(index);
                int dir = PreviewStringsWizardPage.this.comparator.getDirection(index);
                PreviewStringsWizardPage.this.viewer.getTable().setSortDirection(dir);
                PreviewStringsWizardPage.this.viewer.getTable().setSortColumn(column);
                PreviewStringsWizardPage.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public void pageChanged(PageChangedEvent event) {
        if (event.getSelectedPage() != null && event.getSelectedPage().equals((Object)this)) {
            List languages = this.getGenerator().getLanguages();
            for (Map.Entry<TranslateLanguage, TableViewerColumn> entry : this.languageColumns.entrySet()) {
                TableColumn column = entry.getValue().getColumn();
                if (languages.contains(entry.getKey())) {
                    column.setResizable(true);
                    if (column.getWidth() != 0) continue;
                    column.setWidth(100);
                    continue;
                }
                column.setResizable(false);
                column.setWidth(0);
            }
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.PreviewStringsWizardPage_Collecting_source_strings, 1);
                        PreviewStringsWizardPage.this.values.clear();
                        PreviewStringsWizardPage.this.getGenerator().getErrors().clear();
                        PreviewStringsWizardPage.this.collectTranslationStrings(monitor);
                        Display display = PreviewStringsWizardPage.this.getShell().getDisplay();
                        if (!display.isDisposed() && !monitor.isCanceled()) {
                            monitor.beginTask(Messages.PreviewStringsWizardPage_Updating_list_of_collected_features, -1);
                            int maxItemsInList = PreviewStringsWizardPage.this.getMaxItemsInList();
                            Iterator iterator = PreviewStringsWizardPage.this.getGenerator().getCollectedValues().iterator();
                            while (iterator.hasNext() && PreviewStringsWizardPage.this.values.size() < maxItemsInList) {
                                FeatureValue fv = (FeatureValue)iterator.next();
                                PreviewStringsWizardPage.this.values.add(fv);
                            }
                            PreviewStringsWizardPage.this.sortValues();
                            display.asyncExec(() -> PreviewStringsWizardPage.access$0(PreviewStringsWizardPage.this));
                        }
                        monitor.done();
                        PreviewStringsWizardPage.this.showTranslationErrorDialog(PreviewStringsWizardPage.this.getGenerator().getErrors());
                    }
                });
            }
            catch (InvocationTargetException e) {
                UiPlugin.logError(e);
                this.showTranslationErrorDialog(Lists.newArrayList((Object[])new Exception[]{e}));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.setPageComplete(this.validatePage());
        }
    }

    public TranslationStringsGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(TranslationStringsGenerator generator) {
        this.generator = generator;
    }

    protected boolean validatePage() {
        return !this.getGenerator().getCollectedValues().isEmpty();
    }

    protected void collectTranslationStrings(IProgressMonitor monitor) {
        this.getGenerator().collectStrings(monitor);
    }

    protected int getMaxItemsInList() {
        return Integer.MAX_VALUE;
    }

    private void addValuesToTable() {
        this.viewer.setInput(this.values);
        this.updateTotalLabel();
    }

    private void updateTotalLabel() {
        int shown;
        int total = this.getGenerator().getCollectedValues().size();
        if (total > (shown = this.values.size())) {
            this.totalLabel.setText(MessageFormat.format(Messages.PreviewStringsWizardPage_Total_items_shown_N_of_M_collected, shown, total));
        } else {
            this.totalLabel.setText(MessageFormat.format(Messages.PreviewStringsWizardPage_Total_items_collected_N, shown));
        }
    }

    private void sortValues() {
        this.comparator.setColumn(0, 0);
        this.comparator.addColumn(1, 0);
    }

    private void showTranslationErrorDialog(Collection<Exception> errors) {
        if (errors.isEmpty()) {
            return;
        }
        Exception exc = errors.iterator().next();
        errors.size();
        Display.getDefault().syncExec(() -> {
            int n = ErrorDialog.openError((Shell)this.getShell(), (String)Messages.GenerateTranslationStringsWizard_ErrorDialogTitle, (String)Messages.GenerateTranslationStringsWizard_ErrorDialogMsgWhileTranslating, (IStatus)new Status(4, "com.e1c.langtool.ui", exc.getMessage(), (Throwable)exc));
        });
    }

    private void init() {
        if (this.registry == null || this.storageManager == null) {
            UiPlugin.getDefault().getInjector().injectMembers((Object)this);
        }
    }

    static /* synthetic */ void access$0(PreviewStringsWizardPage previewStringsWizardPage) {
        previewStringsWizardPage.addValuesToTable();
    }

    private class FeatureNlsValuesTableLableProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private FeatureNlsValuesTableLableProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result;
            block13: {
                String columnName;
                result = null;
                if (!(element instanceof FeatureValue)) break block13;
                FeatureValue featureValue = (FeatureValue)element;
                switch (columnName = (String)PreviewStringsWizardPage.this.viewer.getTable().getColumn(columnIndex).getData(PreviewStringsWizardPage.COLUMN_DATA_NAME)) {
                    case "resource": {
                        result = featureValue.getContextKey().getResourceId().toString();
                        break;
                    }
                    case "key": {
                        result = featureValue.getContextKey().getFeatureKey().toString();
                        break;
                    }
                    case "value": {
                        result = featureValue.getContextKey().getValue();
                        break;
                    }
                    default: {
                        result = (String)featureValue.getLocalStrings().get(columnName);
                    }
                }
            }
            return result != null ? result : "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            String columnName = (String)PreviewStringsWizardPage.this.viewer.getTable().getColumn(columnIndex).getData(PreviewStringsWizardPage.COLUMN_DATA_NAME);
            if (PreviewStringsWizardPage.COLUNM_NAME_KEY.equals(columnName)) {
                FeatureValue featureValue = (FeatureValue)element;
                if (featureValue.isComputedValue() && !featureValue.getContextKey().getFeatureSettings().isInterface()) {
                    return TransSharedImages.getImage("com.e1c.langtool.ui/obj16/model_model_computed_obj.png");
                }
                if (featureValue.isComputedValue() && featureValue.getContextKey().getFeatureSettings().isInterface()) {
                    return TransSharedImages.getImage("com.e1c.langtool.ui/obj16/model_interface_computed_obj.png");
                }
                if (featureValue.isUnknown()) {
                    return TransSharedImages.getImage("com.e1c.langtool.ui/obj16/model_model_unknown_obj.png");
                }
                if (!featureValue.getContextKey().getFeatureSettings().isInterface() && featureValue.getContextKey().getFeatureSettings().isUnique()) {
                    return TransSharedImages.getImage("com.e1c.langtool.ui/obj16/model_model_key_obj.png");
                }
                if (!featureValue.getContextKey().getFeatureSettings().isInterface()) {
                    return TransSharedImages.getImage("com.e1c.langtool.ui/obj16/model_model_obj.png");
                }
                if (featureValue.getContextKey().getFeatureSettings().isInterface()) {
                    return TransSharedImages.getImage("com.e1c.langtool.ui/obj16/model_interface_obj.png");
                }
            }
            return null;
        }
    }

    private class TextSearchFilter
    extends ViewerFilter {
        private TextSearchFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Object text = PreviewStringsWizardPage.this.currentSearchString;
            if (StringUtils.isNullOrEmpty((String)text)) {
                return true;
            }
            boolean isRegex = false;
            try {
                Pattern.compile((String)text);
                if (((String)text).matches("\\W")) {
                    isRegex = true;
                }
            }
            catch (PatternSyntaxException e) {
                isRegex = false;
            }
            if (!isRegex) {
                text = ".*" + (String)text + ".*";
            }
            try {
                Pattern.compile((String)text);
            }
            catch (PatternSyntaxException e) {
                return false;
            }
            boolean result = false;
            if (element instanceof FeatureValue) {
                FeatureValue value = (FeatureValue)element;
                boolean bl = result = value.getContextKey().getValue() != null && value.getContextKey().getValue().matches((String)text);
                if (!result) {
                    for (TranslateLanguage language : PreviewStringsWizardPage.this.languageColumns.keySet()) {
                        String nlsValue = (String)value.getLocalStrings().get(language.getLanguageCode());
                        if (!StringUtils.isNullOrEmpty((String)nlsValue) && (result |= nlsValue.matches((String)text))) break;
                    }
                }
                if (!result) {
                    result |= !value.getContextKey().getFeatureKey().isEmpty() && value.getContextKey().getFeatureKey().toString().matches((String)text);
                }
                if (!result) {
                    result |= value.getContextKey().getResourceId().toString().matches((String)text);
                }
            }
            return result;
        }
    }

    private class ViewerTextEditingSupport
    extends EditingSupport {
        private final TranslateLanguage language;
        private final TextCellEditor cellEditor;

        public ViewerTextEditingSupport(ColumnViewer viewer, TranslateLanguage language) {
            super(viewer);
            this.cellEditor = new FeatureValueTextCellEditor((Composite)viewer.getControl());
            this.language = language;
        }

        protected CellEditor getCellEditor(Object element) {
            final FeatureValue fv = (FeatureValue)element;
            FeatureValueValidator.ValidationContext validationContext = new FeatureValueValidator.ValidationContext(){

                public IProject getProject() {
                    return PreviewStringsWizardPage.this.getGenerator().getProject();
                }

                public TranslationKey getTranslationKey() {
                    return fv.getContextKey();
                }

                public TranslateLanguage getLanguage() {
                    return ViewerTextEditingSupport.this.language;
                }

                public ITranslationStorageProvider.Storage getStorage() {
                    return ((ViewerTextEditingSupport)ViewerTextEditingSupport.this).PreviewStringsWizardPage.this.storageManager.getStorage(PreviewStringsWizardPage.this.getGenerator().getProject(), PreviewStringsWizardPage.this.getGenerator().getStorageId());
                }
            };
            PreviewStringsWizardPage.this.init();
            this.cellEditor.setValidator((ICellEditorValidator)new FeatureValueCellEditorValidator(PreviewStringsWizardPage.this.registry, validationContext));
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            FeatureValue value = (FeatureValue)element;
            return TranslationUtils.isValidFeatureForLanguage((FeatureSettings)value.getContextKey().getFeatureSettings(), (TranslateLanguage)this.language);
        }

        protected Object getValue(Object element) {
            FeatureValue value = (FeatureValue)element;
            String textValue = (String)value.getLocalStrings().get(this.language.getLanguageCode());
            if (textValue == null) {
                textValue = "";
            }
            return textValue;
        }

        protected void setValue(Object element, Object newValue) {
            FeatureValue value = (FeatureValue)element;
            value.getLocalStrings().put(this.language.getLanguageCode(), (String)newValue);
            PreviewStringsWizardPage.this.getGenerator().addOrUpdateValue(value);
            this.getViewer().refresh(element);
        }
    }
}

