/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.storage;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IEditingContext;
import com.e1c.langtool.storage.model.StorageSettings;
import com.e1c.langtool.ui.storage.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class StorageEntryComposite
extends Composite {
    private final IEditingContext editingContext;
    private final StorageSettings settings;
    private final ContextTranslationKey contextKey;
    private final TranslateLanguage language;
    private final IInputValidator validator;
    private ITextViewer textViewer;
    private IUndoManager undoManager;
    private Label txtLabel;
    private String textBeforeUpdate;

    public StorageEntryComposite(Composite parent, IEditingContext editingContext, StorageSettings settings, ContextTranslationKey contextKey, TranslateLanguage language, IInputValidator validator) {
        super(parent, 0);
        this.editingContext = editingContext;
        this.settings = settings;
        this.contextKey = contextKey;
        this.language = language;
        this.validator = validator;
        this.createLabelRow();
        this.createTextFieldRow();
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 30;
        this.setLayoutData(gd);
    }

    public boolean setFocus() {
        return this.textViewer.getTextWidget().setFocus();
    }

    public void refresh() {
        String value = this.editingContext.getTranslation(this.settings.getStorageId(), (TranslationKey)this.contextKey, this.language);
        this.textViewer.getTextWidget().getDisplay().asyncExec(() -> {
            if (value == null) {
                this.textViewer.getDocument().set("");
            } else {
                this.textViewer.getDocument().set(value);
            }
            this.textBeforeUpdate = value;
        });
    }

    private void createTextFieldRow() {
        int styles = 2880;
        boolean isMultiLine = this.contextKey.getFeatureSettings().isMultiLine();
        styles = isMultiLine ? 2 | styles : 4 | styles;
        if (this.settings.isReadOnly()) {
            styles = 8 | styles;
        }
        this.textViewer = new TextViewer((Composite)this, styles);
        this.textViewer.setDocument((IDocument)new Document());
        this.textViewer.getDocument().set("");
        this.undoManager = new TextViewerUndoManager(20);
        this.textViewer.setUndoManager(this.undoManager);
        this.textViewer.activatePlugins();
        this.textViewer.setEditable(!this.settings.isReadOnly());
        StyledText textBox = this.textViewer.getTextWidget();
        textBox.setOrientation(StorageEntryComposite.getOrientation(this.language.getLanguageCode()));
        FontRegistry fontRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
        Font font = fontRegistry.get("com.e1c.langtool.ui.editor.preferences.fontDefinition");
        if (font != null) {
            textBox.setFont(font);
        }
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumHeight = isMultiLine ? 40 : 10;
        textBox.setLayoutData((Object)gridData);
        FieldDecorationRegistry decRegistry = FieldDecorationRegistry.getDefault();
        FieldDecoration errorField = decRegistry.getFieldDecoration("DEC_ERROR");
        ControlDecoration decoration = new ControlDecoration((Control)textBox, 16512);
        decoration.setImage(errorField.getImage());
        gridData.horizontalIndent = decRegistry.getMaximumDecorationWidth();
        decoration.hide();
        textBox.addModifyListener(event -> textBox.getDisplay().asyncExec(() -> {
            String value = this.getTextValue();
            String errorMessage = null;
            if (StringUtils.isNotEmpty((String)value) && StringUtils.isNotEmpty((String)(errorMessage = this.validator.isValid(value)))) {
                decoration.setDescriptionText(errorMessage);
                decoration.showHoverText(errorMessage);
                decoration.show();
            } else {
                decoration.setDescriptionText("");
                decoration.showHoverText("");
                decoration.hide();
            }
        }));
    }

    private void createLabelRow() {
        Composite labelComposite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        labelComposite.setLayout((Layout)gridLayout);
        labelComposite.setLayoutData((Object)new GridData(768));
        this.txtLabel = new Label(labelComposite, 0);
        String text = this.settings.getPresentation();
        if (this.settings.isReadOnly()) {
            text = MessageFormat.format(Messages.StorageEntryComposite_N__read_only, this.settings.getPresentation());
        }
        this.txtLabel.setText(text);
    }

    private static int getOrientation(String languageCode) {
        return 0x2000000;
    }

    public boolean isDirty() {
        if (this.settings.isReadOnly()) {
            return false;
        }
        if (this.textViewer != null) {
            String result = this.textViewer.getDocument().get();
            return !result.equals(this.textBeforeUpdate);
        }
        return false;
    }

    public String getTextValue() {
        if (this.textViewer != null) {
            return this.textViewer.getDocument().get();
        }
        return "";
    }
}

