/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.tree;

import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.ui.tree.FeatureTree;
import com.e1c.langtool.ui.tree.FeatureValueItem;
import com.e1c.langtool.ui.tree.GroupItem;
import com.e1c.langtool.ui.tree.IFeatureTree;
import com.e1c.langtool.ui.tree.IFeatureValueItem;
import com.e1c.langtool.ui.tree.ITreeItem;
import com.e1c.langtool.ui.tree.ITreeItemContainer;
import com.e1c.langtool.ui.tree.ResourceItem;
import com.e1c.langtool.ui.tree.StringKeyTreeItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

public abstract class AbstractTreeFactory {
    private Map<IPath, Pair<ITreeItem, StringKeyTreeItem>> createResourceItems(Collection<FeatureValue> values) {
        HashMap<IPath, Pair<ITreeItem, StringKeyTreeItem>> resources = new HashMap<IPath, Pair<ITreeItem, StringKeyTreeItem>>();
        for (FeatureValue value : values) {
            Pair pair = (Pair)resources.get(value.getContextKey().getResourceId());
            if (pair == null) {
                pair = new Pair((Object)this.createResourceItem(value), (Object)new StringKeyTreeItem(null));
                resources.put(value.getContextKey().getResourceId(), (Pair<ITreeItem, StringKeyTreeItem>)pair);
            }
            AbstractTreeFactory.fillKeyTree((StringKeyTreeItem)pair.getValue(), value);
        }
        return resources;
    }

    private static void fillKeyTree(StringKeyTreeItem keyTree, FeatureValue value) {
        FeatureKey key = value.getContextKey().getFeatureKey();
        if (key.getSegmentCount() <= 1) {
            return;
        }
        StringKeyTreeItem parent = keyTree;
        for (String segment : key.getSegments()) {
            StringKeyTreeItem foundChild = null;
            for (StringKeyTreeItem child : parent.childs) {
                if (!segment.equals(child.key)) continue;
                foundChild = child;
                break;
            }
            if (foundChild == null) {
                foundChild = new StringKeyTreeItem(segment);
                parent.childs.add(foundChild);
            }
            parent = foundChild;
        }
    }

    protected static int getMinimalSkipKeySegment(Collection<FeatureValue> values) {
        int min = 1000;
        SegmentFeatureKey prefix = SegmentFeatureKey.EMPTY;
        for (FeatureValue value : values) {
            min = Math.min(min, value.getContextKey().getFeatureKey().getSegmentCount() - 1);
            if (!value.getContextKey().getFeatureKey().startsWith((FeatureKey)prefix)) {
                int i = 1;
                while (i <= prefix.getSegmentCount()) {
                    FeatureKey newPrefix = prefix.skipLast(i);
                    if (value.getContextKey().getFeatureKey().startsWith(newPrefix)) {
                        prefix = newPrefix;
                        min = prefix.getSegmentCount();
                        break;
                    }
                    ++i;
                }
            } else {
                prefix = value.getContextKey().getFeatureKey().skipLast(1);
            }
            if (min == 0) break;
        }
        return min;
    }

    public IFeatureTree createFeatureTree() {
        return new FeatureTree();
    }

    public IFeatureValueItem createFeatureValueItem(ITreeItem parent, FeatureValue value, int skipKeySegments) {
        return new FeatureValueItem(parent, value, skipKeySegments);
    }

    public GroupItem createGroupItem(ITreeItem parent, int skipKeySegments, FeatureKey key) {
        return new GroupItem(parent, skipKeySegments, key);
    }

    public ResourceItem createResourceItem(FeatureValue value) {
        return new ResourceItem(value.getContextKey().getResourceId());
    }

    private void createGroups(ITreeItemContainer container, StringKeyTreeItem tree, int skipSegment, FeatureKey parentKey) {
        ITreeItem parent = null;
        if (container instanceof ITreeItem) {
            parent = (ITreeItem)((Object)container);
        }
        if (tree.childs.size() != 0 || tree.key == null) {
            if (tree.childs.size() == 1) {
                FeatureKey key = tree.key != null ? parentKey.append(tree.key) : parentKey;
                this.createGroups(container, tree.childs.get(0), skipSegment, key);
            } else {
                FeatureKey key = tree.key != null ? parentKey.append(tree.key) : parentKey;
                ITreeItemContainer newParent = container;
                int newSkipSegment = skipSegment;
                if (tree.key != null) {
                    GroupItem child = this.createGroupItem(parent, skipSegment, key);
                    container.getChildren().add(child);
                    newParent = child;
                    newSkipSegment = key.getSegmentCount();
                }
                for (StringKeyTreeItem item : tree.childs) {
                    this.createGroups(newParent, item, newSkipSegment, key);
                }
            }
        }
    }

    public void fillUpTree(IFeatureTree tree, Collection<FeatureValue> values, boolean isHierarhical) {
        Map<IPath, Pair<ITreeItem, StringKeyTreeItem>> resourceItems = this.createResourceItems(values);
        boolean singleResource = resourceItems.size() == 1;
        int itemMinimalSkipKeySegment = singleResource && !isHierarhical ? AbstractTreeFactory.getMinimalSkipKeySegment(values) : 0;
        for (Pair<ITreeItem, StringKeyTreeItem> value : resourceItems.values()) {
            if (!singleResource) {
                tree.getChildren().add((ITreeItem)value.getKey());
            }
            if (singleResource && isHierarhical) {
                this.createGroups(tree, (StringKeyTreeItem)value.getValue(), itemMinimalSkipKeySegment, (FeatureKey)SegmentFeatureKey.EMPTY);
                continue;
            }
            if (!isHierarhical) continue;
            this.createGroups((ITreeItemContainer)value.getKey(), (StringKeyTreeItem)value.getValue(), itemMinimalSkipKeySegment, (FeatureKey)SegmentFeatureKey.EMPTY);
        }
        for (FeatureValue value : values) {
            boolean createGroups;
            ITreeItem parent = null;
            ITreeItemContainer container = null;
            int skipKeySegments = itemMinimalSkipKeySegment;
            Pair<ITreeItem, StringKeyTreeItem> pair = resourceItems.get(value.getContextKey().getResourceId());
            if (!singleResource) {
                parent = (ITreeItem)pair.getKey();
                container = (ITreeItemContainer)((Object)parent);
            } else {
                container = tree;
            }
            boolean bl = createGroups = isHierarhical && value.getContextKey().getFeatureKey().getSegmentCount() > 1;
            if (createGroups) {
                parent = this.findParentGroup(container, value);
            }
            if (parent != null) {
                skipKeySegments = parent.getSkippedKeySegments();
                if (parent instanceof GroupItem) {
                    skipKeySegments = ((GroupItem)parent).getKey().getSegmentCount();
                }
                container = (ITreeItemContainer)((Object)parent);
            }
            IFeatureValueItem item = this.createFeatureValueItem(parent, value, skipKeySegments);
            container.getChildren().add(item);
        }
    }

    protected ITreeItem findParentGroup(ITreeItemContainer scope, FeatureValue currentValue) {
        for (ITreeItem item : scope.getChildren()) {
            if (!(item instanceof GroupItem) || !currentValue.getContextKey().getFeatureKey().startsWith(((GroupItem)item).getKey())) continue;
            return this.findParentGroup((GroupItem)item, currentValue);
        }
        if (scope instanceof ITreeItem) {
            return (ITreeItem)((Object)scope);
        }
        return null;
    }
}

