/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ui.tree;

import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.ui.tree.ITreeItem;
import com.e1c.langtool.ui.tree.ITreeItemContainer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class GroupItem
implements ITreeItem,
ITreeItemContainer {
    private final ITreeItem parent;
    private final int skipKeySegments;
    private final FeatureKey key;
    private String presentation;
    private List<ITreeItem> children = new ArrayList<ITreeItem>();

    public GroupItem(ITreeItem parent, int skipKeySegments, FeatureKey key) {
        Assert.isLegal((skipKeySegments < key.getSegmentCount() ? 1 : 0) != 0, (String)"Skip Key Segments cannot be grater then segments in key");
        this.parent = parent;
        this.skipKeySegments = skipKeySegments;
        this.key = key;
    }

    @Override
    public List<ITreeItem> getChildren() {
        return this.children;
    }

    @Override
    public ITreeItem getParent() {
        return this.parent;
    }

    @Override
    public String getPresentation() {
        if (this.presentation == null) {
            this.presentation = this.key.skipFirst(this.skipKeySegments).toString();
        }
        return this.presentation;
    }

    @Override
    public boolean isFeatureValue() {
        return false;
    }

    @Override
    public int getSkippedKeySegments() {
        return this.skipKeySegments;
    }

    public FeatureKey getKey() {
        return this.key;
    }
}

