/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.translator;

import com.e1c.langtool.v8.dt.internal.translator.CorePlugin;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProviderDelegate;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;

@Singleton
public class NamedEObjectNameProviderDelegateRegistry {
    private static final String DELEGATE_CLASS_ATTRIBUTE = "class";
    private static final String EXTENSION_POINT_ID = "namedEObjectNameProvider";
    private volatile Collection<INamedEObjectNameProviderDelegate> delegates;

    public Collection<INamedEObjectNameProviderDelegate> getDelegates(EClass eClass) {
        ArrayList<INamedEObjectNameProviderDelegate> result = new ArrayList<INamedEObjectNameProviderDelegate>();
        block0: for (INamedEObjectNameProviderDelegate delegate : this.getDelegates()) {
            for (EClass supportEClass : delegate.getSupportEClass()) {
                if (!supportEClass.isSuperTypeOf(eClass)) continue;
                result.add(delegate);
                continue block0;
            }
        }
        if (result.size() > 1) {
            Collections.sort(result, this::compareDelegates);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<INamedEObjectNameProviderDelegate> getDelegates() {
        if (this.delegates == null) {
            NamedEObjectNameProviderDelegateRegistry namedEObjectNameProviderDelegateRegistry = this;
            synchronized (namedEObjectNameProviderDelegateRegistry) {
                if (this.delegates != null) {
                    return this.delegates;
                }
                this.delegates = this.loadDelegates();
            }
        }
        return this.delegates;
    }

    private List<INamedEObjectNameProviderDelegate> loadDelegates() {
        ArrayList<INamedEObjectNameProviderDelegate> delegatesList = new ArrayList<INamedEObjectNameProviderDelegate>();
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.e1c.langtool.v8.dt.translator", EXTENSION_POINT_ID);
        int i = 0;
        while (i < config.length) {
            IConfigurationElement configElement = config[i];
            try {
                INamedEObjectNameProviderDelegate e = (INamedEObjectNameProviderDelegate)configElement.createExecutableExtension(DELEGATE_CLASS_ATTRIBUTE);
                delegatesList.add(e);
                for (EClass eClass : e.orderBeforeEClass()) {
                    Optional<EClass> found = e.getSupportEClass().stream().filter(c -> c.isSuperTypeOf(eClass)).findAny();
                    if (!found.isPresent()) continue;
                    String message = MessageFormat.format("Class \"{0}\" has order error:  supported class \"{1}\" is super type of before class \"{2}\"", e.getClass().getName(), found.get().getName(), eClass.getName());
                    CorePlugin.log(CorePlugin.createErrorStatus(message, null));
                }
            }
            catch (CoreException e) {
                CorePlugin.logError(e);
            }
            ++i;
        }
        Collections.sort(delegatesList, (o1, o2) -> o1.order() - o2.order());
        return List.copyOf(delegatesList);
    }

    private int compareDelegates(INamedEObjectNameProviderDelegate o1, INamedEObjectNameProviderDelegate o2) {
        for (EClass eClass : o1.orderBeforeEClass()) {
            if (!o2.getSupportEClass().stream().anyMatch(support -> eClass == support || support.isSuperTypeOf(eClass))) continue;
            return -1;
        }
        for (EClass eClass : o2.orderBeforeEClass()) {
            if (!o1.getSupportEClass().stream().anyMatch(support -> eClass == support)) continue;
            return 1;
        }
        int order = o1.order() - o2.order();
        if (order == 0) {
            order = o1.hashCode() - o2.hashCode();
        }
        return order;
    }
}

