/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.translator;

import com._1c.g5.v8.bm.core.IBmNamespace;
import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmPlatformTransaction;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.bsl.model.Module;
import com._1c.g5.v8.dt.common.StringUtils;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.md.IExternalPropertyManagerRegistry;
import com._1c.g5.v8.dt.metadata.IExternalPropertyManager;
import com._1c.g5.v8.dt.metadata.mdclass.AbstractForm;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.metadata.mdclass.MdObject;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.v8.dt.internal.translator.CorePlugin;
import com.e1c.langtool.v8.dt.translator.DelegatingObjectFeature;
import com.e1c.langtool.v8.dt.translator.DependentObjectID;
import com.e1c.langtool.v8.dt.translator.DependentObjectIdImpl;
import com.e1c.langtool.v8.dt.translator.MdObjectIdImpl;
import com.e1c.langtool.v8.dt.translator.ObjectFeature;
import com.e1c.langtool.v8.dt.translator.ObjectFeatureImpl;
import com.e1c.langtool.v8.dt.translator.V8ObjectID;
import com.e1c.langtool.v8.dt.translator.V8ObjectIdObjectResolver;
import com.e1c.langtool.v8.dt.translator.V8ObjectIdProvider;
import com.e1c.langtool.v8.dt.translator.V8ObjectIdProviderDelegate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.CancelIndicator;

@Singleton
public class ObjectIdentificatorProvider
implements V8ObjectIdProvider {
    private static final String EXTENSION_POINT_ID = "com.e1c.langtool.v8.dt.translator.v8ObjectIdProvider";
    private static final String ATT_CLASS = "class";
    private static final String DELEGATE_NAME = "delegate";
    private static final String RESOLVER_NAME = "resolver";
    @Inject
    private IBmModelManager modelManager;
    @Inject
    private IExternalPropertyManagerRegistry externalPropertyManagerRegistry;
    private volatile Map<EClass, V8ObjectIdProviderDelegate> delegates;
    private volatile Map<Pair<EClass, EClass>, V8ObjectIdObjectResolver> resolvers;

    @Override
    public EObject getObjectOrProxy(IProject project, V8ObjectID id) {
        if (id == null || project == null) {
            return null;
        }
        IBmModel model = this.modelManager.getModel(project);
        IBmTransaction transaction = model.getEngine().getCurrentTransaction();
        boolean isNewTransaction = false;
        if (transaction == null) {
            transaction = model.getEngine().beginReadOnlyTransaction(true);
            isNewTransaction = true;
        }
        try {
            EObject root = this.getEObject(id.getUuid(), project);
            if (root instanceof IBmObject && ((IBmObject)root).bmGetEngine() != null) {
                root = transaction.toTransactionObject(root);
            }
            if (root != null && id instanceof DependentObjectID) {
                root = this.getChildObject(root, ((DependentObjectID)id).getChildFeatures(), transaction);
            }
            EObject eObject = root;
            return eObject;
        }
        finally {
            if (isNewTransaction) {
                transaction.commit();
            }
        }
    }

    @Override
    public EObject getChildObject(EObject root, Collection<ObjectFeature> childFeatures) {
        return this.getChildObject(root, childFeatures, null);
    }

    @Override
    public V8ObjectID getId(EObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof MdObject) {
            return new MdObjectIdImpl(this.getMdObjectContainerUuid(object));
        }
        ArrayDeque<ObjectFeature> features = new ArrayDeque<ObjectFeature>();
        EObject parent = object;
        while (parent != null && !(parent instanceof MdObject)) {
            ObjectFeature v8ObjectFeature;
            V8ObjectIdProviderDelegate delegate = this.getDelegate(parent.eClass());
            EStructuralFeature feature = null;
            feature = delegate != null ? delegate.getContainingFeature(parent) : this.getContainingFeature(parent);
            if (feature != null) {
                v8ObjectFeature = null;
                if (feature.isMany()) {
                    int index = 0;
                    EObject container = delegate != null ? delegate.getParent(parent) : this.getParent(parent);
                    Object value = container.eGet(feature);
                    if (value instanceof List) {
                        index = ((List)value).indexOf(parent);
                    } else {
                        boolean cfr_ignored_0 = value instanceof Map;
                    }
                    v8ObjectFeature = delegate != null ? delegate.creatreFeature(parent, feature, index) : new ObjectFeatureImpl(feature, index);
                } else {
                    v8ObjectFeature = delegate != null ? delegate.creatreFeature(parent, feature) : new ObjectFeatureImpl(feature);
                }
            } else {
                return null;
            }
            features.addFirst(v8ObjectFeature);
            EObject eObject = parent = delegate != null ? delegate.getParent(parent) : this.getParent(parent);
        }
        if (parent == null) {
            return null;
        }
        return new DependentObjectIdImpl(this.getMdObjectContainerUuid(parent), features);
    }

    private V8ObjectIdProviderDelegate getDelegate(EClass eClass) {
        return this.getDelegates().get(eClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<EClass, V8ObjectIdProviderDelegate> getDelegates() {
        if (this.delegates != null) return this.delegates;
        Class<ObjectIdentificatorProvider> clazz = ObjectIdentificatorProvider.class;
        synchronized (ObjectIdentificatorProvider.class) {
            HashMap loaded = Maps.newHashMap();
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement configElement = elements[i];
                if (DELEGATE_NAME.equals(configElement.getName())) {
                    try {
                        V8ObjectIdProviderDelegate e = (V8ObjectIdProviderDelegate)configElement.createExecutableExtension(ATT_CLASS);
                        for (EClass eClass : e.getSupportedObjects()) {
                            if (loaded.containsKey(eClass)) {
                                CorePlugin.log(CorePlugin.createErrorStatus(MessageFormat.format("V8ObjectId Provider Delegate EClass {0} duplicate", eClass.getInstanceClassName()), null));
                                continue;
                            }
                            loaded.put(eClass, e);
                        }
                    }
                    catch (CoreException e) {
                        CorePlugin.logError(e);
                    }
                }
                ++i;
            }
            this.delegates = ImmutableMap.copyOf((Map)loaded);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.delegates;
        }
    }

    private UUID getMdObjectContainerUuid(EObject object) {
        MdObject mdObject = (MdObject)EcoreUtil2.getContainerOfType((EObject)object, MdObject.class);
        if (mdObject != null && object.eIsProxy()) {
            EcoreUtil2.resolveAll((EObject)mdObject, (CancelIndicator)CancelIndicator.NullImpl);
        }
        if (mdObject != null) {
            return mdObject.getUuid();
        }
        return null;
    }

    private EObject getParent(EObject object) {
        URI uri;
        if (object instanceof AbstractForm) {
            return ((AbstractForm)object).getMdForm();
        }
        if (object instanceof Module) {
            return ((Module)object).getOwner();
        }
        EObject parent = object.eContainer();
        if (!(parent != null || (uri = EcoreUtil.getURI((EObject)object)).isPlatformResource() && uri.fileExtension().equals("mdo") || uri.hasFragment() && !uri.fragment().equals("/") || uri.segmentCount() <= 0)) {
            IBmModel model = this.modelManager.getModel(uri);
            IExternalPropertyManager externalPropertyManager = this.externalPropertyManagerRegistry.getExternalPropertyManager(model);
            parent = externalPropertyManager.getOwner(object, EObject.class);
        }
        return parent;
    }

    private EStructuralFeature getContainingFeature(EObject object) {
        URI uri;
        if (object instanceof AbstractForm) {
            return MdClassPackage.Literals.BASIC_FORM__FORM;
        }
        EStructuralFeature feature = object.eContainingFeature();
        if (feature == null && (!(uri = EcoreUtil.getURI((EObject)object)).hasFragment() || uri.fragment().equals("/") || uri.fragment().equals("/0"))) {
            IBmModel model = this.modelManager.getModel(uri);
            if (model != null) {
                IExternalPropertyManager externalPropertyManager = this.externalPropertyManagerRegistry.getExternalPropertyManager(model);
                feature = externalPropertyManager.getReference(object);
            } else {
                EObject parent = this.getParent(object);
                if (parent != null) {
                    String name = uri.trimFragment().trimFileExtension().segment(uri.segmentCount() - 1);
                    name = StringUtils.uncapitalize((String)name);
                    for (EStructuralFeature parentFeature : parent.eClass().getEAllStructuralFeatures()) {
                        EAnnotation anatation;
                        if (!parentFeature.isTransient() || (anatation = parentFeature.getEAnnotation("http://www.1c.ru/v8/dt/common/ExternalProperty")) == null || !parentFeature.getName().equals(name)) continue;
                        return parentFeature;
                    }
                }
            }
        }
        return feature;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EObject getChildObject(EObject root, Collection<ObjectFeature> childFeatures, IBmTransaction transaction) {
        EObject current = root;
        for (ObjectFeature objectFeature : childFeatures) {
            Object value;
            EClass eClass = current.eClass();
            if (objectFeature instanceof DelegatingObjectFeature) {
                V8ObjectIdObjectResolver reslover = this.getResolver(eClass, ((DelegatingObjectFeature)objectFeature).getEClass());
                value = reslover == null ? null : reslover.resolveObject(current, (DelegatingObjectFeature)objectFeature);
            } else {
                if (!eClass.getEAllStructuralFeatures().contains((Object)objectFeature.getFeature())) return null;
                value = current.eGet(objectFeature.getFeature());
            }
            if (transaction != null && value instanceof IBmObject && ((IBmObject)value).bmIsTop() && ((IBmObject)value).bmGetEngine() != null) {
                value = transaction.toTransactionObject((EObject)((IBmObject)value));
            }
            if (objectFeature.getFeature().isMany()) {
                if (value instanceof List) {
                    if (((List)value).size() <= objectFeature.getIndex()) return null;
                    value = ((List)value).get(objectFeature.getIndex());
                } else if (value instanceof Map) {
                    if (((Map)value).size() <= objectFeature.getIndex()) return null;
                    value = ((Map)value).entrySet().toArray()[objectFeature.getIndex()];
                }
                if (transaction != null && value instanceof IBmObject && ((IBmObject)value).bmIsTop() && ((IBmObject)value).bmGetEngine() != null) {
                    value = transaction.toTransactionObject((EObject)((IBmObject)value));
                }
            }
            if (!(value instanceof EObject)) return null;
            if (((EObject)value).eIsProxy() && current instanceof IBmObject && objectFeature.getFeature().equals(MdClassPackage.Literals.BASIC_TEMPLATE__TEMPLATE)) {
                current = (EObject)value;
                if (transaction == null || !(current instanceof IBmObject) || !((IBmObject)current).bmIsTop()) continue;
                current = transaction.toTransactionObject((EObject)((IBmObject)current));
                continue;
            }
            current = (EObject)value;
        }
        return current;
    }

    private V8ObjectIdObjectResolver getResolver(EClass source, EClass target) {
        return this.getResolvers().get(new Pair((Object)source, (Object)target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<Pair<EClass, EClass>, V8ObjectIdObjectResolver> getResolvers() {
        if (this.resolvers != null) return this.resolvers;
        Class<ObjectIdentificatorProvider> clazz = ObjectIdentificatorProvider.class;
        synchronized (ObjectIdentificatorProvider.class) {
            HashMap loaded = Maps.newHashMap();
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement configElement = elements[i];
                if (RESOLVER_NAME.equals(configElement.getName())) {
                    try {
                        V8ObjectIdObjectResolver e = (V8ObjectIdObjectResolver)configElement.createExecutableExtension(ATT_CLASS);
                        for (EClass eClass : e.getSourceObjects()) {
                            Pair key = new Pair((Object)eClass, (Object)e.getTargetObject());
                            if (loaded.containsKey(key)) {
                                CorePlugin.log(CorePlugin.createErrorStatus(MessageFormat.format("V8ObjectId Provider Resolver from EClass {0} to EClass {1} duplicate", eClass.getInstanceClassName(), e.getTargetObject().getInstanceClass()), null));
                                continue;
                            }
                            loaded.put(key, e);
                        }
                    }
                    catch (CoreException e) {
                        CorePlugin.logError(e);
                    }
                }
                ++i;
            }
            this.resolvers = ImmutableMap.copyOf((Map)loaded);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.resolvers;
        }
    }

    private EObject getEObject(UUID objectUuid, IProject project) {
        IBmNamespace ns = this.modelManager.getBmNamespace(project);
        if (ns == null) {
            return null;
        }
        return this.getObjectByUuid(ns, objectUuid);
    }

    private IBmObject getObjectByUuid(IBmNamespace ns, UUID uuid) {
        IBmPlatformTransaction transaction = this.modelManager.getBmPlatform().getCurrentTransaction();
        if (transaction != null) {
            return this.getObjectByUuid(transaction, ns, uuid);
        }
        return (IBmObject)this.modelManager.executeReadOnlyTask(bmTransaction -> this.getObjectByUuid(bmTransaction, ns, uuid));
    }

    private IBmObject getObjectByUuid(IBmPlatformTransaction transaction, IBmNamespace ns, UUID uuid) {
        Iterator it = transaction.getObjectsByAttributeValue(ns, MdClassPackage.Literals.MD_OBJECT__UUID, (Object)uuid);
        if (it.hasNext()) {
            return (IBmObject)it.next();
        }
        return null;
    }
}

