/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.translator;

import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.naming.ITranslationFeatureKeyProvider;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.ModelValueProviderExtension;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.e1c.langtool.v8.dt.translator.IComputedStringFeatureTranslationProvider;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractSplittedStringTranslationExistTranslationProvider
implements IComputedStringFeatureTranslationProvider {
    protected static final String SPLIT_REGEX_DOT = "\\.";
    protected static final String SPLIT_REGEX_ALL = "[\\. ,\\(\\)]+";
    protected final ITranslatingProjectManager translatingProjectManager;
    protected final IResourceLookup resourceLookup;
    protected final ITranslationFeatureKeyProvider translationFeatureKeyProvider;
    protected final ITranslationStorageManager storageManager;

    protected AbstractSplittedStringTranslationExistTranslationProvider(ITranslatingProjectManager translatingProjectManager, IResourceLookup resourceLookup, ITranslationFeatureKeyProvider translationFeatureKeyProvider, ITranslationStorageManager storageManager) {
        this.translatingProjectManager = translatingProjectManager;
        this.resourceLookup = resourceLookup;
        this.translationFeatureKeyProvider = translationFeatureKeyProvider;
        this.storageManager = storageManager;
    }

    public boolean isComputedString(EObject object, EFeatureSettings stringFeature) {
        if (!this.getSupportedFeatures().contains(stringFeature)) {
            return false;
        }
        String value = this.getFeatureValue(object, stringFeature);
        if (StringUtils.isBlank((String)value) || StringUtils.isNotWord((String)value)) {
            return false;
        }
        String[] parts = value.split(this.getSplitRegex());
        if (parts.length == 0 || parts.length == 1 && parts[0].length() == value.length()) {
            return false;
        }
        IProject project = this.resourceLookup.getProject(object);
        if (project == null) {
            return false;
        }
        ITranslatingProject translating = this.translatingProjectManager.getProject(project);
        if (!translating.isTranslating() || translating.getModelLanguages().isEmpty()) {
            return false;
        }
        IProjectTranslationReader reader = this.storageManager.getTranslationReader(project);
        IFile file = this.resourceLookup.getPlatformResource(object);
        FeatureKey featurePreffix = this.translationFeatureKeyProvider.getFeatureKey(object, (FeatureSettings)stringFeature);
        FeatureSettings partSettings = this.getPartSettings(object, stringFeature);
        for (TranslateLanguage language : translating.getModelLanguages()) {
            int i = 0;
            while (i < parts.length) {
                String part = parts[i];
                if (!StringUtils.isBlank((String)part)) {
                    if (!this.isValidPart(part = part.trim(), object, value)) {
                        return false;
                    }
                    FeatureKey featureKey = featurePreffix.append(part).append(partSettings.getName());
                    ContextTranslationKeyImpl key = new ContextTranslationKeyImpl(file, featureKey, partSettings, part);
                    String translation = reader.getStoredTranslation((TranslationKey)key, language, new ITranslationStorageProvider.Storage.Type[0]);
                    if (StringUtils.isNullOrEmpty((String)translation)) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public String computeTranslatedString(EObject object, EFeatureSettings stringFeature, IProjectTranslationProvider translationProvider, TranslateLanguage language) {
        String value = this.getFeatureValue(object, stringFeature);
        String[] parts = value.split(this.getSplitRegex());
        IProject project = this.resourceLookup.getProject(object);
        if (project == null) {
            return null;
        }
        IFile file = this.resourceLookup.getPlatformResource(object);
        FeatureKey featurePreffix = this.translationFeatureKeyProvider.getFeatureKey(object, (FeatureSettings)stringFeature);
        FeatureSettings partSettings = this.getPartSettings(object, stringFeature);
        StringBuilder sb = new StringBuilder();
        int current = 0;
        int i = 0;
        while (i < parts.length) {
            String part = parts[i];
            if (!StringUtils.isBlank((String)part)) {
                FeatureKey featureKey;
                ContextTranslationKeyImpl key;
                String translation;
                int index = value.indexOf(part = part.trim(), current);
                if (index == -1) {
                    return null;
                }
                if (index > current) {
                    sb.append(value.substring(current, index));
                }
                if (StringUtils.isNullOrEmpty((String)(translation = translationProvider.getStoredTranslation((ContextTranslationKey)(key = new ContextTranslationKeyImpl(file, featureKey = featurePreffix.append(part).append(partSettings.getName()), partSettings, part)), language, new ITranslationStorageProvider.Storage.Type[0])))) {
                    return null;
                }
                sb.append(translation);
                current = index + part.length();
            }
            ++i;
        }
        if (current < value.length()) {
            sb.append(value.substring(current));
        }
        return sb.toString();
    }

    protected FeatureSettings getPartSettings(EObject object, EFeatureSettings stringFeature) {
        return McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME;
    }

    protected abstract String getSplitRegex();

    protected abstract Set<FeatureSettings> getSupportedFeatures();

    protected abstract boolean isValidPart(String var1, EObject var2, String var3);

    private String getFeatureValue(EObject object, EFeatureSettings stringFeature) {
        if (stringFeature instanceof ModelValueProviderExtension) {
            return ((ModelValueProviderExtension)stringFeature).getValue((Object)object);
        }
        return (String)object.eGet(stringFeature.getEFeature());
    }
}

