/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.translator;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.internal.translator.CorePlugin;
import com.e1c.langtool.v8.dt.translator.SessionCache;
import com.google.inject.Provider;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class AbstractStringTranslationCache
implements SessionCache {
    private static final int CACHE_SIZE = 64000;
    private static final int ASYNC_WRITE_DELAY = 1000;
    private volatile DB db;
    private volatile ConcurrentMap<String, String> cache;

    protected String get(String key) {
        Assert.isNotNull((Object)key);
        this.checkInit();
        return (String)this.cache.get(key);
    }

    protected String get(String key, Provider<String> provider) {
        String computed;
        Assert.isNotNull((Object)key);
        this.checkInit();
        String translation = (String)this.cache.get(key);
        if (StringUtils.isNullOrEmpty((String)translation) && StringUtils.isNotEmpty((String)(computed = (String)provider.get()))) {
            try {
                this.cache.put(key, computed);
            }
            catch (Throwable e) {
                IStatus status = CorePlugin.createErrorStatus("Cannot put data to translation cache", e);
                CorePlugin.log(status);
            }
            translation = computed;
        }
        return translation;
    }

    protected void put(String key, String translation) {
        Assert.isNotNull((Object)key);
        this.checkInit();
        try {
            this.cache.put(key, translation);
        }
        catch (Throwable e) {
            IStatus status = CorePlugin.createErrorStatus("Cannot put data to translation cache", e);
            CorePlugin.log(status);
        }
    }

    protected String remove(String key) {
        Assert.isNotNull((Object)key);
        this.checkInit();
        try {
            return (String)this.cache.remove(key);
        }
        catch (Throwable e) {
            IStatus status = CorePlugin.createErrorStatus("Cannot remove data from translation cache", e);
            CorePlugin.log(status);
            return null;
        }
    }

    @Override
    public void clear() {
        this.dispose();
    }

    protected synchronized void dispose() {
        if (this.db != null && !this.db.isClosed()) {
            try {
                this.db.close();
            }
            catch (Throwable e) {
                IStatus status = CorePlugin.createErrorStatus("Failed to close temp translation cache", e);
                CorePlugin.log(status);
            }
        }
        this.cache = null;
        this.db = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInit() {
        if (this.db != null && this.cache != null) {
            return;
        }
        AbstractStringTranslationCache abstractStringTranslationCache = this;
        synchronized (abstractStringTranslationCache) {
            if (this.db == null || this.cache == null) {
                this.initialize();
            }
        }
    }

    private synchronized void initialize() {
        DBMaker dbMaker = DBMaker.newTempFileDB();
        this.configureDb(dbMaker);
        this.db = dbMaker.make();
        this.cache = this.getCacheMap(this.db);
    }

    protected void configureDb(DBMaker<?> dbMaker) {
        dbMaker.transactionDisable().closeOnJvmShutdown().deleteFilesAfterClose().cacheSize(64000).cacheLRUEnable().asyncWriteEnable().asyncWriteFlushDelay(1000).snapshotEnable();
    }

    protected synchronized ConcurrentMap<String, String> getCacheMap(DB db) {
        return db.createHashMap("cache").counterEnable().makeOrGet();
    }
}

