/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.translator;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.v8.dt.translator.AbstractStringTranslationCache;
import com.google.inject.Provider;
import java.util.concurrent.ConcurrentMap;
import org.mapdb.DB;

public class ModelStringsContextTranslationCache
extends AbstractStringTranslationCache {
    public String getTranslation(ContextTranslationKey key) {
        String stringKey = this.getKey(key);
        return this.get(stringKey);
    }

    public String getTranslation(ContextTranslationKey key, Provider<String> provider) {
        String stringKey = this.getKey(key);
        return this.get(stringKey, provider);
    }

    public void putTranslation(ContextTranslationKey key, String translation) {
        String stringKey = this.getKey(key);
        this.put(stringKey, translation);
    }

    private String getKey(ContextTranslationKey key) {
        return key.getFullPath() + ":" + key.getFeatureKey().toString();
    }

    @Override
    protected synchronized ConcurrentMap<String, String> getCacheMap(DB db) {
        return db.createTreeMap("cache").counterEnable().valuesOutsideNodesEnable().makeOrGet();
    }
}

