/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.translator;

import com._1c.g5.v8.dt.mcore.McorePackage;
import com._1c.g5.v8.dt.mcore.NamedElement;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.settings.McoreFeatureSettings;
import com.e1c.langtool.v8.dt.translator.INamedEObjectNameProviderDelegate;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ModelNameTranslationCache;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class NamedElementNameProvider
implements INamedEObjectNameProviderDelegate {
    @Override
    public Pair<String, String> getTranslatedName(EObject object, IProjectTranslationProvider translationProvider) {
        if (object instanceof NamedElement) {
            NamedElement obj = (NamedElement)object;
            String name = obj.getName();
            Provider provider = () -> {
                if (!translationProvider.getProject().isChangeDefaultLanguage()) {
                    return name;
                }
                TranslateLanguage language = translationProvider.getProject().getDefaultLanguage();
                Optional<String> newName = translationProvider.getOptionalTranslation((EObject)obj, McoreFeatureSettings.Literals.NAMED_ELEMENT__NAME, language);
                return newName.orElse(name);
            };
            URI objectUri = EcoreUtil.getURI((EObject)object);
            ModelNameTranslationCache cache = translationProvider.getCache(ModelNameTranslationCache.class);
            String translation = cache.getTranslation(objectUri, (Provider<String>)provider);
            return new Pair((Object)name, (Object)translation);
        }
        return null;
    }

    @Override
    public String getName(EObject object) {
        if (object instanceof NamedElement) {
            NamedElement obj = (NamedElement)object;
            return obj.getName();
        }
        return null;
    }

    @Override
    public Collection<EClass> getSupportEClass() {
        return List.of(McorePackage.Literals.NAMED_ELEMENT);
    }

    @Override
    public int order() {
        return 10000;
    }
}

