/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.translator;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.generatestring.InvalidStorageIdException;
import com.e1c.langtool.generatestring.Messages;
import com.e1c.langtool.generatestring.ProjectGenerateTranslationStrings;
import com.e1c.langtool.generatestring.TempFileFeatureCollection;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.internal.translator.CorePlugin;
import com.e1c.langtool.v8.dt.translator.V8ObjectID;
import com.e1c.langtool.v8.dt.translator.V8ObjectIdProvider;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.Nullable;

public class TranslatedProjectImportTranslationStrings
extends ProjectGenerateTranslationStrings {
    @Inject
    private V8ObjectIdProvider v8ObjectIdProvider;
    private ITranslatedProject translatedProject;
    private boolean replaceExistingTranslations = false;

    protected boolean collectStrings(TranslationSource object, IProgressMonitor monitor) {
        HashSet translateLanguages = Sets.newHashSet((Iterable)this.getLanguages());
        CollectingParameters.Builder builder = CollectingParameters.builder();
        builder.collectChildObjects().collectSubResources().setCollectModelType(this.getCollectModelType()).setLanguages((Set)translateLanguages).disableCache();
        if (this.isCollectModelStrings()) {
            builder.collectModel();
        }
        if (this.isCollectInterfaceStrings()) {
            builder.collectInterface();
        }
        if (this.isContinueAfterFirstError()) {
            builder.continueAfterFirstError();
        }
        CollectingParameters parameters = builder.build();
        monitor.beginTask(MessageFormat.format(Messages.ProjectGenerateTranslationStrings_CollectingStringsFrom, object.getId()), -1);
        TempFileFeatureCollection collectedValues = this.getCollectedValues();
        long collectMillis = System.currentTimeMillis();
        this.collectingService.forEachCollected(object, (ICollectingParameters)parameters, monitor, (arg_0, arg_1) -> this.lambda$0((Collection)collectedValues, arg_0, arg_1));
        if (CorePlugin.getDefault().isDebugging()) {
            CorePlugin.log(CorePlugin.createWarningStatus("[collectString] Foreach time: " + (System.currentTimeMillis() - collectMillis)));
        }
        if (!parameters.getErrors().isEmpty()) {
            this.getErrors().addAll(parameters.getErrors());
        }
        long millis = System.currentTimeMillis();
        boolean fillupResult = this.fillUpCollectedValues(monitor);
        if (CorePlugin.getDefault().isDebugging()) {
            CorePlugin.log(CorePlugin.createWarningStatus("[collectString] fillUpCollectedValues time: " + (System.currentTimeMillis() - millis)));
        }
        return fillupResult;
    }

    private void updateFeatureValueTranslation(EObject source, FeatureValue fv) {
        TranslationSource targetTranslationSource;
        if (!(fv.getContextKey().getFeatureSettings() instanceof EFeatureSettings)) {
            return;
        }
        @Nullable V8ObjectID id = this.v8ObjectIdProvider.getId(source);
        if (id == null) {
            return;
        }
        EObject target = this.v8ObjectIdProvider.getObjectOrProxy(this.translatedProject.getProject(), id);
        if (target == null) {
            return;
        }
        if ((target = EcoreUtil.resolve((EObject)target, (EObject)source)).eIsProxy()) {
            return;
        }
        EFeatureSettings settings = (EFeatureSettings)fv.getContextKey().getFeatureSettings();
        Object value = target.eGet(settings.getEFeature());
        if (settings.isInterface() && value instanceof Map) {
            Map map = (Map)value;
            for (TranslateLanguage language : this.getLanguages()) {
                fv.getLocalStrings().put(language.getLanguageCode(), (String)map.get(language.getLanguageCode()));
            }
        } else if (settings.isInterface() && value instanceof EMap) {
            EMap map = (EMap)value;
            for (TranslateLanguage language : this.getLanguages()) {
                fv.getLocalStrings().put(language.getLanguageCode(), (String)map.get((Object)language.getLanguageCode()));
            }
        } else if (value instanceof String) {
            fv.getLocalStrings().put(this.translatedProject.getDefaultLanguage().getLanguageCode(), (String)value);
        } else if (value != null && (targetTranslationSource = TranslationUtils.getTranslationSource((Object)target)) != null) {
            this.collectingService.forEachCollected(targetTranslationSource, this.createCollectingParameters(), (IProgressMonitor)new NullProgressMonitor(), (obj, targetFv) -> {
                if (fv.getContextKey().getFeatureSettings().equals(targetFv.getContextKey().getFeatureSettings()) && !targetFv.getLocalStrings().isEmpty()) {
                    fv.getLocalStrings().putAll(targetFv.getLocalStrings());
                }
            });
        }
    }

    protected boolean fillUpCollectedValues(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        if (this.isReplaceExistingTranslations()) {
            return true;
        }
        ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(this.getProject(), this.getStorageId());
        if (storage == null) {
            InvalidStorageIdException e = new InvalidStorageIdException(MessageFormat.format(Messages.ProjectGenerateTranslationStrings_UnknownStorageId, this.getStorageId()));
            this.getErrors().add(e);
            return false;
        }
        SubMonitor iterSubMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getCollectedValues().size());
        Iterator iterator = this.getCollectedValues().iterator();
        while (iterator.hasNext()) {
            if (monitor.isCanceled()) {
                return false;
            }
            FeatureValue featureValue = (FeatureValue)iterator.next();
            for (TranslateLanguage language : this.getLanguages()) {
                String translation;
                if (monitor.isCanceled()) {
                    return false;
                }
                if (!TranslationUtils.isValidFeatureForLanguage((FeatureSettings)featureValue.getContextKey().getFeatureSettings(), (TranslateLanguage)language) || !StringUtils.isNotEmpty((String)(translation = storage.getTranslation(featureValue, language)))) continue;
                this.getCollectedValues().remove((Object)featureValue);
            }
            iterSubMonitor.worked(1);
        }
        iterSubMonitor.done();
        return true;
    }

    public ITranslatedProject getTranslatedProject() {
        return this.translatedProject;
    }

    public void setTranslatedProject(ITranslatedProject translatedProject) {
        this.translatedProject = translatedProject;
    }

    public boolean isReplaceExistingTranslations() {
        return this.replaceExistingTranslations;
    }

    public void setReplaceExistingTranslations(boolean replaceExistingTranslations) {
        this.replaceExistingTranslations = replaceExistingTranslations;
    }

    private /* synthetic */ void lambda$0(Collection collection, Object sourceObject, FeatureValue feature) {
        if (sourceObject instanceof EObject) {
            this.updateFeatureValueTranslation((EObject)sourceObject, feature);
        }
        collection.add(feature);
    }
}

